/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * config_file_arg;	/**< @brief Configuration file to read (default='./yubihsm_pkcs11.conf').  */
  char * config_file_orig;	/**< @brief Configuration file to read original value given at command line.  */
  const char *config_file_help; /**< @brief Configuration file to read help description.  */
  char ** connector_arg;	/**< @brief List of connectors to use.  */
  char ** connector_orig;	/**< @brief List of connectors to use original value given at command line.  */
  unsigned int connector_min; /**< @brief List of connectors to use's minimum occurreces */
  unsigned int connector_max; /**< @brief List of connectors to use's maximum occurreces */
  const char *connector_help; /**< @brief List of connectors to use help description.  */
  int debug_flag;	/**< @brief Enable pkcs11 debugging (default=off).  */
  const char *debug_help; /**< @brief Enable pkcs11 debugging help description.  */
  int dinout_flag;	/**< @brief Enable pkcs11 function tracing (default=off).  */
  const char *dinout_help; /**< @brief Enable pkcs11 function tracing help description.  */
  int libdebug_flag;	/**< @brief Enable libyubihsm debugging (default=off).  */
  const char *libdebug_help; /**< @brief Enable libyubihsm debugging help description.  */
  char * debug_file_arg;	/**< @brief Output file for debugging (default='stderr').  */
  char * debug_file_orig;	/**< @brief Output file for debugging original value given at command line.  */
  const char *debug_file_help; /**< @brief Output file for debugging help description.  */
  char * cacert_arg;	/**< @brief Cacert to use for HTTPS validation.  */
  char * cacert_orig;	/**< @brief Cacert to use for HTTPS validation original value given at command line.  */
  const char *cacert_help; /**< @brief Cacert to use for HTTPS validation help description.  */
  char * cert_arg;	/**< @brief HTTPS client certificate to authenticate with.  */
  char * cert_orig;	/**< @brief HTTPS client certificate to authenticate with original value given at command line.  */
  const char *cert_help; /**< @brief HTTPS client certificate to authenticate with help description.  */
  char * key_arg;	/**< @brief HTTPS client certificate key.  */
  char * key_orig;	/**< @brief HTTPS client certificate key original value given at command line.  */
  const char *key_help; /**< @brief HTTPS client certificate key help description.  */
  char * proxy_arg;	/**< @brief Proxy server to use for connector.  */
  char * proxy_orig;	/**< @brief Proxy server to use for connector original value given at command line.  */
  const char *proxy_help; /**< @brief Proxy server to use for connector help description.  */
  char * noproxy_arg;	/**< @brief Comma separated list of hosts ignore proxy for.  */
  char * noproxy_orig;	/**< @brief Comma separated list of hosts ignore proxy for original value given at command line.  */
  const char *noproxy_help; /**< @brief Comma separated list of hosts ignore proxy for help description.  */
  int timeout_arg;	/**< @brief Timeout to use for initial connection to connector (default='5').  */
  char * timeout_orig;	/**< @brief Timeout to use for initial connection to connector original value given at command line.  */
  const char *timeout_help; /**< @brief Timeout to use for initial connection to connector help description.  */
  char ** device_pubkey_arg;	/**< @brief List of device public keys allowed for asymmetric authentication.  */
  char ** device_pubkey_orig;	/**< @brief List of device public keys allowed for asymmetric authentication original value given at command line.  */
  unsigned int device_pubkey_min; /**< @brief List of device public keys allowed for asymmetric authentication's minimum occurreces */
  unsigned int device_pubkey_max; /**< @brief List of device public keys allowed for asymmetric authentication's maximum occurreces */
  const char *device_pubkey_help; /**< @brief List of device public keys allowed for asymmetric authentication help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int config_file_given ;	/**< @brief Whether config-file was given.  */
  unsigned int connector_given ;	/**< @brief Whether connector was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int dinout_given ;	/**< @brief Whether dinout was given.  */
  unsigned int libdebug_given ;	/**< @brief Whether libdebug was given.  */
  unsigned int debug_file_given ;	/**< @brief Whether debug-file was given.  */
  unsigned int cacert_given ;	/**< @brief Whether cacert was given.  */
  unsigned int cert_given ;	/**< @brief Whether cert was given.  */
  unsigned int key_given ;	/**< @brief Whether key was given.  */
  unsigned int proxy_given ;	/**< @brief Whether proxy was given.  */
  unsigned int noproxy_given ;	/**< @brief Whether noproxy was given.  */
  unsigned int timeout_given ;	/**< @brief Whether timeout was given.  */
  unsigned int device_pubkey_given ;	/**< @brief Whether device-pubkey was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * The string parser (interprets the passed string as a command line)
 * @param cmdline the command line stirng
 * @param args_info the structure where option information will be stored
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_string (const char *cmdline, struct gengetopt_args_info *args_info,
  const char *prog_name);
/**
 * The string parser (version with additional parameters - deprecated)
 * @param cmdline the command line stirng
 * @param args_info the structure where option information will be stored
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_string_ext() instead
 */
int cmdline_parser_string2 (const char *cmdline, struct gengetopt_args_info *args_info,
  const char *prog_name,
  int override, int initialize, int check_required);
/**
 * The string parser (version with additional parameters)
 * @param cmdline the command line stirng
 * @param args_info the structure where option information will be stored
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_string_ext (const char *cmdline, struct gengetopt_args_info *args_info,
  const char *prog_name,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
