// Copyright © 2001-2019
// Contributors to the Freedoom project.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//   * Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//   * Neither the name of the Freedoom project nor the names of its
//     contributors may be used to endorse or promote products derived from
//     this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS
// IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// For a list of contributors to the Freedoom project, see the file
// CREDITS.

static const unsigned char pls1a0[] = {
    18,  0,   16,  0,   9,   0,   11,  0,   80,  0,   0,   0,   89,  0,   0,
    0,   103, 0,   0,   0,   118, 0,   0,   0,   135, 0,   0,   0,   155, 0,
    0,   0,   176, 0,   0,   0,   197, 0,   0,   0,   218, 0,   0,   0,   239,
    0,   0,   0,   4,   1,   0,   0,   25,  1,   0,   0,   46,  1,   0,   0,
    66,  1,   0,   0,   86,  1,   0,   0,   104, 1,   0,   0,   120, 1,   0,
    0,   136, 1,   0,   0,   6,   4,   120, 120, 120, 120, 123, 123, 255, 4,
    9,   123, 123, 123, 123, 120, 120, 123, 123, 123, 123, 123, 255, 3,   10,
    123, 123, 122, 122, 120, 115, 114, 118, 122, 122, 122, 122, 255, 2,   12,
    120, 120, 122, 122, 120, 119, 227, 112, 117, 120, 120, 122, 122, 122, 255,
    0,   15,  123, 123, 123, 120, 120, 120, 115, 114, 226, 227, 114, 114, 117,
    120, 120, 123, 123, 255, 0,   16,  123, 123, 122, 122, 117, 112, 113, 112,
    112, 226, 112, 113, 114, 113, 122, 123, 123, 123, 255, 0,   16,  123, 123,
    120, 120, 116, 112, 112, 112, 227, 227, 227, 112, 112, 112, 119, 120, 123,
    123, 255, 0,   16,  123, 123, 120, 118, 113, 112, 226, 226, 227, 226, 226,
    227, 112, 113, 115, 122, 123, 123, 255, 0,   16,  120, 120, 117, 112, 113,
    113, 225, 225, 226, 226, 226, 226, 226, 113, 117, 119, 123, 123, 255, 0,
    16,  123, 123, 114, 112, 112, 226, 225, 225, 225, 225, 226, 226, 227, 112,
    114, 117, 123, 123, 255, 0,   16,  123, 123, 120, 112, 112, 226, 225, 225,
    225, 225, 226, 226, 116, 117, 119, 120, 123, 123, 255, 0,   16,  123, 123,
    120, 112, 112, 113, 226, 226, 225, 226, 226, 226, 115, 117, 120, 122, 123,
    123, 255, 0,   15,  120, 120, 120, 120, 113, 114, 113, 227, 225, 227, 227,
    113, 114, 120, 122, 122, 122, 255, 0,   15,  120, 120, 123, 120, 113, 117,
    118, 113, 112, 226, 116, 114, 114, 120, 122, 123, 123, 255, 1,   13,  123,
    123, 123, 120, 120, 117, 117, 114, 113, 117, 120, 119, 120, 123, 123, 255,
    2,   11,  123, 123, 122, 120, 119, 120, 114, 113, 119, 122, 122, 123, 123,
    255, 2,   11,  123, 123, 123, 120, 122, 122, 119, 117, 122, 123, 123, 123,
    123, 255, 4,   6,   123, 123, 123, 123, 123, 123, 123, 123, 255,
};
static const unsigned char pls1b0[] = {
    16,  0,   16,  0,   8,   0,   11,  0,   72,  0,   0,   0,   87,  0,   0,
    0,   103, 0,   0,   0,   122, 0,   0,   0,   142, 0,   0,   0,   163, 0,
    0,   0,   184, 0,   0,   0,   205, 0,   0,   0,   226, 0,   0,   0,   247,
    0,   0,   0,   12,  1,   0,   0,   33,  1,   0,   0,   54,  1,   0,   0,
    75,  1,   0,   0,   92,  1,   0,   0,   107, 1,   0,   0,   3,   10,  120,
    120, 120, 123, 123, 123, 120, 123, 123, 123, 123, 123, 255, 2,   11,  123,
    123, 123, 120, 120, 120, 114, 117, 120, 120, 122, 123, 123, 255, 0,   14,
    123, 123, 123, 123, 120, 120, 112, 112, 112, 112, 118, 120, 122, 120, 120,
    120, 255, 0,   15,  123, 123, 122, 120, 113, 113, 112, 112, 112, 113, 113,
    116, 117, 120, 122, 123, 123, 255, 0,   16,  120, 120, 120, 120, 117, 114,
    113, 226, 226, 113, 112, 112, 112, 120, 122, 122, 123, 123, 255, 0,   16,
    122, 122, 119, 117, 118, 113, 226, 225, 225, 225, 226, 112, 113, 115, 120,
    122, 123, 123, 255, 0,   16,  122, 122, 120, 117, 113, 227, 226, 225, 225,
    225, 226, 112, 112, 114, 119, 120, 123, 123, 255, 0,   16,  119, 119, 114,
    114, 112, 225, 225, 225, 225, 226, 227, 227, 112, 226, 227, 115, 120, 120,
    255, 0,   16,  117, 117, 113, 113, 226, 227, 226, 225, 225, 226, 226, 227,
    226, 227, 112, 114, 120, 120, 255, 0,   16,  122, 122, 119, 117, 116, 227,
    226, 226, 226, 226, 226, 227, 112, 114, 117, 118, 123, 123, 255, 0,   16,
    123, 123, 122, 120, 114, 113, 226, 226, 226, 226, 227, 112, 113, 114, 120,
    122, 123, 123, 255, 0,   16,  123, 123, 122, 119, 114, 114, 115, 116, 227,
    226, 112, 112, 114, 117, 120, 122, 123, 123, 255, 0,   16,  123, 123, 123,
    120, 120, 120, 117, 117, 112, 113, 113, 112, 113, 120, 122, 122, 123, 123,
    255, 2,   12,  123, 123, 122, 122, 120, 119, 114, 117, 115, 119, 122, 120,
    122, 122, 255, 3,   10,  123, 123, 122, 122, 120, 117, 119, 122, 120, 123,
    123, 123, 255, 5,   7,   123, 123, 123, 123, 123, 123, 123, 123, 123, 255,
};
static const unsigned char pls1e0[] = {
    32,  0,   32,  0,   16,  0,   27,  0,   136, 0,   0,   0,   147, 0,   0,
    0,   164, 0,   0,   0,   183, 0,   0,   0,   206, 0,   0,   0,   231, 0,
    0,   0,   1,   1,   0,   0,   27,  1,   0,   0,   56,  1,   0,   0,   85,
    1,   0,   0,   114, 1,   0,   0,   144, 1,   0,   0,   176, 1,   0,   0,
    210, 1,   0,   0,   248, 1,   0,   0,   31,  2,   0,   0,   68,  2,   0,
    0,   107, 2,   0,   0,   149, 2,   0,   0,   187, 2,   0,   0,   227, 2,
    0,   0,   8,   3,   0,   0,   44,  3,   0,   0,   79,  3,   0,   0,   114,
    3,   0,   0,   148, 3,   0,   0,   181, 3,   0,   0,   212, 3,   0,   0,
    236, 3,   0,   0,   2,   4,   0,   0,   22,  4,   0,   0,   39,  4,   0,
    0,   12,  6,   123, 123, 123, 123, 121, 121, 121, 121, 255, 9,   12,  123,
    123, 123, 123, 122, 122, 121, 119, 119, 119, 119, 121, 123, 123, 255, 8,
    14,  123, 123, 123, 122, 122, 120, 115, 114, 116, 116, 119, 119, 119, 119,
    123, 123, 255, 7,   18,  123, 123, 123, 122, 122, 122, 120, 117, 116, 117,
    114, 117, 119, 117, 117, 119, 121, 123, 123, 123, 255, 6,   20,  123, 123,
    123, 122, 121, 121, 120, 115, 114, 113, 114, 113, 112, 114, 117, 117, 119,
    121, 121, 123, 123, 123, 255, 6,   21,  123, 123, 122, 121, 121, 121, 119,
    112, 113, 113, 113, 114, 112, 112, 112, 113, 113, 119, 119, 123, 123, 123,
    123, 255, 6,   21,  122, 122, 121, 121, 116, 120, 114, 113, 117, 117, 114,
    114, 114, 112, 112, 226, 112, 113, 119, 121, 123, 123, 123, 255, 4,   24,
    123, 123, 123, 121, 120, 117, 117, 117, 119, 119, 119, 117, 114, 114, 227,
    112, 113, 113, 226, 227, 112, 116, 121, 123, 123, 123, 255, 4,   24,  123,
    123, 123, 120, 117, 116, 117, 119, 120, 121, 121, 121, 117, 117, 113, 227,
    112, 112, 227, 226, 227, 116, 119, 123, 123, 123, 255, 4,   24,  123, 123,
    123, 117, 113, 116, 116, 119, 121, 121, 121, 121, 120, 119, 117, 112, 112,
    112, 112, 227, 226, 116, 119, 120, 123, 123, 255, 3,   25,  123, 123, 122,
    122, 113, 112, 113, 114, 120, 121, 121, 121, 121, 122, 121, 121, 116, 115,
    114, 112, 112, 227, 115, 119, 120, 122, 122, 255, 2,   27,  123, 123, 122,
    122, 121, 112, 112, 117, 120, 121, 122, 123, 122, 122, 122, 122, 121, 121,
    120, 119, 113, 112, 227, 115, 116, 120, 122, 122, 122, 255, 1,   29,  123,
    123, 122, 122, 120, 117, 113, 116, 117, 120, 121, 123, 123, 123, 123, 122,
    122, 122, 121, 120, 120, 115, 113, 112, 112, 116, 119, 122, 122, 123, 123,
    255, 1,   13,  122, 122, 122, 121, 117, 117, 116, 114, 119, 121, 122, 123,
    123, 123, 123, 15,  16,  122, 122, 122, 122, 122, 120, 120, 119, 115, 112,
    112, 113, 117, 121, 122, 122, 123, 123, 255, 0,   14,  123, 123, 122, 121,
    119, 117, 116, 117, 117, 121, 122, 122, 123, 123, 123, 123, 15,  16,  122,
    122, 122, 122, 122, 122, 120, 117, 117, 114, 112, 113, 117, 121, 121, 122,
    123, 123, 255, 0,   13,  123, 123, 122, 120, 120, 117, 116, 117, 119, 121,
    122, 122, 123, 123, 123, 16,  15,  122, 122, 122, 122, 122, 121, 119, 119,
    116, 113, 114, 119, 121, 121, 122, 123, 123, 255, 0,   13,  123, 123, 122,
    120, 120, 116, 116, 119, 121, 120, 121, 121, 122, 122, 122, 15,  17,  122,
    122, 122, 122, 122, 122, 122, 119, 117, 117, 113, 113, 119, 121, 121, 122,
    123, 123, 123, 255, 0,   13,  123, 123, 122, 120, 119, 116, 113, 117, 117,
    119, 120, 121, 121, 121, 121, 15,  3,   122, 122, 122, 122, 122, 19,  13,
    123, 123, 123, 117, 116, 117, 119, 119, 120, 120, 120, 122, 123, 123, 123,
    255, 0,   17,  123, 123, 121, 117, 117, 114, 113, 117, 117, 117, 117, 119,
    120, 121, 121, 122, 122, 122, 122, 20,  12,  123, 123, 117, 117, 117, 120,
    120, 120, 120, 120, 122, 123, 123, 123, 255, 0,   17,  123, 123, 122, 121,
    121, 116, 227, 114, 114, 116, 116, 119, 120, 121, 121, 122, 122, 122, 122,
    18,  14,  123, 123, 123, 123, 117, 117, 119, 119, 120, 120, 119, 120, 122,
    122, 123, 123, 255, 0,   32,  123, 123, 123, 121, 121, 119, 112, 113, 116,
    116, 117, 119, 120, 121, 121, 121, 122, 122, 122, 122, 123, 121, 117, 116,
    119, 119, 120, 120, 120, 122, 122, 122, 123, 123, 255, 0,   31,  123, 123,
    123, 123, 121, 121, 119, 112, 117, 117, 117, 117, 117, 119, 121, 121, 122,
    122, 122, 122, 123, 121, 117, 116, 117, 116, 119, 120, 120, 121, 122, 122,
    122, 255, 1,   30,  123, 123, 123, 121, 121, 116, 113, 113, 117, 116, 117,
    119, 119, 119, 119, 121, 121, 122, 122, 122, 122, 120, 119, 113, 113, 114,
    119, 121, 121, 122, 123, 123, 255, 1,   30,  123, 123, 123, 122, 116, 116,
    120, 115, 115, 119, 119, 114, 116, 116, 117, 121, 120, 120, 120, 120, 121,
    121, 116, 113, 112, 113, 117, 121, 123, 123, 123, 123, 255, 1,   29,  123,
    123, 123, 123, 117, 120, 120, 120, 115, 115, 115, 114, 115, 115, 115, 117,
    117, 117, 120, 117, 117, 117, 114, 112, 113, 117, 119, 122, 122, 123, 123,
    255, 2,   28,  123, 123, 123, 121, 122, 121, 120, 120, 120, 119, 119, 113,
    113, 113, 117, 116, 116, 117, 114, 114, 114, 112, 112, 114, 115, 120, 122,
    122, 123, 123, 255, 3,   26,  123, 123, 122, 123, 122, 121, 121, 120, 117,
    116, 119, 113, 115, 115, 115, 114, 117, 116, 112, 113, 114, 113, 115, 120,
    121, 122, 123, 123, 255, 8,   19,  123, 123, 123, 122, 119, 120, 120, 120,
    115, 113, 113, 114, 114, 115, 112, 115, 117, 120, 122, 122, 122, 255, 9,
    17,  123, 123, 123, 122, 121, 121, 121, 119, 117, 113, 114, 113, 113, 113,
    116, 119, 121, 122, 122, 255, 10,  15,  123, 123, 123, 123, 122, 121, 121,
    119, 114, 114, 114, 117, 117, 119, 120, 122, 122, 255, 12,  12,  123, 123,
    123, 123, 121, 121, 121, 121, 121, 120, 120, 120, 122, 122, 255, 14,  9,
    123, 123, 123, 123, 122, 122, 122, 122, 122, 122, 122, 255,
};
static const unsigned char pls1g0[] = {
    36,  0,   32,  0,   18,  0,   27,  0,   152, 0,   0,   0,   161, 0,   0,
    0,   177, 0,   0,   0,   195, 0,   0,   0,   220, 0,   0,   0,   250, 0,
    0,   0,   24,  1,   0,   0,   56,  1,   0,   0,   87,  1,   0,   0,   122,
    1,   0,   0,   154, 1,   0,   0,   187, 1,   0,   0,   216, 1,   0,   0,
    244, 1,   0,   0,   16,  2,   0,   0,   40,  2,   0,   0,   62,  2,   0,
    0,   83,  2,   0,   0,   110, 2,   0,   0,   136, 2,   0,   0,   160, 2,
    0,   0,   183, 2,   0,   0,   210, 2,   0,   0,   236, 2,   0,   0,   6,
    3,   0,   0,   35,  3,   0,   0,   66,  3,   0,   0,   101, 3,   0,   0,
    134, 3,   0,   0,   166, 3,   0,   0,   195, 3,   0,   0,   226, 3,   0,
    0,   247, 3,   0,   0,   6,   4,   0,   0,   23,  4,   0,   0,   41,  4,
    0,   0,   15,  4,   123, 123, 123, 123, 123, 123, 255, 13,  11,  123, 123,
    123, 123, 122, 122, 122, 123, 123, 123, 123, 123, 123, 255, 12,  13,  123,
    123, 123, 123, 122, 122, 122, 122, 122, 122, 122, 123, 123, 123, 123, 255,
    8,   1,   123, 123, 123, 12,  15,  123, 123, 123, 123, 121, 121, 121, 122,
    121, 120, 121, 121, 122, 123, 123, 123, 123, 255, 6,   5,   122, 122, 122,
    122, 123, 123, 123, 12,  16,  123, 123, 123, 121, 121, 121, 121, 121, 120,
    119, 119, 120, 120, 122, 123, 123, 123, 123, 255, 6,   4,   121, 121, 121,
    122, 122, 122, 11,  17,  123, 123, 123, 121, 121, 120, 119, 119, 119, 119,
    120, 120, 119, 120, 120, 121, 123, 123, 123, 255, 4,   5,   122, 122, 122,
    122, 122, 122, 122, 11,  18,  123, 123, 123, 121, 121, 120, 120, 117, 117,
    117, 119, 120, 120, 117, 119, 120, 121, 123, 123, 123, 255, 4,   4,   122,
    122, 122, 122, 121, 121, 11,  18,  123, 123, 123, 122, 122, 122, 122, 121,
    121, 117, 117, 117, 119, 120, 119, 120, 121, 121, 123, 123, 255, 3,   5,
    122, 122, 121, 122, 121, 121, 121, 9,   21,  121, 121, 120, 120, 121, 122,
    122, 121, 121, 120, 121, 121, 121, 117, 117, 119, 119, 119, 121, 121, 122,
    123, 123, 255, 3,   27,  121, 121, 122, 122, 121, 120, 121, 120, 119, 121,
    121, 120, 122, 122, 123, 123, 122, 121, 120, 120, 117, 117, 117, 119, 120,
    121, 121, 123, 123, 255, 3,   10,  121, 121, 122, 121, 120, 120, 119, 117,
    121, 121, 119, 119, 16,  14,  123, 123, 123, 123, 123, 122, 120, 119, 119,
    119, 119, 120, 119, 120, 122, 122, 255, 3,   10,  122, 122, 122, 121, 119,
    119, 119, 120, 121, 121, 120, 120, 21,  10,  122, 122, 122, 121, 120, 119,
    119, 117, 120, 121, 122, 122, 255, 3,   9,   121, 121, 121, 120, 119, 119,
    120, 120, 122, 122, 122, 22,  10,  122, 122, 122, 121, 120, 116, 117, 117,
    120, 122, 123, 123, 255, 3,   9,   122, 122, 121, 119, 117, 119, 121, 121,
    121, 122, 122, 22,  10,  122, 122, 122, 122, 121, 117, 116, 116, 119, 121,
    123, 123, 255, 3,   8,   122, 122, 120, 119, 117, 120, 120, 121, 121, 121,
    25,  7,   122, 122, 121, 120, 116, 119, 121, 122, 122, 255, 4,   6,   122,
    122, 120, 119, 120, 121, 121, 121, 25,  7,   122, 122, 121, 120, 116, 119,
    120, 122, 122, 255, 4,   6,   121, 121, 121, 119, 119, 120, 121, 121, 26,
    6,   121, 121, 120, 119, 117, 120, 123, 123, 255, 1,   2,   123, 123, 123,
    123, 4,   6,   121, 121, 121, 120, 121, 122, 122, 122, 26,  6,   122, 122,
    120, 120, 117, 121, 123, 123, 255, 1,   2,   122, 122, 122, 122, 4,   7,
    122, 122, 121, 120, 122, 123, 123, 123, 123, 27,  4,   121, 121, 121, 120,
    121, 121, 255, 1,   11,  121, 121, 121, 121, 121, 122, 121, 122, 123, 123,
    123, 123, 123, 27,  4,   122, 122, 122, 121, 122, 122, 255, 0,   10,  121,
    121, 121, 120, 120, 121, 121, 121, 122, 122, 123, 123, 27,  4,   123, 123,
    122, 122, 123, 123, 255, 0,   9,   121, 121, 121, 119, 120, 121, 120, 120,
    122, 122, 122, 20,  2,   123, 123, 123, 123, 27,  3,   123, 123, 123, 123,
    123, 255, 0,   9,   122, 122, 121, 119, 117, 119, 120, 119, 121, 122, 122,
    19,  3,   122, 122, 123, 123, 123, 27,  1,   123, 123, 123, 255, 0,   9,
    122, 122, 122, 119, 117, 117, 119, 119, 120, 122, 122, 19,  3,   121, 121,
    123, 123, 123, 25,  1,   123, 123, 123, 255, 0,   10,  123, 123, 122, 120,
    116, 116, 119, 120, 120, 119, 123, 123, 17,  3,   120, 120, 120, 121, 121,
    25,  3,   123, 123, 123, 123, 123, 255, 0,   11,  123, 123, 123, 121, 117,
    116, 117, 119, 120, 119, 117, 120, 120, 16,  4,   120, 120, 120, 120, 122,
    122, 25,  3,   122, 122, 123, 123, 123, 255, 1,   11,  123, 123, 123, 122,
    116, 116, 117, 119, 120, 119, 119, 120, 120, 14,  6,   121, 121, 119, 119,
    120, 121, 123, 123, 24,  5,   120, 120, 122, 122, 123, 123, 123, 255, 1,
    18,  123, 123, 123, 123, 119, 117, 116, 117, 119, 120, 120, 120, 120, 119,
    117, 117, 121, 122, 121, 121, 23,  6,   120, 120, 119, 119, 121, 123, 123,
    123, 255, 2,   17,  123, 123, 123, 122, 119, 117, 117, 117, 120, 121, 121,
    120, 119, 119, 122, 122, 121, 121, 121, 23,  6,   121, 121, 117, 117, 120,
    121, 123, 123, 255, 4,   14,  123, 123, 123, 121, 120, 121, 121, 122, 123,
    123, 121, 122, 122, 120, 121, 121, 23,  6,   119, 119, 117, 117, 120, 121,
    123, 123, 255, 5,   5,   123, 123, 123, 122, 122, 122, 122, 12,  5,   123,
    123, 123, 122, 120, 120, 120, 21,  8,   121, 121, 119, 119, 120, 119, 121,
    121, 123, 123, 255, 13,  3,   123, 123, 123, 121, 121, 20,  9,   119, 119,
    119, 119, 120, 120, 120, 121, 123, 123, 123, 255, 18,  10,  121, 121, 119,
    119, 119, 121, 121, 119, 119, 122, 123, 123, 255, 16,  12,  123, 123, 123,
    121, 119, 121, 122, 119, 120, 122, 122, 123, 123, 123, 255, 14,  13,  123,
    123, 123, 123, 122, 122, 122, 122, 121, 121, 122, 121, 123, 123, 123, 255,
    16,  9,   123, 123, 122, 122, 122, 121, 120, 120, 122, 123, 123, 255,
};
static const unsigned char pls2a0[] = {
    18,  0,   16,  0,   9,   0,   11,  0,   80,  0,   0,   0,   89,  0,   0,
    0,   103, 0,   0,   0,   118, 0,   0,   0,   135, 0,   0,   0,   155, 0,
    0,   0,   176, 0,   0,   0,   197, 0,   0,   0,   218, 0,   0,   0,   239,
    0,   0,   0,   4,   1,   0,   0,   25,  1,   0,   0,   46,  1,   0,   0,
    66,  1,   0,   0,   86,  1,   0,   0,   104, 1,   0,   0,   120, 1,   0,
    0,   136, 1,   0,   0,   6,   4,   205, 205, 204, 205, 207, 207, 255, 4,
    9,   207, 207, 207, 207, 204, 204, 207, 207, 207, 207, 207, 255, 3,   10,
    207, 207, 206, 206, 205, 198, 198, 205, 206, 206, 206, 206, 255, 2,   12,
    205, 205, 206, 206, 204, 203, 194, 196, 202, 204, 204, 206, 206, 206, 255,
    0,   15,  207, 207, 207, 204, 204, 204, 197, 198, 194, 194, 196, 197, 202,
    204, 204, 207, 207, 255, 0,   16,  207, 207, 206, 206, 202, 197, 196, 194,
    194, 193, 198, 198, 199, 198, 206, 207, 207, 207, 255, 0,   16,  207, 207,
    205, 204, 202, 197, 198, 193, 194, 194, 193, 194, 198, 197, 203, 205, 207,
    207, 255, 0,   16,  207, 207, 205, 203, 198, 193, 194, 192, 192, 193, 192,
    194, 194, 198, 198, 206, 207, 207, 255, 0,   16,  205, 205, 202, 197, 198,
    198, 192, 192, 192, 192, 193, 192, 192, 198, 202, 203, 207, 207, 255, 0,
    16,  207, 207, 199, 196, 196, 194, 192, 4,   4,   192, 192, 193, 194, 197,
    199, 202, 207, 207, 255, 0,   16,  207, 207, 204, 197, 196, 194, 193, 192,
    193, 192, 192, 193, 202, 202, 203, 204, 207, 207, 255, 0,   16,  207, 207,
    205, 197, 196, 196, 193, 194, 4,   192, 193, 193, 199, 202, 205, 206, 207,
    207, 255, 0,   15,  205, 205, 205, 204, 198, 196, 196, 194, 193, 193, 194,
    197, 199, 204, 206, 206, 206, 255, 0,   15,  205, 205, 207, 204, 198, 202,
    203, 198, 196, 194, 202, 199, 199, 205, 206, 207, 207, 255, 1,   13,  207,
    207, 207, 204, 204, 202, 202, 199, 198, 202, 204, 203, 204, 207, 207, 255,
    2,   11,  207, 207, 206, 204, 203, 205, 199, 198, 203, 206, 206, 207, 207,
    255, 2,   11,  207, 207, 207, 204, 206, 206, 203, 202, 206, 207, 207, 207,
    207, 255, 4,   6,   207, 207, 207, 207, 207, 207, 207, 207, 255,
};
static const unsigned char pls2b0[] = {
    16,  0,   18,  0,   8,   0,   13,  0,   72,  0,   0,   0,   87,  0,   0,
    0,   103, 0,   0,   0,   122, 0,   0,   0,   142, 0,   0,   0,   164, 0,
    0,   0,   186, 0,   0,   0,   209, 0,   0,   0,   232, 0,   0,   0,   255,
    0,   0,   0,   22,  1,   0,   0,   43,  1,   0,   0,   64,  1,   0,   0,
    85,  1,   0,   0,   102, 1,   0,   0,   117, 1,   0,   0,   4,   10,  205,
    205, 205, 207, 207, 207, 205, 207, 207, 207, 207, 207, 255, 3,   11,  207,
    207, 207, 205, 205, 204, 199, 202, 205, 205, 206, 207, 207, 255, 1,   14,
    207, 207, 207, 207, 204, 204, 197, 197, 196, 197, 203, 204, 206, 204, 205,
    205, 255, 1,   15,  207, 207, 206, 204, 198, 198, 196, 196, 196, 198, 198,
    202, 202, 204, 206, 207, 207, 255, 0,   17,  207, 207, 204, 204, 204, 202,
    196, 196, 194, 194, 198, 193, 197, 197, 204, 206, 206, 207, 207, 255, 0,
    17,  207, 207, 206, 203, 202, 203, 196, 193, 193, 192, 192, 194, 198, 196,
    197, 204, 206, 207, 207, 255, 0,   18,  207, 207, 206, 205, 202, 198, 194,
    194, 192, 4,   192, 192, 193, 194, 198, 203, 205, 207, 205, 205, 255, 0,
    18,  207, 207, 203, 199, 199, 196, 193, 4,   193, 4,   192, 192, 194, 194,
    194, 194, 198, 204, 204, 204, 255, 0,   18,  207, 207, 202, 198, 198, 194,
    193, 192, 192, 192, 192, 193, 194, 193, 194, 196, 198, 204, 205, 205, 255,
    0,   18,  207, 207, 206, 203, 202, 202, 194, 193, 192, 192, 193, 192, 193,
    198, 196, 202, 205, 207, 207, 207, 255, 1,   16,  207, 207, 206, 204, 199,
    197, 193, 193, 193, 192, 194, 194, 198, 197, 204, 206, 207, 207, 255, 1,
    16,  207, 207, 206, 203, 199, 199, 199, 202, 194, 192, 194, 198, 199, 202,
    204, 206, 207, 207, 255, 1,   16,  207, 207, 207, 204, 205, 204, 202, 202,
    197, 198, 198, 197, 198, 204, 206, 206, 207, 207, 255, 3,   12,  207, 207,
    206, 206, 205, 203, 199, 202, 198, 203, 206, 204, 206, 206, 255, 4,   10,
    207, 207, 206, 206, 204, 202, 203, 206, 205, 207, 207, 207, 255, 6,   7,
    207, 207, 207, 207, 207, 207, 207, 207, 207, 255,
};
static const unsigned char pls2c0[] = {
    23,  0,   23,  0,   11,  0,   18,  0,   100, 0,   0,   0,   118, 0,   0,
    0,   137, 0,   0,   0,   158, 0,   0,   0,   181, 0,   0,   0,   204, 0,
    0,   0,   228, 0,   0,   0,   254, 0,   0,   0,   24,  1,   0,   0,   51,
    1,   0,   0,   79,  1,   0,   0,   107, 1,   0,   0,   135, 1,   0,   0,
    162, 1,   0,   0,   189, 1,   0,   0,   216, 1,   0,   0,   242, 1,   0,
    0,   11,  2,   0,   0,   35,  2,   0,   0,   58,  2,   0,   0,   80,  2,
    0,   0,   100, 2,   0,   0,   115, 2,   0,   0,   5,   3,   207, 207, 207,
    207, 207, 11,  6,   207, 207, 207, 207, 207, 207, 207, 207, 255, 4,   14,
    207, 207, 205, 205, 205, 207, 207, 207, 205, 205, 205, 205, 205, 205, 207,
    207, 255, 3,   16,  207, 207, 205, 204, 203, 203, 203, 198, 197, 198, 197,
    196, 196, 198, 204, 205, 207, 207, 255, 2,   18,  207, 207, 205, 204, 197,
    196, 197, 196, 196, 195, 194, 195, 194, 195, 194, 196, 204, 205, 207, 207,
    255, 2,   18,  207, 207, 203, 202, 197, 192, 194, 195, 195, 193, 194, 193,
    194, 195, 195, 194, 203, 205, 207, 207, 255, 1,   19,  207, 207, 203, 202,
    196, 192, 192, 193, 195, 194, 193, 194, 193, 194, 195, 195, 194, 195, 202,
    207, 207, 255, 0,   21,  207, 207, 207, 203, 197, 193, 192, 196, 196, 194,
    194, 193, 193, 193, 193, 194, 195, 196, 194, 197, 206, 207, 207, 255, 0,
    21,  207, 207, 205, 202, 195, 193, 193, 195, 196, 194, 193, 193, 193, 192,
    192, 193, 194, 195, 195, 196, 197, 207, 207, 255, 0,   22,  207, 207, 204,
    202, 194, 194, 193, 196, 195, 194, 193, 193, 193, 192, 192, 192, 193, 195,
    196, 197, 197, 205, 207, 207, 255, 0,   23,  207, 207, 204, 202, 197, 193,
    196, 196, 195, 193, 193, 192, 192, 192, 192, 192, 193, 194, 196, 197, 197,
    198, 207, 207, 207, 255, 0,   23,  207, 207, 205, 202, 196, 194, 197, 195,
    193, 192, 192, 192, 192, 192, 192, 192, 192, 194, 195, 196, 198, 203, 206,
    207, 207, 255, 0,   23,  207, 207, 207, 203, 197, 196, 196, 197, 193, 193,
    192, 192, 192, 192, 192, 192, 193, 194, 195, 196, 202, 204, 204, 207, 207,
    255, 1,   22,  207, 207, 204, 202, 196, 196, 197, 195, 193, 192, 192, 192,
    192, 192, 192, 193, 194, 194, 195, 195, 203, 204, 207, 207, 255, 1,   22,
    207, 207, 207, 204, 196, 195, 196, 195, 194, 193, 193, 192, 192, 192, 193,
    193, 194, 194, 196, 193, 198, 204, 207, 207, 255, 1,   22,  207, 207, 207,
    204, 203, 194, 194, 196, 196, 194, 194, 193, 193, 193, 193, 193, 194, 195,
    195, 195, 198, 205, 207, 207, 255, 2,   21,  207, 207, 204, 203, 194, 193,
    195, 196, 195, 195, 195, 194, 194, 194, 194, 194, 195, 195, 196, 203, 205,
    207, 207, 255, 3,   20,  206, 206, 204, 198, 194, 194, 196, 196, 196, 196,
    195, 194, 194, 195, 195, 195, 195, 195, 198, 203, 207, 207, 255, 3,   19,
    207, 207, 205, 203, 203, 196, 195, 195, 197, 196, 198, 196, 196, 196, 196,
    197, 199, 196, 198, 203, 203, 255, 4,   18,  205, 205, 204, 203, 202, 197,
    196, 196, 195, 196, 196, 196, 197, 196, 203, 198, 204, 203, 204, 204, 255,
    4,   17,  207, 207, 205, 205, 204, 197, 197, 195, 196, 198, 194, 194, 194,
    196, 196, 197, 205, 205, 205, 255, 5,   15,  207, 207, 205, 205, 205, 204,
    204, 204, 203, 203, 204, 204, 204, 205, 205, 207, 207, 255, 8,   10,  207,
    207, 205, 204, 204, 204, 204, 204, 205, 207, 207, 207, 255, 11,  4,   207,
    207, 207, 207, 207, 207, 255,
};
static const unsigned char pls2d0[] = {
    32,  0,   32,  0,   16,  0,   27,  0,   136, 0,   0,   0,   147, 0,   0,
    0,   164, 0,   0,   0,   183, 0,   0,   0,   206, 0,   0,   0,   231, 0,
    0,   0,   1,   1,   0,   0,   27,  1,   0,   0,   56,  1,   0,   0,   85,
    1,   0,   0,   114, 1,   0,   0,   144, 1,   0,   0,   176, 1,   0,   0,
    210, 1,   0,   0,   248, 1,   0,   0,   31,  2,   0,   0,   68,  2,   0,
    0,   107, 2,   0,   0,   149, 2,   0,   0,   187, 2,   0,   0,   227, 2,
    0,   0,   8,   3,   0,   0,   44,  3,   0,   0,   79,  3,   0,   0,   114,
    3,   0,   0,   148, 3,   0,   0,   181, 3,   0,   0,   212, 3,   0,   0,
    236, 3,   0,   0,   2,   4,   0,   0,   22,  4,   0,   0,   39,  4,   0,
    0,   12,  6,   207, 207, 207, 207, 205, 205, 205, 205, 255, 9,   12,  207,
    207, 207, 207, 206, 206, 205, 203, 203, 203, 203, 205, 207, 207, 255, 8,
    14,  207, 207, 207, 206, 206, 204, 200, 199, 201, 201, 203, 203, 203, 203,
    207, 207, 255, 7,   18,  207, 207, 207, 206, 206, 206, 204, 202, 201, 202,
    199, 202, 203, 202, 202, 203, 205, 207, 207, 207, 255, 6,   20,  207, 207,
    207, 206, 205, 205, 204, 200, 199, 198, 199, 198, 197, 199, 202, 202, 203,
    205, 205, 207, 207, 207, 255, 6,   21,  207, 207, 206, 205, 205, 205, 203,
    196, 198, 198, 198, 199, 197, 196, 197, 198, 198, 203, 203, 207, 207, 207,
    207, 255, 6,   21,  206, 206, 205, 205, 201, 204, 199, 198, 202, 202, 199,
    199, 199, 197, 196, 194, 196, 198, 203, 205, 207, 207, 207, 255, 4,   24,
    207, 207, 207, 205, 204, 202, 202, 202, 203, 203, 203, 202, 199, 199, 195,
    196, 198, 198, 194, 195, 196, 201, 205, 207, 207, 207, 255, 4,   24,  207,
    207, 207, 204, 202, 201, 202, 203, 204, 205, 205, 205, 202, 202, 198, 195,
    196, 197, 195, 194, 195, 201, 203, 207, 207, 207, 255, 4,   24,  207, 207,
    207, 202, 198, 201, 201, 203, 205, 205, 205, 205, 204, 203, 202, 197, 196,
    197, 196, 195, 194, 201, 203, 204, 207, 207, 255, 3,   25,  207, 207, 206,
    206, 198, 196, 198, 199, 204, 205, 205, 205, 205, 206, 205, 205, 201, 200,
    199, 196, 197, 195, 200, 203, 204, 206, 206, 255, 2,   27,  207, 207, 206,
    206, 205, 197, 197, 202, 204, 205, 206, 207, 206, 206, 206, 206, 205, 205,
    204, 203, 198, 197, 195, 200, 201, 204, 206, 206, 206, 255, 1,   29,  207,
    207, 206, 206, 204, 202, 198, 201, 202, 204, 205, 207, 207, 207, 207, 206,
    206, 206, 205, 204, 204, 200, 198, 196, 197, 201, 203, 206, 206, 207, 207,
    255, 1,   13,  206, 206, 206, 205, 202, 202, 201, 199, 203, 205, 206, 207,
    207, 207, 207, 15,  16,  206, 206, 206, 206, 206, 204, 204, 203, 200, 197,
    197, 198, 202, 205, 206, 206, 207, 207, 255, 0,   14,  207, 207, 206, 205,
    203, 202, 201, 202, 202, 205, 206, 206, 207, 207, 207, 207, 15,  16,  206,
    206, 206, 206, 206, 206, 204, 202, 202, 199, 197, 198, 202, 205, 205, 206,
    207, 207, 255, 0,   13,  207, 207, 206, 204, 204, 202, 201, 202, 203, 205,
    206, 206, 207, 207, 207, 16,  15,  206, 206, 206, 206, 206, 205, 203, 203,
    201, 198, 199, 203, 205, 205, 206, 207, 207, 255, 0,   13,  207, 207, 206,
    204, 204, 201, 201, 203, 205, 204, 205, 205, 206, 206, 206, 15,  17,  206,
    206, 206, 206, 206, 206, 206, 203, 202, 202, 198, 198, 203, 205, 205, 206,
    207, 207, 207, 255, 0,   13,  207, 207, 206, 204, 203, 201, 198, 202, 202,
    203, 204, 205, 205, 205, 205, 15,  3,   206, 206, 206, 206, 206, 19,  13,
    207, 207, 207, 202, 201, 202, 203, 203, 204, 204, 204, 206, 207, 207, 207,
    255, 0,   17,  207, 207, 205, 202, 202, 199, 198, 202, 202, 202, 202, 203,
    204, 205, 205, 206, 206, 206, 206, 20,  12,  207, 207, 202, 202, 202, 204,
    204, 204, 204, 204, 206, 207, 207, 207, 255, 0,   17,  207, 207, 206, 205,
    205, 201, 195, 199, 199, 201, 201, 203, 204, 205, 205, 206, 206, 206, 206,
    18,  14,  207, 207, 207, 207, 202, 202, 203, 203, 204, 204, 203, 204, 206,
    206, 207, 207, 255, 0,   32,  207, 207, 207, 205, 205, 203, 197, 198, 201,
    201, 202, 203, 204, 205, 205, 205, 206, 206, 206, 206, 207, 205, 202, 201,
    203, 203, 204, 204, 204, 206, 206, 206, 207, 207, 255, 0,   31,  207, 207,
    207, 207, 205, 205, 203, 197, 202, 202, 202, 202, 202, 203, 205, 205, 206,
    206, 206, 206, 207, 205, 202, 201, 202, 201, 203, 204, 204, 205, 206, 206,
    206, 255, 1,   30,  207, 207, 207, 205, 205, 201, 198, 198, 202, 201, 202,
    203, 203, 203, 203, 205, 205, 206, 206, 206, 206, 204, 203, 198, 198, 199,
    203, 205, 205, 206, 207, 207, 255, 1,   30,  207, 207, 207, 206, 201, 201,
    204, 200, 200, 203, 203, 199, 201, 201, 202, 205, 204, 204, 204, 204, 205,
    205, 201, 198, 197, 198, 202, 205, 207, 207, 207, 207, 255, 1,   29,  207,
    207, 207, 207, 202, 204, 204, 204, 200, 200, 200, 199, 200, 200, 200, 202,
    202, 202, 204, 202, 202, 202, 199, 197, 198, 202, 203, 206, 206, 207, 207,
    255, 2,   28,  207, 207, 207, 205, 206, 205, 204, 204, 204, 203, 203, 198,
    198, 198, 202, 201, 201, 202, 199, 199, 199, 197, 196, 199, 200, 204, 206,
    206, 207, 207, 255, 3,   26,  207, 207, 206, 207, 206, 205, 205, 204, 202,
    201, 203, 198, 200, 200, 200, 199, 202, 201, 197, 198, 199, 198, 200, 204,
    205, 206, 207, 207, 255, 8,   19,  207, 207, 207, 206, 203, 204, 204, 204,
    200, 198, 198, 199, 199, 200, 197, 200, 202, 204, 206, 206, 206, 255, 9,
    17,  207, 207, 207, 206, 205, 205, 205, 203, 202, 198, 199, 198, 198, 198,
    201, 203, 205, 206, 206, 255, 10,  15,  207, 207, 207, 207, 206, 205, 205,
    203, 199, 199, 199, 202, 202, 203, 204, 206, 206, 255, 12,  12,  207, 207,
    207, 207, 205, 205, 205, 205, 205, 204, 204, 204, 206, 206, 255, 14,  9,
    207, 207, 207, 207, 206, 206, 206, 206, 206, 206, 206, 255,
};
static const unsigned char pls2e0[] = {
    36,  0,   32,  0,   18,  0,   27,  0,   152, 0,   0,   0,   161, 0,   0,
    0,   177, 0,   0,   0,   195, 0,   0,   0,   220, 0,   0,   0,   250, 0,
    0,   0,   24,  1,   0,   0,   56,  1,   0,   0,   87,  1,   0,   0,   122,
    1,   0,   0,   154, 1,   0,   0,   187, 1,   0,   0,   216, 1,   0,   0,
    244, 1,   0,   0,   16,  2,   0,   0,   40,  2,   0,   0,   62,  2,   0,
    0,   83,  2,   0,   0,   110, 2,   0,   0,   136, 2,   0,   0,   160, 2,
    0,   0,   183, 2,   0,   0,   210, 2,   0,   0,   236, 2,   0,   0,   6,
    3,   0,   0,   35,  3,   0,   0,   66,  3,   0,   0,   101, 3,   0,   0,
    134, 3,   0,   0,   166, 3,   0,   0,   195, 3,   0,   0,   226, 3,   0,
    0,   247, 3,   0,   0,   6,   4,   0,   0,   23,  4,   0,   0,   41,  4,
    0,   0,   15,  4,   207, 207, 207, 207, 207, 207, 255, 13,  11,  207, 207,
    207, 207, 206, 206, 206, 207, 207, 207, 207, 207, 207, 255, 12,  13,  207,
    207, 207, 207, 206, 206, 206, 206, 206, 206, 206, 207, 207, 207, 207, 255,
    8,   1,   207, 207, 207, 12,  15,  207, 207, 207, 207, 205, 205, 205, 206,
    205, 204, 205, 205, 206, 207, 207, 207, 207, 255, 6,   5,   206, 206, 206,
    206, 207, 207, 207, 12,  16,  207, 207, 207, 205, 205, 205, 205, 205, 204,
    203, 203, 204, 204, 206, 207, 207, 207, 207, 255, 6,   4,   205, 205, 205,
    206, 206, 206, 11,  17,  207, 207, 207, 205, 205, 204, 203, 203, 203, 203,
    204, 204, 203, 204, 204, 205, 207, 207, 207, 255, 4,   5,   206, 206, 206,
    206, 206, 206, 206, 11,  18,  207, 207, 207, 205, 205, 204, 204, 202, 202,
    202, 203, 204, 204, 202, 203, 204, 205, 207, 207, 207, 255, 4,   4,   206,
    206, 206, 206, 205, 205, 11,  18,  207, 207, 207, 206, 206, 206, 206, 205,
    205, 202, 202, 202, 203, 204, 203, 204, 205, 205, 207, 207, 255, 3,   5,
    206, 206, 205, 206, 205, 205, 205, 9,   21,  205, 205, 204, 204, 205, 206,
    206, 205, 205, 204, 205, 205, 205, 202, 202, 203, 203, 203, 205, 205, 206,
    207, 207, 255, 3,   27,  205, 205, 206, 206, 205, 204, 205, 204, 203, 205,
    205, 204, 206, 206, 207, 207, 206, 205, 204, 204, 202, 202, 202, 203, 204,
    205, 205, 207, 207, 255, 3,   10,  205, 205, 206, 205, 204, 204, 203, 202,
    205, 205, 203, 203, 16,  14,  207, 207, 207, 207, 207, 206, 204, 203, 203,
    203, 203, 204, 203, 204, 206, 206, 255, 3,   10,  206, 206, 206, 205, 203,
    203, 203, 204, 205, 205, 204, 204, 21,  10,  206, 206, 206, 205, 204, 203,
    203, 202, 204, 205, 206, 206, 255, 3,   9,   205, 205, 205, 204, 203, 203,
    204, 204, 206, 206, 206, 22,  10,  206, 206, 206, 205, 204, 201, 202, 202,
    204, 206, 207, 207, 255, 3,   9,   206, 206, 205, 203, 202, 203, 205, 205,
    205, 206, 206, 22,  10,  206, 206, 206, 206, 205, 202, 201, 201, 203, 205,
    207, 207, 255, 3,   8,   206, 206, 204, 203, 202, 204, 204, 205, 205, 205,
    25,  7,   206, 206, 205, 204, 201, 203, 205, 206, 206, 255, 4,   6,   206,
    206, 204, 203, 204, 205, 205, 205, 25,  7,   206, 206, 205, 204, 201, 203,
    204, 206, 206, 255, 4,   6,   205, 205, 205, 203, 203, 204, 205, 205, 26,
    6,   205, 205, 204, 203, 202, 204, 207, 207, 255, 1,   2,   207, 207, 207,
    207, 4,   6,   205, 205, 205, 204, 205, 206, 206, 206, 26,  6,   206, 206,
    204, 204, 202, 205, 207, 207, 255, 1,   2,   206, 206, 206, 206, 4,   7,
    206, 206, 205, 204, 206, 207, 207, 207, 207, 27,  4,   205, 205, 205, 204,
    205, 205, 255, 1,   11,  205, 205, 205, 205, 205, 206, 205, 206, 207, 207,
    207, 207, 207, 27,  4,   206, 206, 206, 205, 206, 206, 255, 0,   10,  205,
    205, 205, 204, 204, 205, 205, 205, 206, 206, 207, 207, 27,  4,   207, 207,
    206, 206, 207, 207, 255, 0,   9,   205, 205, 205, 203, 204, 205, 204, 204,
    206, 206, 206, 20,  2,   207, 207, 207, 207, 27,  3,   207, 207, 207, 207,
    207, 255, 0,   9,   206, 206, 205, 203, 202, 203, 204, 203, 205, 206, 206,
    19,  3,   206, 206, 207, 207, 207, 27,  1,   207, 207, 207, 255, 0,   9,
    206, 206, 206, 203, 202, 202, 203, 203, 204, 206, 206, 19,  3,   205, 205,
    207, 207, 207, 25,  1,   207, 207, 207, 255, 0,   10,  207, 207, 206, 204,
    201, 201, 203, 204, 204, 203, 207, 207, 17,  3,   204, 204, 204, 205, 205,
    25,  3,   207, 207, 207, 207, 207, 255, 0,   11,  207, 207, 207, 205, 202,
    201, 202, 203, 204, 203, 202, 204, 204, 16,  4,   204, 204, 204, 204, 206,
    206, 25,  3,   206, 206, 207, 207, 207, 255, 1,   11,  207, 207, 207, 206,
    201, 201, 202, 203, 204, 203, 203, 204, 204, 14,  6,   205, 205, 203, 203,
    204, 205, 207, 207, 24,  5,   204, 204, 206, 206, 207, 207, 207, 255, 1,
    18,  207, 207, 207, 207, 203, 202, 201, 202, 203, 204, 204, 204, 204, 203,
    202, 202, 205, 206, 205, 205, 23,  6,   204, 204, 203, 203, 205, 207, 207,
    207, 255, 2,   17,  207, 207, 207, 206, 203, 202, 202, 202, 204, 205, 205,
    204, 203, 203, 206, 206, 205, 205, 205, 23,  6,   205, 205, 202, 202, 204,
    205, 207, 207, 255, 4,   14,  207, 207, 207, 205, 204, 205, 205, 206, 207,
    207, 205, 206, 206, 204, 205, 205, 23,  6,   203, 203, 202, 202, 204, 205,
    207, 207, 255, 5,   5,   207, 207, 207, 206, 206, 206, 206, 12,  5,   207,
    207, 207, 206, 204, 204, 204, 21,  8,   205, 205, 203, 203, 204, 203, 205,
    205, 207, 207, 255, 13,  3,   207, 207, 207, 205, 205, 20,  9,   203, 203,
    203, 203, 204, 204, 204, 205, 207, 207, 207, 255, 18,  10,  205, 205, 203,
    203, 203, 205, 205, 203, 203, 206, 207, 207, 255, 16,  12,  207, 207, 207,
    205, 203, 205, 206, 203, 204, 206, 206, 207, 207, 207, 255, 14,  13,  207,
    207, 207, 207, 206, 206, 206, 206, 205, 205, 206, 205, 207, 207, 207, 255,
    16,  9,   207, 207, 206, 206, 206, 205, 204, 204, 206, 207, 207, 255,
};
