### 0.16.0 (2025-12-31)

Features:

* [Installer]
  * feat(installer,v2): add version-aware manylinux support for 0.15.0+
  * feat(installer,v2): support WasmEdge 0.15.0 tarball structure
* [CAPI]
  * feat(api): allow redirect of stdin, stdout, and stderr in C SDK (#4207)
  * feat(api): refactor the api header file (#4409)
  * feat(api): new api for setting wasm standard in config
* [WASI]
  * feat(wasi): export wasi module to calling frame
  * feat(wasi): don't handle append flag ourself
* [WASI-NN]
  * feat(wasi-nn): bump llama.cpp b7090
  * feat(wasi-nn): bump wasi-nn plugin to 0.1.34
  * feat(wasi-nn): support gpt-oss (#4300)
  * feat(wasi-nn): remove llama_context_default_params, use default common_params value
  * feat(wasi-nn,bitnet): add BitNet backend support (#4253)
  * feat(wasi-nn,ggml): support MiniCPM-V4.5 (#4336)
  * feat(wasi-nn,MLX): support whisper for MLX backend (#4322)
  * feat(wasi-nn,ggml): adjust seed type (#4407)
  * feat(wasi-nn): provide WASMEDGE_FORCE_DOWNLOAD_SIMDJSON to avoid using system simdjson
  * fix(WASI-NN/MLX): change loadBytesFromFile ifstream
  * refactor(WASI-NN/GGML): parse metadata (#4370)
  * refactor(WASI-NN/GGML): refactor function structure (#4383)
* [Plugin]
  * feat(plugin): add WasmEdgeIOstream API (#4197)
  * feat(plugin): bump the dependencies of wasmedge-ffmpeg, ffmpeg to 7.1 (#4327)
* [AOT]
  * feat(aot): add support for llvm 21 (#4361)
* [Tools]
  * feat(tools): tool options for wasm 3.0

Fixed issues:

* [Installer]
  * fix(installer): v1: fix the incompatible issues for v0.15.0 (#4298)
  * fix(installer): unified the download link of the ggml plugin
* [ComponentModel]
  * fix(validator): correct core module handling (#4295)
  * refactor(runtime,executor): implement the import manager to correct the isolation if import scope in nested components
  * refactor(ast): move the component value type structure to common
  * refactor(ast): make the component function type better use
  * refactor(common): separate the wasm and component values
  * refactor(validator): refine the nested component entry
  * refactor(executor): simplify the component function execution
* [AOT]
  * fix(llvm): ignore contents of virtual sections
  * fix(llvm): fill correct null reference value
  * fix(compiler): report error for implemented instructions
  * fix(compiler): lost filtering out the exception handling instructions in aot (#4416)
* [Validator]
  * fix(common, validator): add the missing `noexn` heap type
  * fix(loader, validator): fix for some memory64 tests
  * fix(validator): lost getting top type of exnref (#4415)
  * fix(validator): refine the logic of validating subtype depth
* [Executor]
  * fix(executor): check iterator is valid before using
  * fix(runtime): refine the overflow detection when wrapping memory instance
* [Tools]
  * fix(tools): output funcref and externref (#4324)
  * fix(cli): print signed value instead of unsigned (#4417)
* [WASI]
  * fix: export initWithFds
  * fix: handle windows end of line
  * fix: added alignment checks in WASI host functions
* [WASI-NN]
  * fix(WASI-NN,ggml): fix compiler warning on windows
  * fix(WASI-NN,ggml): fixed embedding issue (#4350)
  * fix(WASI-NN): use binary mode for binary file
  * fix(WASI-NN,ggml): keep size_t for the type match on macOS (#4437)
  * fix(WASI-NN,ggml): moving the function definitions to prevent macos linker issue (#4463)

Tests:

* test: fix ubsan warnings (#4341)
* test: fix code to apply wasm 3.0 and new commands in spec tests
* test(wasi): added tests for WASI host function alignment validation
* test(component): ignore component validator tests until implementation ready

Misc:

* chore: nomination of HanWen Tsao as WasmEdge Maintainer (#4402)
* docs(roadmap): update roadmap for Q4/2025
* docs(README): fix broken introduction and blog links (#4452)
* feat: support WasmEdge on the s390x platform (#4251)
* feat: remove the legacy exception-handling proposal contents due to wasm 3.0 released
* feat(common): default turn on wasm 3.0

CI:

* [dependabot]
  * ci(dependabot): bump the upload-and-download-artifact group with 2 updates
  * ci(dependabot): bump step-security/harden-runner from 2.13.0 to 2.14.0
  * ci(dependabot): bump actions/setup-python from 5.6.0 to 6.1.0
  * ci(dependabot): bump actions/github-script from 7.0.1 to 8.0.0
  * ci(dependabot): bump actions/labeler from 5.0.0 to 6.0.1
  * ci(dependabot): bump codecov/codecov-action from 5.4.3 to 5.5.2
  * ci(dependabot): bump docker/bake-action from 6.8.0 to 6.10.0 in the docker group
  * ci(dependabot): bump docker/login-action from 3.4.0 to 3.6.0 in the docker group
  * ci(dependabot): bump docker/setup-buildx-action from 3.11.1 to 3.12.0 in the docker group
  * ci(dependabot): bump actions/checkout from 4.2.2 to 6.0.1
  * ci(dependabot): bump github/codeql-action from 3.29.3 to 4.31.9
  * ci(dependabot): bump actions/cache from 4.2.3 to 5.0.1
  * ci(dependabot): bump cachix/install-nix-action from 31.5.1 to 31.9.0
  * ci(dependabot): bump actions/download-artifact from 4.3.0 to 5.0.0 in the upload-and-download-artifact group
* [Runner]
  * ci(commitlint): set header-max-length to warning level due to Dependabot will create long commit header (#4314)
  * ci(commitlint): pinned the commitlint related packages
  * ci(brew): uninstall pre-installed cmake to avoid the conflict
  * ci(macos): don't install cmake due to the conflict inside macos runner image (#4363)
  * ci(macos): remove eval brew shellenv
  * ci(linter): use cargo install lineguard
  * ci(linter): pinned the codespell packages
  * ci(linter): remove trailing spaces and add missing newline at end of file
  * ci(installer): pinned the black==25.1.0
  * ci(WASI-NN/MLX): support cmake version
  * ci(runner): update macOS 13 runner to 14-large, due to deprecation
  * ci(runner): update python to 3.12 for wasi-testsuite
  * ci(runner): update adapter for wasi-testsuite
  * ci(runner): use windows-2025 instead of 2022 due to the EOL of win10
  * ci(runner): update winsdk version
  * ci(runner): use clang-cl for wasi-nn
  * ci(runner): update llvm-windows to 21.1.3
  * ci(runner): fix spdlog warnings
  * ci(runner): fix dependency for alpine-static and debian-static (#4460)
  * feat(docker): add standalone alpine-base image build pipeline (#4466)

Thank all the contributors who made this release possible!

Han-Wen Tsao, Karan Lokchandani, Khush Agrawal, Minimega12121, Sankalp Jha, Shen-Ta Hsieh(BestSteve), Vishruth Thimmaiah, Wang-Yang, Li, Yi, Yi-Ying He, cmd05, dm4, grorge, hydai

If you want to build from source, please use WasmEdge-0.16.0-src.tar.gz instead of the zip or tarball provided by GitHub directly.
