/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/*

JISX0213 to unicode tables are taken from the GNU LIBICONV Library,
Copyright (C) 1999-2004 Free Software Foundation, Inc.

*/

#include "ultima/ultima8/misc/pent_include.h"


namespace Ultima {
namespace Ultima8 {

// U8's encoding to unicode

uint16 encoding[256] = {
	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, //0x00
	0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, //0x10
	0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, //0x20
	0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, //0x30
	0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, //0x40
	0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, //0x50
	0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, //0x60
	0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, //0x70
	0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,

	0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x00E0, 0x00E5, 0x00E7, //0x80
	0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x00EC, 0x00C4, 0x00C5,
	0x00C9, 0x00E6, 0x00C6, 0x00F4, 0x00F6, 0x00F2, 0x00FB, 0x00F9, //0x90
	0x00FF, 0x00D6, 0x00DC, 0x00F8, 0x00A3, 0x00D8, 0x00D7, 0x0192,
	0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA, //0xA0
	0x00BF, 0x00AE, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00BB,
	0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00C1, 0x00C2, 0x00C0, //0xB0
	0x00A9, 0x2563, 0x2551, 0x2557, 0x255D, 0x00A2, 0x00A5, 0x2510,
	0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x00E3, 0x00C3, //0xC0
	0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x00A4,
	0x00F0, 0x00D0, 0x00CA, 0x00CB, 0x00C8, 0x0131, 0x00CD, 0x00CE, //0xD0
	0x00CF, 0x2518, 0x250C, 0x2588, 0x2584, 0x00A6, 0x00CC, 0x2580,
	0x00D3, 0x00DF, 0x00D4, 0x00D2, 0x00F5, 0x00D5, 0x00B5, 0x00FE, //0xE0
	0x00DE, 0x00DA, 0x00DB, 0x00D9, 0x00FD, 0x00DD, 0x00AF, 0x00B4,
	0x00AD, 0x00B1, 0x2017, 0x00BE, 0x00B6, 0x00A7, 0x00F7, 0x00B8, //0xF0
	0x00B0, 0x00A8, 0x00B7, 0x00B9, 0x00B3, 0x00B2, 0x25A0, 0x00A0
};

// first 256 unicode code points to U8's encoding

uint8 reverse_encoding[256] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //0x80
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //0x90
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xAD, 0xBD, 0x9C, 0xCF, 0xBE, 0xDD, 0xF5, //0xA0
	0xF9, 0xB8, 0xA6, 0xAE, 0xAA, 0xF0, 0xA9, 0xEE,
	0xF8, 0xF1, 0xFD, 0xFC, 0xEF, 0xE6, 0xF4, 0xFA, //0xB0
	0xF7, 0xFB, 0xA7, 0xAF, 0xAC, 0xAB, 0xF3, 0xA8,
	0xB7, 0xB5, 0xB6, 0xC7, 0x8E, 0x8F, 0x92, 0x80, //0xC0
	0xD4, 0x90, 0xD2, 0xD3, 0xDE, 0xD6, 0xD7, 0xD8,
	0xD1, 0xA5, 0xE3, 0xE0, 0xE2, 0xE5, 0x99, 0x9E, //0xD0
	0x9D, 0xEB, 0xE9, 0xEA, 0x9A, 0xED, 0xE8, 0xE1,
	0x85, 0xA0, 0x83, 0xC6, 0x84, 0x86, 0x91, 0x87, //0xE0
	0x8A, 0x82, 0x88, 0x89, 0x8D, 0xA1, 0x8C, 0x8B,
	0xD0, 0xA4, 0x95, 0xA2, 0x93, 0xE4, 0x94, 0xF6, //0xF0
	0x9B, 0x97, 0xA3, 0x96, 0x81, 0xEC, 0xE7, 0x98
};

// This table is a PARTIAL copy of the table of the same name in
// libiconv's jisx0213.h
static const uint16 jisx0213_to_ucs_main[94 * 94] = {
	/* 0x12121..0x1217E */
	0x1000, 0x1001, 0x1002, 0x830c, 0x830e, 0x10fb, 0x831a, 0x831b,
	0x831f, 0x8301, 0x109b, 0x109c, 0x00b4, 0x8340, 0x00a8, 0x833e,
	0x83e3, 0x833f, 0x10fd, 0x10fe, 0x109d, 0x109e, 0x1003, 0x2edd,
	0x1005, 0x1006, 0x1007, 0x10fc, 0x0714, 0x0710, 0x830f, 0x833c,
	0x101c, 0x0716, 0x835c, 0x0726, 0x0725, 0x0718, 0x0719, 0x071c,
	0x071d, 0x8308, 0x8309, 0x1014, 0x1015, 0x833b, 0x833d, 0x835b,
	0x835d, 0x1008, 0x1009, 0x100a, 0x100b, 0x100c, 0x100d, 0x100e,
	0x100f, 0x1010, 0x1011, 0x830b, 0x0912, 0x00b1, 0x00d7, 0x00f7,
	0x831d, 0x0960, 0x831c, 0x831e, 0x0966, 0x0967, 0x091e, 0x0934,
	0x0d42, 0x0d40, 0x00b0, 0x0732, 0x0733, 0x0803, 0x83e5, 0x8304,
	0x00a2, 0x00a3, 0x8305, 0x8303, 0x8306, 0x830a, 0x8320, 0x00a7,
	0x0d06, 0x0d05, 0x0ccb, 0x0ccf, 0x0cce, 0x0cc7,
	/* 0x12221..0x1227E */
	0x0cc6, 0x0ca1, 0x0ca0, 0x0cb3, 0x0cb2, 0x0cbd, 0x0cbc, 0x073b,
	0x1012, 0x0892, 0x0890, 0x0891, 0x0893, 0x1013, 0x8307, 0x8302,
	0x830d, 0x835e, 0x1033, 0x1034, 0x1035, 0x103b, 0x103c, 0x10ff,
	0x109f, 0x0908, 0x090b, 0x0986, 0x0987, 0x0982, 0x0983, 0x092a,
	0x0929, 0x0984, 0x0985, 0x098a, 0x098b, 0x0909, 0x0905, 0x0a05,
	0x0a06, 0x0927, 0x0928, 0x00ac, 0x08d2, 0x08d4, 0x0900, 0x0903,
	0x0995, 0x0996, 0x0997, 0x0925, 0x0926, 0x835f, 0x8360, 0x1018,
	0x1019, 0x1016, 0x1017, 0x0920, 0x09a5, 0x0a12, 0x0902, 0x0907,
	0x0961, 0x0952, 0x096a, 0x096b, 0x091a, 0x093d, 0x091d, 0x0935,
	0x092b, 0x092c, 0x0962, 0x0943, 0x0945, 0x0948, 0x0976, 0x0977,
	0x0894, 0x082b, 0x0730, 0x0d6f, 0x0d6d, 0x0d6a, 0x0720, 0x0721,
	0x00b6, 0x0d6e, 0x0d6b, 0x0d6c, 0x0d69, 0x0cef,
	/* 0x12321..0x1237E */
	0x0cb7, 0x0cb6, 0x0cc1, 0x0cc0, 0x0897, 0x0898, 0x0896, 0x0899,
	0x08c4, 0x08e8, 0x08e6, 0x08e7, 0x08e9, 0x0f34, 0x0f35, 0x8310,
	0x8311, 0x8312, 0x8313, 0x8314, 0x8315, 0x8316, 0x8317, 0x8318,
	0x8319, 0x0fbf, 0x0cc9, 0x103d, 0x8246, 0x8245, 0x0ce6, 0x0722,
	0x8321, 0x8322, 0x8323, 0x8324, 0x8325, 0x8326, 0x8327, 0x8328,
	0x8329, 0x832a, 0x832b, 0x832c, 0x832d, 0x832e, 0x832f, 0x8330,
	0x8331, 0x8332, 0x8333, 0x8334, 0x8335, 0x8336, 0x8337, 0x8338,
	0x8339, 0x833a, 0x0913, 0x0835, 0x080f, 0x13cb, 0x0813, 0x0827,
	0x8341, 0x8342, 0x8343, 0x8344, 0x8345, 0x8346, 0x8347, 0x8348,
	0x8349, 0x834a, 0x834b, 0x834c, 0x834d, 0x834e, 0x834f, 0x8350,
	0x8351, 0x8352, 0x8353, 0x8354, 0x8355, 0x8356, 0x8357, 0x8358,
	0x8359, 0x835a, 0x10a0, 0x0713, 0x0ffa, 0x0ffb,
	/* 0x12421..0x1247E */
	0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047, 0x1048,
	0x1049, 0x104a, 0x104b, 0x104c, 0x104d, 0x104e, 0x104f, 0x1050,
	0x1051, 0x1052, 0x1053, 0x1054, 0x1055, 0x1056, 0x1057, 0x1058,
	0x1059, 0x105a, 0x105b, 0x105c, 0x105d, 0x105e, 0x105f, 0x1060,
	0x1061, 0x1062, 0x1063, 0x1064, 0x1065, 0x1066, 0x1067, 0x1068,
	0x1069, 0x106a, 0x106b, 0x106c, 0x106d, 0x106e, 0x106f, 0x1070,
	0x1071, 0x1072, 0x1073, 0x1074, 0x1075, 0x1076, 0x1077, 0x1078,
	0x1079, 0x107a, 0x107b, 0x107c, 0x107d, 0x107e, 0x107f, 0x1080,
	0x1081, 0x1082, 0x1083, 0x1084, 0x1085, 0x1086, 0x1087, 0x1088,
	0x1089, 0x108a, 0x108b, 0x108c, 0x108d, 0x108e, 0x108f, 0x1090,
	0x1091, 0x1092, 0x1093, 0x1094, 0x1095, 0x1096, 0x0001, 0x0002,
	0x0003, 0x0004, 0x0005, 0x0000, 0x0000, 0x0000,
	/* 0x12521..0x1257E */
	0x10a1, 0x10a2, 0x10a3, 0x10a4, 0x10a5, 0x10a6, 0x10a7, 0x10a8,
	0x10a9, 0x10aa, 0x10ab, 0x10ac, 0x10ad, 0x10ae, 0x10af, 0x10b0,
	0x10b1, 0x10b2, 0x10b3, 0x10b4, 0x10b5, 0x10b6, 0x10b7, 0x10b8,
	0x10b9, 0x10ba, 0x10bb, 0x10bc, 0x10bd, 0x10be, 0x10bf, 0x10c0,
	0x10c1, 0x10c2, 0x10c3, 0x10c4, 0x10c5, 0x10c6, 0x10c7, 0x10c8,
	0x10c9, 0x10ca, 0x10cb, 0x10cc, 0x10cd, 0x10ce, 0x10cf, 0x10d0,
	0x10d1, 0x10d2, 0x10d3, 0x10d4, 0x10d5, 0x10d6, 0x10d7, 0x10d8,
	0x10d9, 0x10da, 0x10db, 0x10dc, 0x10dd, 0x10de, 0x10df, 0x10e0,
	0x10e1, 0x10e2, 0x10e3, 0x10e4, 0x10e5, 0x10e6, 0x10e7, 0x10e8,
	0x10e9, 0x10ea, 0x10eb, 0x10ec, 0x10ed, 0x10ee, 0x10ef, 0x10f0,
	0x10f1, 0x10f2, 0x10f3, 0x10f4, 0x10f5, 0x10f6, 0x0006, 0x0007,
	0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d,
	/* 0x12621..0x1267E */
	0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398,
	0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0,
	0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9,
	0x0d64, 0x0d60, 0x0d62, 0x0d66, 0x0d61, 0x0d65, 0x0d67, 0x0d63,
	0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8,
	0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0,
	0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9,
	0x03c2, 0x0bf5, 0x0bf6, 0x0bf7, 0x0bf8, 0x0bf9, 0x0bfa, 0x0bfb,
	0x0bfc, 0x0bfd, 0x0bfe, 0x0d16, 0x0d17, 0x1020, 0x0d0e, 0x0d00,
	0x0d01, 0x0d02, 0x0d03, 0x0d68, 0x0cb1, 0x11f0, 0x11f1, 0x11f2,
	0x11f3, 0x11f4, 0x11f5, 0x11f6, 0x11f7, 0x11f8, 0x11f9, 0x000e,
	0x11fa, 0x11fb, 0x11fc, 0x11fd, 0x11fe, 0x11ff,
	/* 0x12721..0x1277E */
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416,
	0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e,
	0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426,
	0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e,
	0x042f, 0x0abe, 0x0abf, 0x0ac0, 0x0ac1, 0x0ac2, 0x0ac3, 0x0ac4,
	0x0ac5, 0x0ac6, 0x0ac7, 0x0ac8, 0x0ac9, 0x0aca, 0x0acb, 0x0acc,
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436,
	0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e,
	0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446,
	0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e,
	0x044f, 0x10f7, 0x10f8, 0x10f9, 0x10fa, 0x09da, 0x09db, 0x0853,
	0x0854, 0x0855, 0x0e13, 0x0a18, 0x0b23, 0x0ace,
	/* 0x12821..0x1287E */
	0x0c00, 0x0c02, 0x0c0c, 0x0c10, 0x0c18, 0x0c14, 0x0c1c, 0x0c2c,
	0x0c24, 0x0c34, 0x0c3c, 0x0c01, 0x0c03, 0x0c0f, 0x0c13, 0x0c1b,
	0x0c17, 0x0c23, 0x0c33, 0x0c2b, 0x0c3b, 0x0c4b, 0x0c20, 0x0c2f,
	0x0c28, 0x0c37, 0x0c3f, 0x0c1d, 0x0c30, 0x0c25, 0x0c38, 0x0c42,
	0x1251, 0x1252, 0x1253, 0x1254, 0x1255, 0x1256, 0x1257, 0x1258,
	0x1259, 0x125a, 0x125b, 0x125c, 0x125d, 0x125e, 0x125f, 0x12b1,
	0x12b2, 0x12b3, 0x12b4, 0x12b5, 0x12b6, 0x12b7, 0x12b8, 0x12b9,
	0x12ba, 0x12bb, 0x12bc, 0x12bd, 0x12be, 0x12bf, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cd0, 0x0cd1,
	0x0cd2, 0x0cd3, 0x073c, 0x0747, 0x0748, 0x0749, 0x01cd, 0x01ce,
	0x01d0, 0x053e, 0x053f, 0x01f8, 0x01f9, 0x01d1, 0x01d2, 0x01d4,
	0x01d6, 0x01d8, 0x01da, 0x01dc, 0x0000, 0x0000,
	/* 0x12921..0x1297E */
	0x07ac, 0x00a0, 0x00a1, 0x00a4, 0x00a6, 0x00a9, 0x00aa, 0x00ab,
	0x00ad, 0x00ae, 0x00af, 0x00b2, 0x00b3, 0x00b7, 0x00b8, 0x00b9,
	0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 0x00c0, 0x00c1,
	0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 0x00c8, 0x00c9,
	0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 0x00d0, 0x00d1,
	0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d8, 0x00d9, 0x00da,
	0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e2,
	0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 0x00e8, 0x00e9, 0x00ea,
	0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 0x00f0, 0x00f1, 0x00f2,
	0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f8, 0x00f9, 0x00fa, 0x00fb,
	0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x012a, 0x016a, 0x0112,
	0x014c, 0x0101, 0x012b, 0x016b, 0x0113, 0x014d,
	/* 0x12A21..0x12A7E */
	0x0104, 0x02d8, 0x0141, 0x013d, 0x015a, 0x0160, 0x015e, 0x0164,
	0x0179, 0x017d, 0x017b, 0x0105, 0x02db, 0x0142, 0x013e, 0x015b,
	0x02c7, 0x0161, 0x015f, 0x0165, 0x017a, 0x02dd, 0x017e, 0x017c,
	0x0154, 0x0102, 0x0139, 0x0106, 0x010c, 0x0118, 0x011a, 0x010e,
	0x0143, 0x0147, 0x0150, 0x0158, 0x016e, 0x0170, 0x0162, 0x0155,
	0x0103, 0x013a, 0x0107, 0x010d, 0x0119, 0x011b, 0x010f, 0x0111,
	0x0144, 0x0148, 0x0151, 0x0159, 0x016f, 0x0171, 0x0163, 0x02d9,
	0x0108, 0x011c, 0x0124, 0x0134, 0x015c, 0x016c, 0x0109, 0x011d,
	0x0125, 0x0135, 0x015d, 0x016d, 0x0271, 0x028b, 0x027e, 0x0283,
	0x0292, 0x026c, 0x026e, 0x0279, 0x0288, 0x0256, 0x0273, 0x027d,
	0x0282, 0x0290, 0x027b, 0x026d, 0x025f, 0x0272, 0x029d, 0x028e,
	0x0261, 0x014b, 0x0270, 0x0281, 0x0127, 0x0295,
	/* 0x12B21..0x12B7E */
	0x0294, 0x0266, 0x0298, 0x01c2, 0x0253, 0x0257, 0x0284, 0x0260,
	0x0193, 0x0153, 0x0152, 0x0268, 0x0289, 0x0258, 0x0275, 0x0259,
	0x025c, 0x025e, 0x0250, 0x026f, 0x028a, 0x0264, 0x028c, 0x0254,
	0x0251, 0x0252, 0x028d, 0x0265, 0x02a2, 0x02a1, 0x0255, 0x0291,
	0x027a, 0x0267, 0x025a, 0x000f, 0x01fd, 0x0670, 0x0671, 0x0010,
	0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0672,
	0x0673, 0x0361, 0x02c8, 0x02cc, 0x02d0, 0x02d1, 0x0306, 0x073f,
	0x030b, 0x0301, 0x0304, 0x0300, 0x030f, 0x030c, 0x0302, 0x02e5,
	0x02e6, 0x02e7, 0x02e8, 0x02e9, 0x0018, 0x0019, 0x0325, 0x032c,
	0x0339, 0x031c, 0x031f, 0x0320, 0x0308, 0x033d, 0x0329, 0x032f,
	0x02de, 0x0324, 0x0330, 0x033c, 0x0334, 0x031d, 0x031e, 0x0318,
	0x0319, 0x032a, 0x033a, 0x033b, 0x0303, 0x031a,
	/* 0x12C21..0x12C7E */
	0x0e76, 0x0e77, 0x0e78, 0x0e79, 0x0e7a, 0x0e7b, 0x0e7c, 0x0e7d,
	0x0e7e, 0x0e7f, 0x0beb, 0x0bec, 0x0bed, 0x0bee, 0x0bef, 0x0bf0,
	0x0bf1, 0x0bf2, 0x0bf3, 0x0bf4, 0x0870, 0x0871, 0x0872, 0x0873,
	0x0874, 0x0875, 0x0876, 0x0877, 0x0878, 0x0879, 0x087a, 0x087b,
	0x0bd0, 0x0bd1, 0x0bd2, 0x0bd3, 0x0bd4, 0x0bd5, 0x0bd6, 0x0bd7,
	0x0bd8, 0x0bd9, 0x0bda, 0x0bdb, 0x0bdc, 0x0bdd, 0x0bde, 0x0bdf,
	0x0be0, 0x0be1, 0x0be2, 0x0be3, 0x0be4, 0x0be5, 0x0be6, 0x0be7,
	0x0be8, 0x0be9, 0x12d0, 0x12d1, 0x12d2, 0x12d3, 0x12d4, 0x12d5,
	0x12d6, 0x12d7, 0x12d8, 0x12d9, 0x12da, 0x12db, 0x12dc, 0x12dd,
	0x12de, 0x12df, 0x12e0, 0x12e1, 0x12e2, 0x12e3, 0x12fa, 0x12e9,
	0x12e5, 0x12ed, 0x12ec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0751, 0x0742,
	/* 0x12D21..0x12D7E */
	0x0b60, 0x0b61, 0x0b62, 0x0b63, 0x0b64, 0x0b65, 0x0b66, 0x0b67,
	0x0b68, 0x0b69, 0x0b6a, 0x0b6b, 0x0b6c, 0x0b6d, 0x0b6e, 0x0b6f,
	0x0b70, 0x0b71, 0x0b72, 0x0b73, 0x0860, 0x0861, 0x0862, 0x0863,
	0x0864, 0x0865, 0x0866, 0x0867, 0x0868, 0x0869, 0x086a, 0x1349,
	0x1314, 0x1322, 0x134d, 0x1318, 0x1327, 0x1303, 0x1336, 0x1351,
	0x1357, 0x130d, 0x1326, 0x1323, 0x132b, 0x134a, 0x133b, 0x139c,
	0x139d, 0x139e, 0x138e, 0x138f, 0x13c4, 0x13a1, 0x086b, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x137b, 0x101d,
	0x101f, 0x0816, 0x13cd, 0x0821, 0x12a4, 0x12a5, 0x12a6, 0x12a7,
	0x12a8, 0x1231, 0x1232, 0x1239, 0x137e, 0x137d, 0x137c, 0x0000,
	0x0000, 0x0000, 0x092e, 0x0000, 0x0000, 0x0000, 0x0000, 0x091f,
	0x09bf, 0x0000, 0x0000, 0x0000, 0x0e56, 0x0d1e,
	/* 0x12E21..0x12E7E */
	0x2ff1, 0x840b, 0x1402, 0x2e28, 0x2e2f, 0x2e30, 0x2e8d, 0x2ee1,
	0x2efd, 0x2eff, 0x2f03, 0x2f0b, 0x2f60, 0x2f48, 0x2f49, 0x2f56,
	0x2f5f, 0x2f6a, 0x2f6c, 0x2f7e, 0x2f8a, 0x2f94, 0x2f97, 0x8130,
	0x2fc9, 0x2fe0, 0x3001, 0x3002, 0x300e, 0x3018, 0x3027, 0x302e,
	0x3040, 0x303b, 0x3041, 0x3094, 0x30cc, 0x30f2, 0x30d0, 0x30e6,
	0x8131, 0x3106, 0x3103, 0x310b, 0x311e, 0x3135, 0x314a, 0x8132,
	0x3155, 0x3157, 0x14b5, 0x319d, 0x31c3, 0x31ca, 0x31de, 0x31e2,
	0x31ee, 0x3201, 0x14db, 0x3213, 0x3215, 0x3249, 0x3257, 0x3261,
	0x3293, 0x32c8, 0x8133, 0x32cc, 0x32d0, 0x32d6, 0x32db, 0x8134,
	0x32f0, 0x32fb, 0x3300, 0x3307, 0x331c, 0x8135, 0x3361, 0x3363,
	0x337d, 0x3393, 0x339d, 0x33b2, 0x3412, 0x3427, 0x344d, 0x349c,
	0x346b, 0x3474, 0x347f, 0x3488, 0x3496, 0x34a1,
	/* 0x12F21..0x12F7E */
	0x34a9, 0x34c6, 0x34ff, 0x350e, 0x352b, 0x3535, 0x3550, 0x355e,
	0x3581, 0x3586, 0x358e, 0x8136, 0x35ad, 0x35ce, 0x8137, 0x3608,
	0x360e, 0x363b, 0x3649, 0x3676, 0x3666, 0x8138, 0x366f, 0x3671,
	0x3672, 0x3699, 0x369e, 0x36a9, 0x36ac, 0x36b3, 0x36c9, 0x36ca,
	0x370a, 0x923d, 0x3721, 0x372f, 0x3733, 0x3734, 0x3770, 0x3777,
	0x377c, 0x379c, 0x810f, 0x931b, 0x37b8, 0x37c7, 0x37c8, 0x37cf,
	0x37e4, 0x37ed, 0x37f5, 0x37f6, 0x37ff, 0x3809, 0x8110, 0x3861,
	0x3864, 0x8139, 0x387c, 0x3889, 0x389e, 0x813a, 0x38a9, 0x946e,
	0x38d2, 0x38ce, 0x38d4, 0x38da, 0x38e0, 0x38e9, 0x390c, 0x6641,
	0x395d, 0x396d, 0x398b, 0x3992, 0x39a4, 0x39c3, 0x39d2, 0x39dd,
	0x3a13, 0x3a23, 0x3a67, 0x3a6d, 0x3a77, 0x3a7e, 0x3a84, 0x3a9e,
	0x3aa7, 0x3ac4, 0x98bd, 0x3b19, 0x3b25, 0x325d,
	/* 0x13021..0x1307E */
	0x2e9c, 0x3516, 0x3a03, 0x763f, 0x34c0, 0x411b, 0x4328, 0x39f6,
	0x7022, 0x6475, 0x631c, 0x5a50, 0x40aa, 0x43e1, 0x4e25, 0x45ed,
	0x6466, 0x62a6, 0x7bf5, 0x4893, 0x3727, 0x45a1, 0x4271, 0x3b9b,
	0x39d0, 0x667b, 0x78f4, 0x5d62, 0x5dbe, 0x7b8e, 0x4216, 0x5c9f,
	0x68b7, 0x3b89, 0x3eb5, 0x4309, 0x4697, 0x4848, 0x75c7, 0x778d,
	0x474f, 0x2ee5, 0x2f0a, 0x2f4d, 0x2f9d, 0x3049, 0x36f2, 0x3937,
	0x39d4, 0x3a01, 0x3c09, 0x40df, 0x410f, 0x4170, 0x4613, 0x4905,
	0x50ba, 0x554f, 0x5570, 0x59fb, 0x5dad, 0x5def, 0x60c3, 0x640e,
	0x6863, 0x6b02, 0x7055, 0x707a, 0x333b, 0x2e95, 0x2ea5, 0x37df,
	0x60b2, 0x70c1, 0x58ef, 0x2e00, 0x38f1, 0x4ea2, 0x7038, 0x5a32,
	0x6328, 0x628b, 0x7c2f, 0x3141, 0x3370, 0x34bd, 0x34e1, 0x36e0,
	0x39fb, 0x3f15, 0x78f2, 0x4deb, 0x60e4, 0x652d,
	/* 0x13121..0x1317E */
	0x7662, 0x7670, 0x76a0, 0x77fb, 0x340b, 0x33f3, 0x3b87, 0x50cf,
	0x5fbd, 0x6fc2, 0x76e8, 0x336f, 0x7d5c, 0x5aba, 0x2e11, 0x5893,
	0x61fc, 0x4e26, 0x3618, 0x3504, 0x4b1d, 0x651a, 0x7c3b, 0x39e5,
	0x33a9, 0x4d66, 0x54dc, 0x758f, 0x3642, 0x2e91, 0x704b, 0x76f2,
	0x634f, 0x790c, 0x33e1, 0x35b6, 0x3b30, 0x3f71, 0x4620, 0x46f3,
	0x4804, 0x4c38, 0x4cf3, 0x4d29, 0x545b, 0x56c8, 0x5a4e, 0x7834,
	0x62f1, 0x685b, 0x6a60, 0x72ed, 0x4db2, 0x55ab, 0x56ca, 0x79c5,
	0x40a6, 0x6b01, 0x6d8a, 0x75b2, 0x498e, 0x33ad, 0x3186, 0x3712,
	0x3830, 0x3944, 0x3bb4, 0x3ef6, 0x4028, 0x43a9, 0x43f4, 0x4cbf,
	0x4f14, 0x508e, 0x5114, 0x5159, 0x51d5, 0x533f, 0x5e01, 0x6276,
	0x62d1, 0x6597, 0x7060, 0x725b, 0x7d1b, 0x3869, 0x45bc, 0x4c5a,
	0x5525, 0x31f9, 0x392e, 0x3965, 0x3f80, 0x3fdc,
	/* 0x13221..0x1327E */
	0x42bc, 0x45fa, 0x4a2a, 0x4b27, 0x4bb4, 0x538b, 0x5fc1, 0x6956,
	0x7d2c, 0x7d0e, 0x7ec4, 0x3ca1, 0x4c96, 0x637b, 0x3104, 0x3c4b,
	0x41b6, 0x61c6, 0x4876, 0x5261, 0x2e59, 0x2ffa, 0x3378, 0x4069,
	0x4e29, 0x5a4f, 0x77f3, 0x2e0b, 0x3316, 0x2eee, 0x2f55, 0x2f3d,
	0x2fa1, 0x2f73, 0x32a0, 0x33ef, 0x3609, 0x390f, 0x3ac1, 0x3bb6,
	0x3be1, 0x59d1, 0x4687, 0x479c, 0x47b6, 0x4b4c, 0x4cb3, 0x506b,
	0x53c2, 0x598d, 0x59be, 0x5a3c, 0x5b87, 0x62b1, 0x62db, 0x6304,
	0x6377, 0x63ef, 0x63d3, 0x6766, 0x6ab2, 0x3629, 0x6ca8, 0x6fe6,
	0x704e, 0x771e, 0x668a, 0x2fc4, 0x3ce8, 0x4211, 0x5259, 0x553b,
	0x61e5, 0x62bd, 0x66fe, 0x6cc0, 0x76c5, 0x7913, 0x79d5, 0x2ecb,
	0x2f1a, 0x69e3, 0x36de, 0x384a, 0x38ca, 0x3efb, 0x3feb, 0x402a,
	0x4094, 0x4062, 0x41d0, 0x4212, 0x42d0, 0x4539,
	/* 0x13321..0x1337E */
	0x7b41, 0x4666, 0x48b0, 0x4d77, 0x5070, 0x554c, 0x5686, 0x5d75,
	0x62a5, 0x67f9, 0x758b, 0x768e, 0x6c9d, 0x31f1, 0x32be, 0x3916,
	0x34b3, 0x3bb3, 0x3d16, 0x4168, 0x4982, 0x4daf, 0x588d, 0x64cb,
	0x6857, 0x6a72, 0x73a7, 0x7ab8, 0x4d6c, 0x79a8, 0x66d9, 0x37a3,
	0x47ff, 0x66ce, 0x720e, 0x3283, 0x3687, 0x3404, 0x3ed3, 0x42e1,
	0x44b9, 0x483c, 0x4838, 0x4bbb, 0x5372, 0x58ba, 0x5a6b, 0x699a,
	0x69d2, 0x6d6b, 0x6f03, 0x70ed, 0x75a3, 0x7694, 0x7769, 0x3b66,
	0x3cb3, 0x497d, 0x784d, 0x784e, 0x439b, 0x5b20, 0x4a2b, 0x4a7f,
	0x48b6, 0x7c0d, 0x4f5f, 0x3272, 0x359d, 0x4070, 0x42ec, 0x4d3b,
	0x4e07, 0x4ed1, 0x645b, 0x6910, 0x6f44, 0x2e14, 0x7c39, 0x33f6,
	0x491b, 0x4a3a, 0x7784, 0x482a, 0x315c, 0x5ac3, 0x64b2, 0x71dc,
	0x738c, 0x365b, 0x7d28, 0x4822, 0x6305, 0x6431,
	/* 0x13421..0x1347E */
	0x5ca5, 0x3208, 0x62c5, 0x54e6, 0x2e7e, 0x2f83, 0x31a0, 0x3bd2,
	0x320a, 0x32d8, 0x32e7, 0x3dfb, 0x359a, 0x382a, 0x39e6, 0x3b8c,
	0x3b98, 0x3bdb, 0x3e72, 0x3e79, 0x40a3, 0x411f, 0x4163, 0x41be,
	0x43db, 0x4562, 0x47d1, 0x4853, 0x48fa, 0x4b3e, 0x4b53, 0x4c57,
	0x4f22, 0x4f97, 0x4f45, 0x54b0, 0x5518, 0x56e3, 0x570b, 0x5aff,
	0x5ba1, 0x5c21, 0x5de9, 0x5f36, 0x5ff0, 0x609d, 0x6266, 0x639e,
	0x69b3, 0x6acc, 0x6cab, 0x7084, 0x7451, 0x7593, 0x7591, 0x75a2,
	0x7665, 0x77d3, 0x7928, 0x6218, 0x2e38, 0x342b, 0x3cb8, 0x3dcc,
	0x53a9, 0x564c, 0x573c, 0x3ca9, 0x5feb, 0x6d0b, 0x76c1, 0x7811,
	0x7854, 0x7858, 0x2f01, 0x2f0e, 0x3371, 0x359c, 0x3668, 0x37fa,
	0x3947, 0x3b09, 0x3bc4, 0x3c90, 0x3e0c, 0x3e7e, 0x3fcc, 0x43ee,
	0x473a, 0x45d7, 0x45e2, 0x471f, 0x48cb, 0x48c4,
	/* 0x13521..0x1357E */
	0x4a5f, 0x3e30, 0x4bc5, 0x4c17, 0x4c7d, 0x557f, 0x5948, 0x3b63,
	0x5a00, 0x5d00, 0x3fbd, 0x698f, 0x6a18, 0x6cb4, 0x6d77, 0x6ecc,
	0x6f1d, 0x78e2, 0x7a0e, 0x7b3c, 0x2e80, 0x307d, 0x3100, 0x3993,
	0x3b9c, 0x422f, 0x4280, 0x44ec, 0x4b3a, 0x52a0, 0x5591, 0x5947,
	0x5fa9, 0x67fb, 0x6abc, 0x6b70, 0x43ac, 0x63ca, 0x77a0, 0x3409,
	0x3403, 0x35ab, 0x4854, 0x4a58, 0x6a70, 0x5827, 0x4775, 0x7ecd,
	0x3374, 0x3ba2, 0x611a, 0x6650, 0x7006, 0x2e18, 0x2e45, 0x2ec7,
	0x2f11, 0x33ca, 0x3438, 0x3bae, 0x3f13, 0x4025, 0x4551, 0x473d,
	0x4c42, 0x4c72, 0x4ce3, 0x5078, 0x5403, 0x5a76, 0x5aae, 0x5b08,
	0x5d1a, 0x5cfe, 0x5d66, 0x45e7, 0x525b, 0x33bb, 0x3c45, 0x3de8,
	0x42d2, 0x42e0, 0x4319, 0x4e20, 0x665a, 0x6a31, 0x6ddd, 0x72f8,
	0x4f01, 0x59a6, 0x7b5a, 0x2ea8, 0x2eab, 0x2eac,
	/* 0x13621..0x1367E */
	0x2f9b, 0x2fa0, 0x30d1, 0x3147, 0x5af6, 0x3171, 0x31f6, 0x3354,
	0x3321, 0x337f, 0x33eb, 0x35ac, 0x3883, 0x3ce1, 0x3f37, 0x3f4a,
	0x402f, 0x4050, 0x406d, 0x431f, 0x4559, 0x4a4b, 0x4cc1, 0x52c2,
	0x52ed, 0x57ef, 0x60f8, 0x6105, 0x6208, 0x654e, 0x70f7, 0x73e1,
	0x77ff, 0x7957, 0x7a5a, 0x2ef0, 0x31dd, 0x3c2d, 0x4681, 0x496d,
	0x3c40, 0x46f2, 0x4975, 0x5389, 0x4850, 0x5c81, 0x30c5, 0x32e4,
	0x3747, 0x3dfe, 0x7326, 0x45a4, 0x4b23, 0x4b3d, 0x5434, 0x5981,
	0x59bd, 0x5b4b, 0x5dca, 0x62b9, 0x63cc, 0x687f, 0x695f, 0x6b39,
	0x6fd1, 0x71d1, 0x341f, 0x7280, 0x2e5d, 0x3036, 0x33e5, 0x333a,
	0x52d7, 0x5396, 0x57e9, 0x62e6, 0x6eaf, 0x79c6, 0x79c8, 0x79d2,
	0x3177, 0x411a, 0x665e, 0x35b0, 0x5a7a, 0x3076, 0x3bd3, 0x7047,
	0x7685, 0x2e32, 0x4adb, 0x71e7, 0x3c51, 0x3c48,
	/* 0x13721..0x1377E */
	0x4398, 0x5a9f, 0x4c93, 0x7774, 0x6f61, 0x5aaa, 0x518a, 0x7688,
	0x5c82, 0x4817, 0x5e70, 0x4851, 0x736c, 0x32f2, 0x341b, 0x65ab,
	0x6a13, 0x5fa4, 0x6ecd, 0x70e1, 0x3366, 0x6888, 0x5941, 0x2fc2,
	0x30be, 0x3211, 0x3144, 0x3553, 0x372d, 0x53ea, 0x378b, 0x3951,
	0x3f62, 0x3f84, 0x4075, 0x4176, 0x4167, 0x41a9, 0x43b2, 0x443a,
	0x456c, 0x466f, 0x4842, 0x4e13, 0x5566, 0x5a3d, 0x5cfb, 0x5d4c,
	0x5d99, 0x5e4b, 0x5f6b, 0x630e, 0x634a, 0x66cd, 0x6a08, 0x6a63,
	0x6b66, 0x6efd, 0x781a, 0x7d8f, 0x62b8, 0x6fce, 0x7be8, 0x3287,
	0x421f, 0x4483, 0x4fc0, 0x7699, 0x4841, 0x3091, 0x4b20, 0x4c7a,
	0x4f54, 0x5a74, 0x5d50, 0x6840, 0x6a23, 0x4708, 0x2ef6, 0x3039,
	0x3026, 0x3065, 0x317c, 0x3238, 0x3263, 0x35a7, 0x370f, 0x3805,
	0x3acc, 0x3efa, 0x41b2, 0x41f8, 0x42f3, 0x4372,
	/* 0x13821..0x1387E */
	0x491c, 0x4a29, 0x527d, 0x52ac, 0x532e, 0x5814, 0x586f, 0x5d79,
	0x570c, 0x60a9, 0x698b, 0x6b19, 0x6ce2, 0x6ed2, 0x7063, 0x7375,
	0x767a, 0x7855, 0x7a13, 0x7e78, 0x3143, 0x339f, 0x33b3, 0x3e7b,
	0x3f26, 0x4e1b, 0x4e90, 0x5384, 0x53fe, 0x5d43, 0x6237, 0x6a00,
	0x6afa, 0x7650, 0x2e4e, 0x300b, 0x33e4, 0x347c, 0x36fa, 0x39d1,
	0x3b64, 0x3df1, 0x3eab, 0x3f27, 0x4238, 0x4545, 0x47af, 0x4e56,
	0x52d0, 0x5cca, 0x68b4, 0x60a1, 0x60e1, 0x63f0, 0x664e, 0x6a87,
	0x6de8, 0x7237, 0x76c7, 0x7867, 0x7f13, 0x2e94, 0x2e92, 0x2f0d,
	0x3348, 0x3449, 0x343e, 0x3a2f, 0x3f8c, 0x3fa1, 0x409f, 0x48a7,
	0x4a8e, 0x545a, 0x5881, 0x6a9e, 0x6aa4, 0x6b77, 0x7190, 0x2e5e,
	0x7bc9, 0x2ea4, 0x2f7c, 0x2faf, 0x3019, 0x3016, 0x3149, 0x316c,
	0x329f, 0x32b9, 0x32fe, 0x339a, 0x33e3, 0x3411,
	/* 0x13921..0x1397E */
	0x340e, 0x3589, 0x3751, 0x37a2, 0x397d, 0x3b54, 0x3b5d, 0x3b8f,
	0x3de5, 0x3de7, 0x3df7, 0x3e78, 0x3e83, 0x3e9a, 0x3eb7, 0x3f18,
	0x4052, 0x414c, 0x4297, 0x42d8, 0x43a7, 0x453b, 0x4602, 0x4643,
	0x46f4, 0x476d, 0x4821, 0x4897, 0x49cb, 0x4c5f, 0x4d2a, 0x4d69,
	0x4e2f, 0x4e9d, 0x5532, 0x5687, 0x586c, 0x5a3f, 0x5ce0, 0x5d05,
	0x5d18, 0x5d5e, 0x5db1, 0x6015, 0x6003, 0x60af, 0x60b1, 0x6154,
	0x618f, 0x622a, 0x6352, 0x684c, 0x6861, 0x6b1b, 0x6ca2, 0x6cfc,
	0x70ca, 0x7175, 0x7271, 0x583f, 0x72fc, 0x75a4, 0x764d, 0x7805,
	0x7999, 0x7ad8, 0x7d3b, 0x325b, 0x32ab, 0x33f7, 0x3408, 0x38d5,
	0x42f7, 0x4fe0, 0x6c6a, 0x6f5f, 0x7eb9, 0x314b, 0x323b, 0x344a,
	0x36fd, 0x5a40, 0x7177, 0x7d60, 0x7ed2, 0x5344, 0x4f09, 0x6170,
	0x5511, 0x3ffd, 0x40da, 0x7aa8, 0x52db, 0x6fbc,
	/* 0x13A21..0x13A7E */
	0x4b64, 0x7803, 0x2eca, 0x36f0, 0x3764, 0x38be, 0x3a5a, 0x4068,
	0x41c7, 0x460f, 0x4606, 0x4839, 0x48b1, 0x4df7, 0x55d5, 0x5d3a,
	0x626e, 0x7b42, 0x2e9b, 0x2f50, 0x33c9, 0x3506, 0x3d6f, 0x3de6,
	0x3dee, 0x47fb, 0x4c99, 0x5473, 0x5802, 0x6a50, 0x7396, 0x68df,
	0x3750, 0x3ea7, 0x432b, 0x30b5, 0x30ac, 0x318d, 0x4700, 0x34c9,
	0x385e, 0x39bb, 0x3bb0, 0x3f69, 0x424d, 0x43a1, 0x483d, 0x4b73,
	0x4e08, 0x507d, 0x71c7, 0x5280, 0x5815, 0x5826, 0x596d, 0x458e,
	0x5d30, 0x63dc, 0x68c1, 0x6f09, 0x769b, 0x3264, 0x3728, 0x4750,
	0x5f6a, 0x6ca1, 0x31b4, 0x3742, 0x762a, 0x383a, 0x498a, 0x60b4,
	0x34b2, 0x3d0e, 0x37fc, 0x5895, 0x7dfa, 0x2f5c, 0x324a, 0x348b,
	0x443e, 0x4628, 0x4714, 0x47f5, 0x5a84, 0x5b56, 0x5d22, 0x732f,
	0x485c, 0x7bad, 0x5b39, 0x3319, 0x318a, 0x3237,
	/* 0x13B21..0x13B7E */
	0x3bdf, 0x42f6, 0x44ae, 0x44e6, 0x472d, 0x4bba, 0x65a9, 0x76d1,
	0x5690, 0x7bd6, 0x434c, 0x7306, 0x7bab, 0x56bf, 0x4652, 0x2e09,
	0x3098, 0x33c2, 0x3c71, 0x40e8, 0x4492, 0x4563, 0x485f, 0x51e6,
	0x53ca, 0x5523, 0x5b97, 0x5e82, 0x6695, 0x6b83, 0x6cdb, 0x7178,
	0x7910, 0x45ac, 0x46ab, 0x4b8b, 0x2ed5, 0x2ed4, 0x2f3a, 0x2f7f,
	0x323a, 0x33f8, 0x33f2, 0x35e3, 0x36db, 0x38eb, 0x39cb, 0x39c9,
	0x39ff, 0x3b50, 0x3c4d, 0x3e02, 0x3e2b, 0x3fd7, 0x401d, 0x4307,
	0x452f, 0x3b5c, 0x45af, 0x45bd, 0x45e8, 0x479d, 0x4b62, 0x4b7b,
	0x4c0f, 0x5345, 0x5949, 0x59c1, 0x5cf8, 0x5d19, 0x5d2b, 0x60a2,
	0x6102, 0x61f3, 0x6996, 0x6a5e, 0x6a69, 0x6a66, 0x6a8c, 0x6aee,
	0x6cc7, 0x6cdc, 0x76cc, 0x78fc, 0x4b6f, 0x2e8b, 0x2f3c, 0x2f8d,
	0x3150, 0x3b57, 0x3bfa, 0x4148, 0x4301, 0x4642,
	/* 0x13C21..0x13C7E */
	0x4b21, 0x4ecb, 0x4cbb, 0x523e, 0x54bd, 0x55d4, 0x58c1, 0x593a,
	0x600c, 0x6033, 0x61ea, 0x6494, 0x6f9e, 0x4c50, 0x7e7f, 0x3f0f,
	0x6b58, 0x7d2b, 0x5afa, 0x6ef8, 0x3b8d, 0x76eb, 0x2e03, 0x33f1,
	0x37f7, 0x3931, 0x3ac9, 0x3ba4, 0x4089, 0x4e7f, 0x4f06, 0x55be,
	0x6cea, 0x3b9f, 0x6500, 0x5be0, 0x3072, 0x47f4, 0x629d, 0x3c61,
	0x654a, 0x5e1e, 0x620e, 0x3199, 0x3c04, 0x4368, 0x6d66, 0x459c,
	0x516e, 0x593e, 0x5d17, 0x6005, 0x6b1d, 0x6eca, 0x706e, 0x66c7,
	0x70aa, 0x301f, 0x32fa, 0x3c3a, 0x4753, 0x507c, 0x5235, 0x714c,
	0x71c8, 0x732b, 0x62e5, 0x3bc2, 0x3f31, 0x40f9, 0x2e3b, 0x33d6,
	0x3b88, 0x424b, 0x4731, 0x4b8a, 0x52e9, 0x53e0, 0x5a2e, 0x616b,
	0x6da3, 0x7152, 0x7996, 0x3112, 0x33d7, 0x346a, 0x3bff, 0x4388,
	0x4a39, 0x5dac, 0x7700, 0x36da, 0x33ce, 0x3468,
	/* 0x13D21..0x13D7E */
	0x3b97, 0x3c31, 0x3dde, 0x2fee, 0x4101, 0x42fe, 0x4d32, 0x59c0,
	0x59cb, 0x5d42, 0x5e4d, 0x5fd2, 0x61ed, 0x621f, 0x6490, 0x6846,
	0x6972, 0x6b90, 0x6e74, 0x6f2f, 0x7031, 0x714b, 0x716c, 0x76c6,
	0x719c, 0x2ec0, 0x2f4f, 0x3145, 0x3341, 0x3f93, 0x420e, 0x47d4,
	0x4c41, 0x4e0b, 0x5363, 0x5e26, 0x71cd, 0x7283, 0x33d4, 0x3919,
	0x3bbf, 0x4dd1, 0x595d, 0x5e2e, 0x5c9b, 0x387e, 0x519f, 0x31fa,
	0x6853, 0x6ff0, 0x2fca, 0x3cfb, 0x4625, 0x57ac, 0x5ae3, 0x621c,
	0x79ff, 0x31c6, 0x3faa, 0x45ec, 0x496f, 0x4b89, 0x4df3, 0x4e96,
	0x4f64, 0x56fe, 0x5d14, 0x3de1, 0x7075, 0x7187, 0x7806, 0x31e6,
	0x321d, 0x4240, 0x4691, 0x46d9, 0x4e1a, 0x3eb6, 0x5dd2, 0x5f72,
	0x46f8, 0x65af, 0x65f7, 0x6af8, 0x32a9, 0x33d9, 0x3973, 0x3e8f,
	0x3f90, 0x4055, 0x72e4, 0x7664, 0x30b7, 0x311f,
	/* 0x13E21..0x13E7E */
	0x32dd, 0x3320, 0x3347, 0x33ec, 0x34e8, 0x3546, 0x3531, 0x3617,
	0x3968, 0x39be, 0x3a3c, 0x3bb5, 0x3c06, 0x3c0f, 0x3c11, 0x3c1a,
	0x3e84, 0x3e8a, 0x3ee0, 0x3f70, 0x427f, 0x4284, 0x42db, 0x438c,
	0x4377, 0x4607, 0x460c, 0x462d, 0x4676, 0x477e, 0x48a2, 0x4a1f,
	0x4a35, 0x4cbc, 0x4d88, 0x4e09, 0x4e58, 0x513c, 0x5126, 0x5167,
	0x55c7, 0x5701, 0x585d, 0x5901, 0x5965, 0x59f0, 0x5ae0, 0x5b11,
	0x5ca7, 0x5d39, 0x6096, 0x63d6, 0x648b, 0x6549, 0x685d, 0x68f3,
	0x6a1f, 0x6a3c, 0x6a54, 0x6a73, 0x6c61, 0x6cde, 0x71a4, 0x7266,
	0x737e, 0x7418, 0x769c, 0x7798, 0x2e0a, 0x2e08, 0x2e1e, 0x2e57,
	0x3197, 0x3270, 0x37ce, 0x3834, 0x38cc, 0x3b22, 0x3e38, 0x40c5,
	0x44fe, 0x4761, 0x4756, 0x4d44, 0x52b6, 0x5573, 0x5a63, 0x64b8,
	0x6b72, 0x71b8, 0x7320, 0x3631, 0x37f4, 0x78fe,
	/* 0x13F21..0x13F7E */
	0x42ed, 0x490d, 0x4b96, 0x51ed, 0x5e54, 0x6077, 0x6272, 0x69e6,
	0x78df, 0x6755, 0x6fb1, 0x3c3b, 0x2f38, 0x2fe1, 0x2fb5, 0x3507,
	0x3a20, 0x3bdd, 0x3be9, 0x3fc3, 0x414e, 0x432f, 0x45b0, 0x464b,
	0x48ee, 0x499b, 0x4d78, 0x4df1, 0x5533, 0x55b9, 0x571f, 0x595e,
	0x59e6, 0x5d33, 0x61e3, 0x62af, 0x65aa, 0x69aa, 0x6a3a, 0x6eab,
	0x6f9b, 0x7032, 0x71dd, 0x7707, 0x2eba, 0x2ec1, 0x3203, 0x3875,
	0x38ec, 0x3c0b, 0x551a, 0x3c3d, 0x614e, 0x6a0a, 0x6fc5, 0x7663,
	0x776d, 0x5b25, 0x6acf, 0x7808, 0x7162, 0x36f3, 0x33a8, 0x7017,
	0x3439, 0x3782, 0x3e25, 0x43a8, 0x4c34, 0x508a, 0x5761, 0x5c8b,
	0x5fe0, 0x6870, 0x7042, 0x7154, 0x7310, 0x7318, 0x768f, 0x545e,
	0x7ac4, 0x3d07, 0x3d69, 0x4570, 0x47a2, 0x6da8, 0x76db, 0x436e,
	0x4749, 0x4919, 0x63c5, 0x7817, 0x76c0, 0x68fe,
	/* 0x14021..0x1407E */
	0x4f84, 0x447a, 0x3bf8, 0x2e16, 0x502c, 0x555d, 0x462f, 0x31c4,
	0x3236, 0x32e2, 0x39d3, 0x3f81, 0x4027, 0x4210, 0x453f, 0x4574,
	0x461f, 0x4674, 0x48f2, 0x4816, 0x4b63, 0x4e05, 0x5272, 0x551f,
	0x56db, 0x5cbe, 0x6056, 0x38f0, 0x68fd, 0x697f, 0x6aa0, 0x6a93,
	0x6acb, 0x701d, 0x7192, 0x7752, 0x7759, 0x4589, 0x5a0e, 0x6106,
	0x76bb, 0x3e2d, 0x40dc, 0x421a, 0x45a5, 0x4614, 0x4790, 0x57f3,
	0x5a4d, 0x5c4d, 0x5e3e, 0x610a, 0x6cac, 0x6d64, 0x6de1, 0x6e5f,
	0x58a9, 0x3207, 0x42d9, 0x43a5, 0x4442, 0x4298, 0x6a2d, 0x5a83,
	0x5bc0, 0x6aac, 0x76ea, 0x5d76, 0x620c, 0x6749, 0x2ed9, 0x3148,
	0x3343, 0x3360, 0x3ba3, 0x3c02, 0x3c16, 0x3ddd, 0x4226, 0x4247,
	0x44b0, 0x4813, 0x4834, 0x4cc9, 0x4d45, 0x4d17, 0x47d3, 0x4f5c,
	0x514e, 0x517d, 0x45cb, 0x5a7f, 0x5bad, 0x5dda,
	/* 0x14121..0x1417E */
	0x5e4a, 0x5fa8, 0x617a, 0x621b, 0x6239, 0x65a6, 0x6a6e, 0x6cce,
	0x6df5, 0x7078, 0x7077, 0x72ad, 0x7291, 0x7583, 0x7bae, 0x324d,
	0x3584, 0x4f38, 0x5136, 0x3168, 0x5985, 0x5e55, 0x61b3, 0x5cce,
	0x364c, 0x3851, 0x3ca8, 0x43aa, 0x46fe, 0x46fd, 0x495a, 0x52d9,
	0x558f, 0x558e, 0x590e, 0x5956, 0x59df, 0x5c97, 0x5d20, 0x5d44,
	0x6607, 0x6a34, 0x763b, 0x7061, 0x7f20, 0x30e7, 0x3275, 0x33cc,
	0x33e2, 0x3009, 0x35aa, 0x38ee, 0x394f, 0x523d, 0x3b8b, 0x3c64,
	0x331d, 0x40e3, 0x40f3, 0x435c, 0x4383, 0x433f, 0x43bb, 0x44cd,
	0x45e9, 0x46f9, 0x3de3, 0x49cd, 0x49fd, 0x4f15, 0x51e5, 0x2e89,
	0x55e9, 0x56f8, 0x5a93, 0x5cdf, 0x5dcf, 0x5d9c, 0x6061, 0x6349,
	0x6358, 0x646c, 0x64bc, 0x65fb, 0x68c5, 0x6d70, 0x7001, 0x706d,
	0x7397, 0x771c, 0x7a12, 0x30cf, 0x3897, 0x418e,
	/* 0x14221..0x1427E */
	0x61d3, 0x6535, 0x6d08, 0x7020, 0x2fc3, 0x3074, 0x3247, 0x3373,
	0x406f, 0x4349, 0x475f, 0x4e2c, 0x6db3, 0x701f, 0x2fd7, 0x3c5e,
	0x6cca, 0x45cf, 0x5d9a, 0x3352, 0x6896, 0x3176, 0x43c3, 0x3b58,
	0x3b6b, 0x3c0a, 0x440d, 0x4751, 0x705c, 0x2ed6, 0x391a, 0x392a,
	0x4c70, 0x6a51, 0x353e, 0x3815, 0x39a5, 0x40f0, 0x4253, 0x47c1,
	0x6235, 0x4955, 0x7640, 0x79c4, 0x7a28, 0x2f53, 0x3806, 0x3bfe,
	0x6010, 0x3cb1, 0x3e2f, 0x3f85, 0x4020, 0x414b, 0x4234, 0x46ff,
	0x4cf0, 0x4ede, 0x60ce, 0x617f, 0x62d4, 0x688b, 0x6cb8, 0x7000,
	0x702e, 0x768a, 0x7edb, 0x7bdb, 0x2ee3, 0x33f0, 0x3927, 0x5b2c,
	0x718d, 0x784c, 0x7df9, 0x4edd, 0x5027, 0x3353, 0x3544, 0x3b85,
	0x4258, 0x429e, 0x42d3, 0x4ca2, 0x4fef, 0x5422, 0x6a17, 0x7438,
	0x4fc1, 0x6afe, 0x6338, 0x31e7, 0x66f8, 0x33ea,
	/* 0x14321..0x1437E */
	0x33e9, 0x2f46, 0x7054, 0x6fb0, 0x396a, 0x6131, 0x3dfd, 0x5aea,
	0x6fbf, 0x48da, 0x6c37, 0x52f8, 0x7c48, 0x4a3d, 0x6ab0, 0x2e39,
	0x3358, 0x3606, 0x3766, 0x42c5, 0x43a2, 0x45e6, 0x4b4e, 0x4de1,
	0x4e5b, 0x50ad, 0x57ed, 0x5aef, 0x5baa, 0x5dbb, 0x603d, 0x60c6,
	0x66cb, 0x6a95, 0x735b, 0x36e3, 0x38c7, 0x3f3e, 0x45ad, 0x4696,
	0x4a80, 0x4bb5, 0x5537, 0x6ac7, 0x3024, 0x57e5, 0x3730, 0x3f1b,
	0x4065, 0x467a, 0x4c60, 0x55f4, 0x5a1a, 0x5f6e, 0x61f4, 0x6718,
	0x7045, 0x79b3, 0x5bc9, 0x555c, 0x5af9, 0x5b51, 0x64c4, 0x7010,
	0x59e9, 0x5a92, 0x6336, 0x3ae1, 0x5740, 0x2e2d, 0x2ef2, 0x3b99,
	0x3fe0, 0x42bd, 0x463c, 0x47f1, 0x4ce8, 0x666b, 0x6877, 0x6a3b,
	0x714e, 0x72f3, 0x79d0, 0x4a17, 0x5026, 0x532a, 0x62e7, 0x6457,
	0x6caf, 0x2e01, 0x3146, 0x31cb, 0x358b, 0x3bf5,
	/* 0x14421..0x1447E */
	0x3e16, 0x3e33, 0x3e81, 0x3f14, 0x3f35, 0x3f6b, 0x3fb4, 0x41f2,
	0x4311, 0x46a2, 0x471d, 0x4f6e, 0x5252, 0x553a, 0x573a, 0x6074,
	0x6139, 0x6178, 0x6776, 0x6abf, 0x6adc, 0x6d85, 0x6df3, 0x729a,
	0x7577, 0x7802, 0x7ce5, 0x32c5, 0x4357, 0x56f4, 0x4715, 0x4c88,
	0x53cd, 0x6cc3, 0x73ae, 0x7673, 0x4d25, 0x389c, 0x490e, 0x49cc,
	0x6ffd, 0x739a, 0x55db, 0x701a, 0x385a, 0x4802, 0x43b4, 0x49fb,
	0x2f43, 0x4f2c, 0x47d8, 0x6fbb, 0x6526, 0x5db4, 0x7354, 0x493f,
	0x4f70, 0x376a, 0x38f7, 0x3b2c, 0x5d2c, 0x522a, 0x340a, 0x71e3,
	0x7db4, 0x2ead, 0x2f4e, 0x305c, 0x3075, 0x3243, 0x6c9e, 0x3448,
	0x3824, 0x3b9a, 0x3e1d, 0x3e95, 0x3ead, 0x3ef7, 0x3f1f, 0x408c,
	0x42b5, 0x433a, 0x43d0, 0x48af, 0x4c40, 0x5887, 0x598e, 0x5a0b,
	0x5de0, 0x6247, 0x6a02, 0x6ae6, 0x6e44, 0x7013,
	/* 0x14521..0x1457E */
	0x70b8, 0x712d, 0x71d8, 0x7f0e, 0x4ce5, 0x4458, 0x44e2, 0x4575,
	0x4ef4, 0x5684, 0x5b1b, 0x7069, 0x73d1, 0x4eba, 0x34f2, 0x3fb9,
	0x44a4, 0x6f4d, 0x6fed, 0x7244, 0x3178, 0x386b, 0x3929, 0x3c55,
	0x3e97, 0x4dfb, 0x5e8f, 0x551c, 0x6cbc, 0x6ee2, 0x785b, 0x50b9,
	0x2f1d, 0x4bbf, 0x4fb1, 0x5530, 0x76fb, 0x314e, 0x3410, 0x3835,
	0x3857, 0x39ac, 0x3c60, 0x3f92, 0x4597, 0x475c, 0x4e21, 0x567b,
	0x63df, 0x6ced, 0x7014, 0x70fd, 0x734d, 0x5825, 0x583a, 0x32aa,
	0x3ea6, 0x371f, 0x3974, 0x4012, 0x3012, 0x315a, 0x31ac, 0x31cd,
	0x3200, 0x3510, 0x3854, 0x3858, 0x3957, 0x3b95, 0x3cf6, 0x3d8b,
	0x40bc, 0x4295, 0x442d, 0x4771, 0x4843, 0x48bc, 0x48df, 0x56d7,
	0x4dd8, 0x4e6f, 0x4d9b, 0x506f, 0x51c8, 0x3f53, 0x55d8, 0x5977,
	0x5b49, 0x5b54, 0x5b52, 0x5cd6, 0x5d71, 0x3230,
	/* 0x14621..0x1467E */
	0x6463, 0x6569, 0x65e4, 0x6a0e, 0x6b04, 0x6c46, 0x6e0f, 0x7003,
	0x700f, 0x7419, 0x7676, 0x782d, 0x7a30, 0x75d8, 0x30cd, 0x32d5,
	0x340c, 0x3802, 0x3c0e, 0x41a7, 0x449e, 0x4d1e, 0x57b3, 0x5ae5,
	0x60f4, 0x6404, 0x7053, 0x7285, 0x3ce0, 0x7d07, 0x333f, 0x3f97,
	0x3fb3, 0x4d9c, 0x5279, 0x5763, 0x59bf, 0x5be4, 0x4bd2, 0x52ec,
	0x6aad, 0x4803, 0x4a61, 0x31f8, 0x5a81, 0x4934, 0x3c4a, 0x7cf6,
	0x62eb, 0x3bc5, 0x7149, 0x501e, 0x3678, 0x3c6f, 0x40c7, 0x4566,
	0x4c8c, 0x6c5a, 0x7041, 0x7813, 0x3451, 0x46c7, 0x720d, 0x3948,
	0x70a3, 0x3185, 0x2e4d, 0x31ea, 0x6599, 0x6b0e, 0x5058, 0x437a,
	0x734b, 0x4962, 0x79b4, 0x5e04, 0x5577, 0x3357, 0x4960, 0x6edf,
	0x76e3, 0x4c5d, 0x2e8c, 0x3c3c, 0x3f10, 0x6fe9, 0x3302, 0x6cd1,
	0x6089, 0x6679, 0x3eff, 0x45e5, 0x2e73, 0x3165,
	/* 0x14721..0x1477E */
	0x3982, 0x3c3f, 0x77ee, 0x2efb, 0x398a, 0x3fcd, 0x6a8d, 0x4fe1,
	0x59b0, 0x5962, 0x3be7, 0x6471, 0x532b, 0x51b1, 0x3e74, 0x3ff5,
	0x437b, 0x449a, 0x51c3, 0x5c98, 0x2e43, 0x3efc, 0x2e4b, 0x37dc,
	0x36a2, 0x40a9, 0x4fc3, 0x5d0d, 0x60fd, 0x6133, 0x61bf, 0x6fb2,
	0x6997, 0x66a4, 0x3df4, 0x428a, 0x44ad, 0x6987, 0x4777, 0x4ce2,
	0x4d3e, 0x5436, 0x5834, 0x3a46, 0x5f75, 0x62ad, 0x79ac, 0x2ff3,
	0x3ec3, 0x42dd, 0x4392, 0x4557, 0x476f, 0x56c3, 0x524c, 0x60cc,
	0x60ba, 0x6f29, 0x714d, 0x300d, 0x37f9, 0x3a92, 0x4885, 0x4973,
	0x5164, 0x52fd, 0x6cb7, 0x38f2, 0x6ce0, 0x766a, 0x7019, 0x677f,
	0x59e4, 0x57e7, 0x6429, 0x2f2f, 0x3265, 0x335a, 0x42cd, 0x47cf,
	0x4cca, 0x567d, 0x5b94, 0x5c95, 0x6236, 0x6584, 0x6feb, 0x46dd,
	0x4f20, 0x5206, 0x5e1b, 0x63ab, 0x79c1, 0x7ea6,
	/* 0x14821..0x1487E */
	0x31fd, 0x5bb1, 0x5872, 0x5bb8, 0x6087, 0x5b48, 0x4ae8, 0x3e61,
	0x608c, 0x5551, 0x5560, 0x316b, 0x7262, 0x4e8c, 0x567a, 0x7197,
	0x7aea, 0x2f10, 0x5f70, 0x429c, 0x5b4f, 0x75a5, 0x7ce9, 0x367a,
	0x3859, 0x66e4, 0x76bc, 0x2f34, 0x3224, 0x334a, 0x33cd, 0x33db,
	0x3e06, 0x442c, 0x4591, 0x477f, 0x4c3e, 0x4c4e, 0x5248, 0x52af,
	0x53ed, 0x5554, 0x5e41, 0x622c, 0x65e9, 0x6ca9, 0x5bc4, 0x71c6,
	0x5169, 0x7812, 0x78ef, 0x433d, 0x4669, 0x556a, 0x56e4, 0x58d0,
	0x6543, 0x66ee, 0x332a, 0x3351, 0x3426, 0x3983, 0x3e87, 0x3f7c,
	0x40b2, 0x4249, 0x4279, 0x42ab, 0x4590, 0x4bd4, 0x4ccc, 0x55b2,
	0x56ae, 0x5891, 0x59d8, 0x5dcb, 0x5f77, 0x60a5, 0x68ab, 0x6ab9,
	0x6cbb, 0x707f, 0x775e, 0x78db, 0x4a0b, 0x5c38, 0x3099, 0x3c3e,
	0x3fae, 0x4787, 0x4bd8, 0x5435, 0x5709, 0x5f8e,
	/* 0x14921..0x1497E */
	0x7f3b, 0x47ca, 0x5a17, 0x3339, 0x558b, 0x7aed, 0x3f66, 0x619d,
	0x63f1, 0x6098, 0x3f3c, 0x3fc5, 0x5562, 0x5b46, 0x703c, 0x4867,
	0x39eb, 0x3a9b, 0x5d10, 0x567e, 0x6b2c, 0x2ff5, 0x3f6a, 0x4a19,
	0x4c37, 0x4f02, 0x54e2, 0x5968, 0x6868, 0x6a55, 0x6c79, 0x3edf,
	0x43cf, 0x55c5, 0x59d2, 0x62d7, 0x7328, 0x72f2, 0x649c, 0x66ed,
	0x7c2d, 0x34c1, 0x3f6c, 0x458c, 0x4d5c, 0x5015, 0x6ca7, 0x6cd3,
	0x783b, 0x454f, 0x54f6, 0x2e0d, 0x2ed8, 0x37e0, 0x392b, 0x3a66,
	0x3bcc, 0x31a8, 0x3e03, 0x3e9c, 0x4016, 0x4276, 0x4577, 0x45a7,
	0x466e, 0x4d6e, 0x5236, 0x5b26, 0x6150, 0x619a, 0x6299, 0x6b5c,
	0x6ca0, 0x6ce6, 0x6d74, 0x761c, 0x7644, 0x2fae, 0x44ab, 0x4b66,
	0x621e, 0x6461, 0x656a, 0x70e8, 0x3c01, 0x4953, 0x78a8, 0x647a,
	0x6557, 0x2f0f, 0x326f, 0x3fa9, 0x3e45, 0x470d,
	/* 0x14A21..0x14A7E */
	0x598f, 0x6179, 0x6907, 0x6986, 0x4df5, 0x3f17, 0x4255, 0x4cb8,
	0x2ecf, 0x5269, 0x7b92, 0x3206, 0x343b, 0x3674, 0x38b3, 0x41a4,
	0x426e, 0x511a, 0x396e, 0x5c89, 0x5cde, 0x5d1b, 0x76f0, 0x4587,
	0x605e, 0x2e19, 0x2f75, 0x3175, 0x3840, 0x3e63, 0x3e73, 0x3f0a,
	0x47c4, 0x2e26, 0x653d, 0x7589, 0x765b, 0x5c73, 0x7801, 0x30fb,
	0x38c1, 0x5656, 0x58a7, 0x3225, 0x57a5, 0x6511, 0x5b86, 0x304f,
	0x3909, 0x5247, 0x5bc7, 0x5de8, 0x6fba, 0x6fd4, 0x704d, 0x2fbf,
	0x32c9, 0x3a29, 0x3f01, 0x77ad, 0x2fdd, 0x6217, 0x72ea, 0x3703,
	0x4355, 0x4b69, 0x552b, 0x68dc, 0x6f14, 0x5a42, 0x32df, 0x3893,
	0x4155, 0x420a, 0x46ae, 0x4bcd, 0x5c3f, 0x63e9, 0x3023, 0x2ff8,
	0x3305, 0x3446, 0x3831, 0x3949, 0x3b9d, 0x3cf0, 0x3cef, 0x3d29,
	0x3e96, 0x42b1, 0x4367, 0x453e, 0x45b9, 0x470b,
	/* 0x14B21..0x14B7E */
	0x4cd5, 0x4ce1, 0x50f9, 0x5832, 0x5e2b, 0x60de, 0x62b3, 0x640c,
	0x64ec, 0x6702, 0x6912, 0x6a2a, 0x6c4a, 0x70a6, 0x72d2, 0x78fd,
	0x7cf3, 0x7d6c, 0x2e4f, 0x2ea1, 0x308d, 0x3256, 0x374a, 0x39a8,
	0x3e3d, 0x3fd8, 0x3fd9, 0x423f, 0x46b4, 0x471b, 0x47d0, 0x48d2,
	0x3192, 0x5d21, 0x60aa, 0x61a8, 0x6b00, 0x6c8c, 0x6cbf, 0x727e,
	0x7632, 0x3420, 0x782c, 0x3317, 0x30d5, 0x335c, 0x38a8, 0x44b2,
	0x4734, 0x5267, 0x5766, 0x5a46, 0x71e6, 0x32c3, 0x4ca1, 0x4b86,
	0x3800, 0x3e4c, 0x3954, 0x472c, 0x5ffb, 0x31e1, 0x56c6, 0x4469,
	0x58e8, 0x7b54, 0x7ebb, 0x37cb, 0x39b9, 0x4627, 0x479a, 0x4bce,
	0x34e9, 0x49d9, 0x3e55, 0x619c, 0x4795, 0x7baa, 0x47fe, 0x7c52,
	0x485d, 0x2ea6, 0x2fe3, 0x33c8, 0x42b9, 0x472b, 0x4cab, 0x6fc4,
	0x2fad, 0x5e6d, 0x7ebf, 0x2e07, 0x4162, 0x4e80,
	/* 0x14C21..0x14C7E */
	0x4f2b, 0x6513, 0x3473, 0x472a, 0x7b45, 0x3df3, 0x5b95, 0x3cac,
	0x3bc6, 0x671c, 0x4e4a, 0x64d1, 0x5a14, 0x6108, 0x3999, 0x5c8d,
	0x4c11, 0x5720, 0x32d9, 0x3922, 0x5121, 0x525f, 0x57db, 0x7727,
	0x7d61, 0x490b, 0x3a7f, 0x3a18, 0x31a5, 0x340d, 0x347d, 0x460e,
	0x56df, 0x6ff7, 0x7298, 0x7cf4, 0x39ea, 0x525d, 0x4ec5, 0x314d,
	0x48c9, 0x5dbf, 0x5dec, 0x7762, 0x7eba, 0x4478, 0x4a21, 0x6302,
	0x3984, 0x3b5f, 0x4bdb, 0x531b, 0x56f2, 0x5db2, 0x6017, 0x6499,
	0x3132, 0x4728, 0x7ed9, 0x56ee, 0x4762, 0x32ff, 0x7905, 0x3c24,
	0x423b, 0x5c7e, 0x6cb0, 0x354f, 0x40b6, 0x5d0b, 0x7580, 0x3301,
	0x2e5f, 0x31b6, 0x391c, 0x523a, 0x6036, 0x71ce, 0x3f25, 0x57e2,
	0x3384, 0x3f79, 0x5d04, 0x65ac, 0x6a33, 0x6e8d, 0x7756, 0x47f3,
	0x65ae, 0x7453, 0x4109, 0x4108, 0x4cb9, 0x5652,
	/* 0x14D21..0x14D7E */
	0x6aed, 0x6f38, 0x352f, 0x2f51, 0x312a, 0x32c7, 0x33cb, 0x3ba5,
	0x3e7d, 0x40a0, 0x4182, 0x43d6, 0x4709, 0x47da, 0x4e67, 0x4d8c,
	0x5336, 0x5337, 0x5531, 0x5950, 0x68d5, 0x6a98, 0x704a, 0x7091,
	0x70f5, 0x76c4, 0x678d, 0x3915, 0x2e88, 0x2f59, 0x2e0e, 0x6a89,
	0x6f3f, 0x7810, 0x30ad, 0x3e7c, 0x3996, 0x3bb9, 0x3eb8, 0x43da,
	0x43fa, 0x44c1, 0x46dc, 0x494a, 0x49d8, 0x4d0b, 0x4eb6, 0x5194,
	0x5528, 0x5aaf, 0x5f8a, 0x6000, 0x6449, 0x64c9, 0x6981, 0x6b21,
	0x6e0a, 0x7065, 0x767d, 0x790a, 0x417e, 0x4291, 0x4b32, 0x4c83,
	0x4d74, 0x5fcc, 0x5ffc, 0x4dc0, 0x5f85, 0x67ba, 0x68f8, 0x4765,
	0x63b1, 0x783c, 0x76f7, 0x4d1b, 0x5d61, 0x643d, 0x716a, 0x2e71,
	0x3375, 0x3d50, 0x4b04, 0x4feb, 0x65cd, 0x662d, 0x69a7, 0x3229,
	0x340f, 0x3c65, 0x474e, 0x48a8, 0x5406, 0x5483,
	/* 0x14E21..0x14E7E */
	0x55e2, 0x68cf, 0x68e1, 0x71cc, 0x76e2, 0x7678, 0x3f8b, 0x5387,
	0x5acb, 0x644e, 0x43a0, 0x5565, 0x3289, 0x4d41, 0x4e9c, 0x5409,
	0x5559, 0x586b, 0x5c92, 0x7686, 0x5adc, 0x7f8d, 0x2fb6, 0x416e,
	0x45c5, 0x665c, 0x2e86, 0x2eae, 0x30da, 0x2e21, 0x31cc, 0x3bee,
	0x4599, 0x4881, 0x4dbc, 0x531f, 0x5642, 0x57ad, 0x5a1c, 0x5ce7,
	0x626f, 0x6ad2, 0x707c, 0x71cf, 0x7675, 0x7818, 0x329b, 0x5dd1,
	0x302b, 0x3398, 0x4797, 0x4dcb, 0x51d0, 0x5433, 0x61e8, 0x6f2a,
	0x76a3, 0x7c57, 0x7e9f, 0x5460, 0x3841, 0x4d99, 0x5d2f, 0x785e,
	0x2ee4, 0x2f36, 0x2f8b, 0x31b7, 0x32b1, 0x3dba, 0x401c, 0x53b2,
	0x593c, 0x62d3, 0x7234, 0x76b7, 0x76f6, 0x770a, 0x7e97, 0x7f62,
	0x46a6, 0x4b74, 0x3217, 0x32a3, 0x50c8, 0x68c2, 0x3ec9, 0x404b,
	0x4190, 0x4f23, 0x5149, 0x5c3e, 0x5df4, 0x606f,
	/* 0x14F21..0x14F7E */
	0x64ee, 0x7023, 0x732c, 0x3442, 0x7b6f, 0x4ad3, 0x5089, 0x6cc2,
	0x6def, 0x7732, 0x32b4, 0x3a41, 0x3eca, 0x3f04, 0x4717, 0x497c,
	0x4994, 0x4d6a, 0x4f0f, 0x5262, 0x52fc, 0x5bed, 0x6001, 0x607e,
	0x674b, 0x70ce, 0x316d, 0x7e93, 0x5984, 0x608b, 0x7332, 0x6ad6,
	0x302d, 0x348c, 0x6a71, 0x4b6a, 0x6cc4, 0x6107, 0x40d1, 0x47a0,
	0x7df2, 0x2e99, 0x2e98, 0x7c10, 0x6a6b, 0x65c1, 0x6568, 0x4900,
	0x4e7e, 0x5897, 0x6155, 0x8e9f, 0x3b41, 0x3b56, 0x3b7d, 0x3b93,
	0x3bd8, 0x3bec, 0x3c12, 0x3c1e, 0x3c23, 0x3c2b, 0x178d, 0x3c62,
	0x813b, 0x813c, 0x96b4, 0x3c7a, 0x3c8f, 0x3c9f, 0x3ca3, 0x3caa,
	0x3cba, 0x3ccb, 0x3cd0, 0x3cd2, 0x3cf4, 0x9c34, 0x17e2, 0x3d0d,
	0x3d27, 0x8111, 0x3d46, 0x3d47, 0x3d53, 0x3d4a, 0x3d6d, 0x3d81,
	0x3da0, 0x3da4, 0x3da7, 0x3db8, 0x3dcb, 0x341e,
	/* 0x15021..0x1507E */
	0x3f0c, 0x2e10, 0x2e15, 0x2e2a, 0x2e31, 0x2e36, 0x2e3c, 0x2e3f,
	0x2e42, 0x2e56, 0x2e58, 0x2e82, 0x2e85, 0x6c6b, 0x2e8a, 0x6212,
	0x3f0d, 0x2e8e, 0x2e9e, 0x2e9f, 0x2ea0, 0x2ea2, 0x2eb0, 0x2eb3,
	0x2eb6, 0x2ece, 0x2ecd, 0x2ec4, 0x2ec6, 0x2ec2, 0x2ed7, 0x2ede,
	0x2eed, 0x2edf, 0x2ef7, 0x2f09, 0x2f5a, 0x2f30, 0x2f5b, 0x2f5d,
	0x2f57, 0x2f47, 0x2f76, 0x2f88, 0x2f8f, 0x2f98, 0x2f7b, 0x2f69,
	0x2f70, 0x2f91, 0x2f6f, 0x2f86, 0x2f96, 0x3118, 0x2fd4, 0x2fdf,
	0x2fce, 0x2fd8, 0x2fdb, 0x2fd1, 0x2fda, 0x2fd0, 0x2fe4, 0x2fe5,
	0x301a, 0x3028, 0x3014, 0x302a, 0x3025, 0x3005, 0x2f1c, 0x2ff6,
	0x3021, 0x3029, 0x302c, 0x2ffe, 0x2fef, 0x3011, 0x3006, 0x3043,
	0x3047, 0x4703, 0x3055, 0x3050, 0x3048, 0x305a, 0x3056, 0x306c,
	0x3078, 0x3080, 0x309a, 0x3085, 0x30b4, 0x30b2,
	/* 0x15121..0x1517E */
	0x30c9, 0x30ca, 0x30b3, 0x30c2, 0x30d6, 0x30de, 0x30e5, 0x30ed,
	0x30e3, 0x30ee, 0x30f9, 0x30f5, 0x3109, 0x3101, 0x3102, 0x3116,
	0x3115, 0x3114, 0x311a, 0x3121, 0x313a, 0x3137, 0x313c, 0x313b,
	0x313f, 0x3140, 0x3152, 0x314c, 0x3154, 0x3162, 0x5af8, 0x3169,
	0x316a, 0x316e, 0x3180, 0x3182, 0x36d8, 0x318c, 0x3189, 0x318f,
	0x3191, 0x3193, 0x3195, 0x3196, 0x31a4, 0x31a6, 0x31a2, 0x31a9,
	0x31aa, 0x31ab, 0x31b3, 0x31b1, 0x31b2, 0x31b0, 0x31b5, 0x31bd,
	0x31c5, 0x31c9, 0x31db, 0x31e0, 0x6655, 0x31e9, 0x31ed, 0x31f0,
	0x31f5, 0x31fe, 0x3204, 0x320b, 0x3214, 0x320e, 0x3227, 0x322a,
	0x322e, 0x3233, 0x3239, 0x324f, 0x3244, 0x324b, 0x324c, 0x325e,
	0x3254, 0x326a, 0x3274, 0x3269, 0x3273, 0x327f, 0x327d, 0x328d,
	0x3294, 0x3292, 0x3271, 0x3288, 0x3291, 0x6fa8,
	/* 0x15221..0x1527E */
	0x6fa7, 0x32ac, 0x32ad, 0x32bc, 0x32b5, 0x32c1, 0x32cd, 0x32d7,
	0x32de, 0x32e3, 0x32e6, 0x78ed, 0x32e0, 0x32f3, 0x32f5, 0x32f8,
	0x32f9, 0x3306, 0x3308, 0x5538, 0x330d, 0x3310, 0x330f, 0x3315,
	0x331a, 0x3323, 0x332f, 0x3331, 0x3333, 0x3338, 0x3340, 0x3346,
	0x3345, 0x2e17, 0x3349, 0x334d, 0x31d6, 0x335e, 0x3369, 0x336e,
	0x3918, 0x337b, 0x3377, 0x3382, 0x3396, 0x33a0, 0x33a6, 0x33a5,
	0x33ae, 0x33b0, 0x33b6, 0x33c3, 0x5c12, 0x76d9, 0x33df, 0x46fc,
	0x51ee, 0x33ee, 0x33e8, 0x33ed, 0x33fa, 0x3401, 0x343d, 0x3440,
	0x342c, 0x342d, 0x343c, 0x342e, 0x3436, 0x3429, 0x341d, 0x344e,
	0x348f, 0x3475, 0x348e, 0x345f, 0x3471, 0x3477, 0x3470, 0x3492,
	0x347b, 0x3480, 0x3476, 0x3484, 0x3490, 0x3486, 0x34c7, 0x34a2,
	0x34b8, 0x34a5, 0x34ac, 0x34c4, 0x34c8, 0x34a8,
	/* 0x15321..0x1537E */
	0x34ab, 0x34c2, 0x34a4, 0x34be, 0x34bc, 0x34d8, 0x34e5, 0x34e6,
	0x350f, 0x3514, 0x34fd, 0x34ee, 0x34ed, 0x34fa, 0x34e2, 0x3539,
	0x3540, 0x3563, 0x354c, 0x352e, 0x355c, 0x3545, 0x3556, 0x3557,
	0x3538, 0x3533, 0x355d, 0x3599, 0x3580, 0x34af, 0x358a, 0x359f,
	0x357b, 0x357e, 0x3598, 0x359e, 0x35ae, 0x357c, 0x3583, 0x35a9,
	0x3587, 0x35a8, 0x35da, 0x35c5, 0x35df, 0x35c4, 0x35dc, 0x35e4,
	0x35d4, 0x3614, 0x35f7, 0x3616, 0x35fe, 0x35fd, 0x361b, 0x35f9,
	0x364e, 0x3650, 0x51df, 0x3634, 0x3636, 0x3632, 0x3638, 0x366b,
	0x3664, 0x362f, 0x366c, 0x366a, 0x3686, 0x3680, 0x368a, 0x36a0,
	0x3694, 0x368f, 0x36a5, 0x36ae, 0x36b6, 0x36b4, 0x36c2, 0x36bc,
	0x36c1, 0x36c3, 0x36c0, 0x36c8, 0x36ce, 0x36d1, 0x36d3, 0x36d7,
	0x36ee, 0x36f9, 0x3700, 0x36ff, 0x3704, 0x3709,
	/* 0x15421..0x1547E */
	0x3708, 0x370b, 0x370d, 0x3713, 0x3718, 0x3716, 0x35c7, 0x371c,
	0x3726, 0x3737, 0x3738, 0x374e, 0x373b, 0x3740, 0x374f, 0x3769,
	0x37c0, 0x3788, 0x3761, 0x377f, 0x3789, 0x3793, 0x37a0, 0x37b3,
	0x37a4, 0x37aa, 0x37b0, 0x37c3, 0x37c6, 0x37d4, 0x37d2, 0x37d3,
	0x380a, 0x37d6, 0x37e3, 0x380b, 0x3819, 0x381d, 0x3872, 0x3821,
	0x3862, 0x384b, 0x3870, 0x4bc0, 0x3852, 0x383d, 0x3879, 0x3885,
	0x38b9, 0x389f, 0x38ab, 0x38ba, 0x38de, 0x38bb, 0x38b8, 0x38ae,
	0x38c5, 0x38d3, 0x38d1, 0x38d7, 0x38d9, 0x38d8, 0x38e5, 0x38dc,
	0x38e4, 0x38df, 0x38ef, 0x38fa, 0x38f9, 0x38fb, 0x38fc, 0x38fd,
	0x3902, 0x390a, 0x3910, 0x391b, 0x48a6, 0x3925, 0x392c, 0x392d,
	0x3932, 0x3938, 0x393e, 0x5ad2, 0x3955, 0x3950, 0x394e, 0x395a,
	0x3958, 0x3962, 0x3960, 0x3967, 0x396c, 0x3969,
	/* 0x15521..0x1557E */
	0x3978, 0x3981, 0x399d, 0x2f5e, 0x2fab, 0x39a3, 0x39b2, 0x39c6,
	0x39e8, 0x39dc, 0x398d, 0x39d9, 0x39da, 0x3a25, 0x3a1f, 0x3a11,
	0x3a1c, 0x3a09, 0x3a1a, 0x3a40, 0x3a6c, 0x3a49, 0x3a35, 0x3a36,
	0x3a62, 0x3a6a, 0x3a9a, 0x3abc, 0x3abe, 0x3acb, 0x3ac2, 0x3abd,
	0x3ae3, 0x3ad7, 0x3ae6, 0x3ae9, 0x3ad6, 0x3afa, 0x3afb, 0x3b0c,
	0x3b0b, 0x3b16, 0x3b32, 0x3ad0, 0x3b2a, 0x3b36, 0x3b3e, 0x3b43,
	0x3b45, 0x3b40, 0x3b51, 0x3b55, 0x3b5a, 0x3b5b, 0x3b65, 0x3b69,
	0x3b70, 0x3b73, 0x3b75, 0x3b78, 0x4588, 0x3b7a, 0x3b80, 0x3b83,
	0x3ba6, 0x3bb8, 0x3bc3, 0x3bc7, 0x3bc9, 0x3bd4, 0x3bd0, 0x3be4,
	0x3be6, 0x3be2, 0x3bde, 0x3be5, 0x3beb, 0x3bf0, 0x3bf6, 0x3bf3,
	0x3c05, 0x3c07, 0x3c08, 0x3c0d, 0x3c13, 0x3c20, 0x3c22, 0x3c28,
	0x3c38, 0x3c39, 0x3c41, 0x3c46, 0x3c4e, 0x3c53,
	/* 0x15621..0x1567E */
	0x3c50, 0x3c4f, 0x3b71, 0x3c6c, 0x3c6e, 0x2e62, 0x3c76, 0x3c79,
	0x3c8c, 0x3c91, 0x3c94, 0x399b, 0x3cab, 0x3cbb, 0x3cb6, 0x3cbc,
	0x3cb7, 0x3cc5, 0x3cbe, 0x3cc7, 0x3cd9, 0x3ce9, 0x3cfd, 0x3cfa,
	0x3ced, 0x3d8c, 0x3cea, 0x3d0b, 0x3d15, 0x3d17, 0x3d5c, 0x3d1f,
	0x3d1b, 0x3d11, 0x3d14, 0x3d22, 0x3d1a, 0x3d19, 0x3d18, 0x3d4c,
	0x3d52, 0x3d4e, 0x3d4b, 0x3d6c, 0x3d73, 0x3d76, 0x3d87, 0x3d84,
	0x3d82, 0x3da2, 0x3d9d, 0x3dac, 0x3dae, 0x3dbd, 0x3d90, 0x3db7,
	0x3dbc, 0x3dc9, 0x3dcd, 0x3dd3, 0x3dd2, 0x3dd6, 0x3ddb, 0x3deb,
	0x3df2, 0x3df5, 0x3e0b, 0x3e1a, 0x3e19, 0x3e11, 0x3e1b, 0x3e36,
	0x3e37, 0x3e44, 0x3e43, 0x3e40, 0x3e4e, 0x3e57, 0x3e54, 0x3e5f,
	0x3e62, 0x3e64, 0x3e47, 0x3e75, 0x3e76, 0x3e7a, 0x7ebc, 0x3e7f,
	0x3ea0, 0x3ec1, 0x3ec2, 0x3ec8, 0x3ed0, 0x3ecf,
	/* 0x15721..0x1577E */
	0x3ed6, 0x3ee3, 0x3edd, 0x3eda, 0x3edb, 0x3ee2, 0x3ee1, 0x3ee8,
	0x3ee9, 0x3eec, 0x3ef1, 0x3ef3, 0x3ef0, 0x3ef4, 0x3ef8, 0x3efe,
	0x3f03, 0x3f09, 0x3f5d, 0x3f5c, 0x3f0b, 0x3f11, 0x3f16, 0x3f29,
	0x3f2d, 0x3f38, 0x3f41, 0x3f48, 0x3f4c, 0x3f4e, 0x3f2f, 0x3f51,
	0x3f56, 0x3f57, 0x3f59, 0x3f61, 0x3f6d, 0x3f73, 0x3f77, 0x3f83,
	0x3f82, 0x3f7f, 0x3f8a, 0x3f88, 0x3f91, 0x3f87, 0x3f9e, 0x3f99,
	0x3f98, 0x3fa0, 0x3fa8, 0x3fad, 0x3fbc, 0x3fd6, 0x3ffb, 0x3fe4,
	0x3ff8, 0x3ff1, 0x3fdd, 0x40b3, 0x3fff, 0x4021, 0x4060, 0x4019,
	0x4010, 0x4029, 0x400e, 0x4031, 0x401b, 0x4015, 0x402b, 0x4026,
	0x400f, 0x403a, 0x405a, 0x4041, 0x406a, 0x4077, 0x405f, 0x404a,
	0x4046, 0x404d, 0x4063, 0x4043, 0x4064, 0x4042, 0x406c, 0x406b,
	0x4059, 0x4081, 0x408d, 0x40e7, 0x4083, 0x409a,
	/* 0x15821..0x1587E */
	0x4084, 0x409b, 0x4096, 0x4097, 0x4092, 0x40a7, 0x408b, 0x40e1,
	0x40b8, 0x40e0, 0x40d3, 0x40b4, 0x3ff0, 0x40bd, 0x40c6, 0x40b5,
	0x40d8, 0x414d, 0x4115, 0x4106, 0x40f6, 0x40f7, 0x4100, 0x40f4,
	0x40fa, 0x4103, 0x4121, 0x40fb, 0x40f1, 0x410d, 0x410e, 0x4147,
	0x413e, 0x4128, 0x4127, 0x414a, 0x413f, 0x413c, 0x412c, 0x4134,
	0x413d, 0x4142, 0x4144, 0x4173, 0x4177, 0x4158, 0x4159, 0x415a,
	0x416b, 0x4174, 0x416f, 0x4165, 0x4171, 0x415f, 0x415d, 0x4153,
	0x4175, 0x4199, 0x4196, 0x4187, 0x41ac, 0x4194, 0x419a, 0x418a,
	0x4191, 0x41ab, 0x41ae, 0x41cc, 0x41ca, 0x41c9, 0x41f7, 0x41c8,
	0x41c3, 0x41c6, 0x41ba, 0x41cb, 0x5f79, 0x41cd, 0x41e6, 0x41e3,
	0x41f6, 0x41fa, 0x41f4, 0x41ff, 0x41fd, 0x41fc, 0x41fe, 0x4200,
	0x4208, 0x4209, 0x420d, 0x420c, 0x4214, 0x421b,
	/* 0x15921..0x1597E */
	0x421e, 0x4221, 0x422a, 0x422e, 0x4230, 0x4232, 0x4233, 0x4241,
	0x424e, 0x425e, 0x4263, 0x425b, 0x4260, 0x4268, 0x427c, 0x4282,
	0x4289, 0x427e, 0x4292, 0x4293, 0x4296, 0x42d4, 0x4283, 0x4294,
	0x42d7, 0x42d1, 0x42bb, 0x42cf, 0x42ff, 0x42c6, 0x44d4, 0x42c8,
	0x42dc, 0x42cc, 0x42ca, 0x42c2, 0x42c7, 0x429b, 0x42c9, 0x430c,
	0x42ee, 0x42f1, 0x4327, 0x4302, 0x4308, 0x42ef, 0x42f5, 0x4350,
	0x433e, 0x434d, 0x441c, 0x434f, 0x4396, 0x438e, 0x4380, 0x43ab,
	0x4376, 0x43a3, 0x438f, 0x4389, 0x439f, 0x43b5, 0x436b, 0x4369,
	0x43be, 0x43e9, 0x43c0, 0x43c6, 0x43e3, 0x43c9, 0x43d2, 0x43f6,
	0x43c4, 0x4416, 0x4434, 0x4406, 0x4413, 0x4426, 0x4436, 0x451d,
	0x4417, 0x4428, 0x440f, 0x4467, 0x446f, 0x4476, 0x444e, 0x452a,
	0x4495, 0x4493, 0x44a5, 0x44a9, 0x4488, 0x44bc,
	/* 0x15A21..0x15A7E */
	0x44da, 0x44d2, 0x44c5, 0x44c7, 0x44bb, 0x44d8, 0x44c2, 0x44f1,
	0x44e7, 0x6209, 0x44e0, 0x44e1, 0x42ac, 0x44e3, 0x44ef, 0x452c,
	0x44f6, 0x44f4, 0x44f2, 0x44fa, 0x4500, 0x44fd, 0x4518, 0x451c,
	0x4505, 0x4524, 0x4523, 0x452b, 0x4534, 0x4535, 0x4537, 0x4536,
	0x4538, 0x554b, 0x4548, 0x4556, 0x4555, 0x454d, 0x4558, 0x455e,
	0x455d, 0x4572, 0x4578, 0x4582, 0x4583, 0x6b8a, 0x459b, 0x459f,
	0x45ab, 0x45b7, 0x45c3, 0x45c6, 0x45c1, 0x45c4, 0x45cc, 0x45d2,
	0x45db, 0x45d9, 0x45e0, 0x45e1, 0x45f1, 0x4772, 0x460a, 0x4603,
	0x45fb, 0x4773, 0x4635, 0x4636, 0x4634, 0x461c, 0x464f, 0x4644,
	0x4649, 0x4641, 0x465e, 0x465d, 0x4664, 0x4667, 0x4668, 0x465f,
	0x4662, 0x4670, 0x4683, 0x4688, 0x468e, 0x4689, 0x4684, 0x4698,
	0x469d, 0x46c1, 0x46b9, 0x46c9, 0x46be, 0x46bc,
	/* 0x15B21..0x15B7E */
	0x46c4, 0x46b8, 0x46d6, 0x46da, 0x46e0, 0x463f, 0x46e6, 0x46e9,
	0x46f0, 0x46f5, 0x46f7, 0x470f, 0x4716, 0x471e, 0x4726, 0x4727,
	0x7738, 0x472e, 0x473f, 0x4736, 0x4741, 0x4738, 0x4737, 0x4746,
	0x475e, 0x4760, 0x4759, 0x4763, 0x4764, 0x4789, 0x4770, 0x47a9,
	0x477c, 0x476a, 0x478c, 0x478b, 0x47a6, 0x47a1, 0x4785, 0x47b7,
	0x47ef, 0x47b4, 0x47ec, 0x47b3, 0x47e9, 0x47b8, 0x47e4, 0x47de,
	0x47dd, 0x47e2, 0x47ee, 0x47b9, 0x47ce, 0x47c6, 0x47e7, 0x4a9c,
	0x481e, 0x4846, 0x4829, 0x4840, 0x484d, 0x4832, 0x484e, 0x48b3,
	0x482b, 0x4859, 0x4863, 0x4877, 0x487f, 0x489f, 0x488f, 0x48ad,
	0x4894, 0x489d, 0x489b, 0x4883, 0x4aae, 0x48b9, 0x4874, 0x48b5,
	0x48a0, 0x48ba, 0x490f, 0x488d, 0x487e, 0x4901, 0x48ca, 0x4908,
	0x48d8, 0x4922, 0x4926, 0x48e1, 0x490c, 0x48cd,
	/* 0x15C21..0x15C7E */
	0x48d4, 0x48e7, 0x48d5, 0x4936, 0x4912, 0x4904, 0x48d7, 0x48e3,
	0x4925, 0x48f9, 0x48e0, 0x48ef, 0x4928, 0x492a, 0x491a, 0x4923,
	0x4921, 0x48c6, 0x4979, 0x4977, 0x495c, 0x4978, 0x496b, 0x4954,
	0x497e, 0x496e, 0x4939, 0x4974, 0x493d, 0x4959, 0x4930, 0x4961,
	0x495e, 0x495d, 0x4981, 0x496a, 0x49b2, 0x49ae, 0x49d0, 0x49bf,
	0x49c1, 0x49d3, 0x49be, 0x49ce, 0x3be8, 0x49ca, 0x49dd, 0x49bb,
	0x49c3, 0x49a7, 0x4a2e, 0x4991, 0x49a0, 0x499c, 0x4995, 0x49b4,
	0x49de, 0x49e8, 0x4a02, 0x4a1b, 0x49ff, 0x4b0a, 0x49f9, 0x49f2,
	0x49e7, 0x4a05, 0x49b1, 0x4a1e, 0x49ed, 0x4a14, 0x49eb, 0x4a0a,
	0x4a12, 0x4ac1, 0x4a23, 0x4a13, 0x4a44, 0x4a0c, 0x4a72, 0x4a36,
	0x4a78, 0x4a47, 0x4a62, 0x4a59, 0x4a66, 0x4a48, 0x4a38, 0x4a22,
	0x4a90, 0x4a8d, 0x4aa0, 0x4a84, 0x4aa2, 0x4aa3,
	/* 0x15D21..0x15D7E */
	0x4a97, 0x6617, 0x4abb, 0x4ac3, 0x4ac2, 0x4ab8, 0x4ab3, 0x4aac,
	0x4ade, 0x4ad1, 0x4adf, 0x4aaa, 0x4ada, 0x4aea, 0x4afb, 0x4b05,
	0x6616, 0x4afa, 0x4b12, 0x4b16, 0x7b31, 0x4b1f, 0x4b38, 0x4b37,
	0x56dc, 0x4b39, 0x78ee, 0x4b47, 0x4b43, 0x4b49, 0x4b50, 0x4b59,
	0x4b54, 0x4b5b, 0x4b5f, 0x4b61, 0x4b78, 0x4b79, 0x4b7f, 0x4b80,
	0x4b84, 0x4b83, 0x4b8d, 0x4b98, 0x4b95, 0x4b9e, 0x4ba4, 0x4baa,
	0x4bab, 0x4baf, 0x4bb2, 0x4bb1, 0x4bb3, 0x4bb7, 0x4bbc, 0x4bc6,
	0x4bcb, 0x4bd3, 0x4bdf, 0x4bec, 0x4beb, 0x4bf3, 0x4bef, 0x7ebe,
	0x4c08, 0x4c13, 0x4c14, 0x4c1b, 0x4c24, 0x4c23, 0x4c5e, 0x4c55,
	0x4c62, 0x4c6a, 0x4c82, 0x4c8d, 0x4c9a, 0x4c81, 0x4c9b, 0x4c7e,
	0x4c68, 0x4c73, 0x4c92, 0x4c90, 0x4cc4, 0x4cf1, 0x4cd3, 0x4cbd,
	0x4cd7, 0x4cc5, 0x4cdd, 0x4cae, 0x4cb1, 0x4cbe,
	/* 0x15E21..0x15E7E */
	0x4cba, 0x4cdb, 0x4cef, 0x4cd9, 0x4cea, 0x4d1f, 0x684d, 0x4d36,
	0x4d2b, 0x4d3d, 0x4d38, 0x4d19, 0x4d35, 0x4d33, 0x4d12, 0x4d0c,
	0x4d63, 0x4d93, 0x4d64, 0x4d5a, 0x4d79, 0x4d59, 0x4d8e, 0x4d95,
	0x4fe4, 0x4d85, 0x4df9, 0x4e15, 0x4e0a, 0x4db5, 0x4dc7, 0x4de6,
	0x4db8, 0x4dc6, 0x4dec, 0x4dde, 0x4dcc, 0x4de8, 0x4dd2, 0x4dc5,
	0x4dfa, 0x4dd9, 0x4de4, 0x4dd5, 0x4dea, 0x4dee, 0x4e2d, 0x4e6e,
	0x4e2e, 0x4e19, 0x4e72, 0x4e5f, 0x4e3e, 0x4e23, 0x4e6b, 0x4e2b,
	0x4e76, 0x4e4d, 0x4e1f, 0x4e43, 0x4e3a, 0x4e4e, 0x4e24, 0x4eff,
	0x4e1d, 0x4e38, 0x4e82, 0x4eaa, 0x4e98, 0x4ec9, 0x4eb7, 0x4ed3,
	0x4ebd, 0x4eaf, 0x4ec4, 0x4eb2, 0x4ed4, 0x4ed5, 0x4e8f, 0x4ea5,
	0x4ec2, 0x4e9f, 0x4f41, 0x4f11, 0x504c, 0x4eec, 0x4ef8, 0x4efe,
	0x4f3f, 0x4ef2, 0x4f31, 0x4eef, 0x4f32, 0x4ecc,
	/* 0x15F21..0x15F7E */
	0x4f3e, 0x4f13, 0x4ef7, 0x4f86, 0x4f7a, 0x4f78, 0x4f81, 0x4f80,
	0x4f6f, 0x4f5b, 0x4ff3, 0x4f6d, 0x4f82, 0x4f7c, 0x4f58, 0x4f8e,
	0x4f91, 0x4fc2, 0x4f66, 0x4fb3, 0x4fa3, 0x4fa1, 0x4fa4, 0x4fb9,
	0x4fc6, 0x4faa, 0x4fdf, 0x4fd5, 0x4fec, 0x4fd4, 0x4fd8, 0x4ff1,
	0x4fee, 0x4fdb, 0x5009, 0x500b, 0x4ffa, 0x5011, 0x5001, 0x500f,
	0x4ffe, 0x501b, 0x501a, 0x4f74, 0x501d, 0x5018, 0x501f, 0x5030,
	0x503e, 0x5032, 0x5051, 0x5063, 0x5099, 0x5092, 0x50af, 0x50f1,
	0x50ac, 0x50b8, 0x50b3, 0x50ae, 0x50df, 0x50cb, 0x50dd, 0x50d9,
	0x5109, 0x50fd, 0x511c, 0x5119, 0x5165, 0x5155, 0x5188, 0x5166,
	0x5162, 0x514c, 0x5156, 0x516c, 0x518f, 0x51fb, 0x5184, 0x5195,
	0x51a8, 0x51ac, 0x51d7, 0x51b9, 0x51be, 0x51d2, 0x51c9, 0x51d4,
	0x51ce, 0x51e0, 0x51ec, 0x51e7, 0x51f5, 0x51fc,
	/* 0x16021..0x1607E */
	0x51f9, 0x51ff, 0x520d, 0x5210, 0x521b, 0x5228, 0x522d, 0x522c,
	0x5230, 0x5232, 0x523b, 0x523c, 0x523f, 0x5240, 0x5246, 0x524b,
	0x5258, 0x5274, 0x527e, 0x5282, 0x5281, 0x5287, 0x5292, 0x5296,
	0x52a2, 0x52a7, 0x52b9, 0x52b2, 0x52c3, 0x52c6, 0x52c4, 0x52ce,
	0x52d2, 0x52e2, 0x52e0, 0x52e1, 0x52f9, 0x52f7, 0x300f, 0x5317,
	0x530a, 0x531c, 0x5316, 0x531d, 0x5334, 0x532f, 0x5329, 0x5325,
	0x533e, 0x534e, 0x534f, 0x7ed8, 0x5357, 0x536a, 0x5368, 0x5370,
	0x5378, 0x5375, 0x537b, 0x537a, 0x53c8, 0x53b3, 0x53ce, 0x53bb,
	0x53c0, 0x53e5, 0x53ee, 0x53de, 0x54a2, 0x5405, 0x546f, 0x5425,
	0x53f8, 0x5432, 0x543a, 0x5455, 0x543f, 0x545f, 0x5459, 0x5441,
	0x545c, 0x5469, 0x5470, 0x5463, 0x546a, 0x5476, 0x547e, 0x548b,
	0x549e, 0x54a7, 0x54ca, 0x54cf, 0x54d4, 0x53f1,
	/* 0x16121..0x1617E */
	0x54e0, 0x54e3, 0x54e7, 0x54e9, 0x54ee, 0x54f2, 0x54f0, 0x54f1,
	0x54f8, 0x54f7, 0x5504, 0x5503, 0x5505, 0x550c, 0x550e, 0x550d,
	0x5515, 0x5513, 0x551e, 0x5526, 0x552c, 0x553c, 0x5544, 0x554d,
	0x554a, 0x5549, 0x555b, 0x5546, 0x555a, 0x5569, 0x5564, 0x5567,
	0x556b, 0x556d, 0x5578, 0x5576, 0x5586, 0x5587, 0x5574, 0x558a,
	0x5589, 0x5582, 0x5594, 0x559a, 0x559d, 0x55a5, 0x55a3, 0x55c2,
	0x55b3, 0x55c3, 0x55b5, 0x55bd, 0x55b8, 0x55bc, 0x55b1, 0x55cd,
	0x55ca, 0x55d2, 0x55d9, 0x55e3, 0x55de, 0x55fe, 0x55ff, 0x55fc,
	0x5601, 0x55f0, 0x55fa, 0x55f2, 0x55f3, 0x560b, 0x560d, 0x5609,
	0x561f, 0x5627, 0x5620, 0x5621, 0x5622, 0x5624, 0x5634, 0x5630,
	0x563b, 0x5647, 0x5648, 0x5646, 0x565c, 0x5658, 0x5661, 0x5662,
	0x5668, 0x5669, 0x566a, 0x5667, 0x566c, 0x5670,
	/* 0x16221..0x1627E */
	0x5672, 0x5676, 0x5678, 0x567c, 0x5680, 0x5683, 0x5688, 0x568b,
	0x568e, 0x5696, 0x5693, 0x5699, 0x569a, 0x56b0, 0x56b4, 0x56b8,
	0x56b9, 0x56ba, 0x56c2, 0x56cd, 0x56d6, 0x56d2, 0x56de, 0x56e1,
	0x56e5, 0x56e7, 0x56ea, 0x662f, 0x56fb, 0x5708, 0x5707, 0x5704,
	0x5729, 0x5724, 0x571e, 0x5725, 0x5726, 0x571b, 0x5737, 0x5738,
	0x5747, 0x575a, 0x5768, 0x576b, 0x575b, 0x5765, 0x577f, 0x577e,
	0x5779, 0x578e, 0x578b, 0x5791, 0x57a0, 0x579e, 0x57b0, 0x57b6,
	0x57b9, 0x57bf, 0x57bc, 0x57bd, 0x57bb, 0x57c7, 0x57cd, 0x57d7,
	0x57da, 0x57dc, 0x57e3, 0x57ee, 0x57fc, 0x580c, 0x5812, 0x5926,
	0x5820, 0x592a, 0x5845, 0x588e, 0x5874, 0x5886, 0x587c, 0x589a,
	0x588c, 0x58a3, 0x58b5, 0x58aa, 0x58af, 0x58d1, 0x58c6, 0x58cb,
	0x58d4, 0x58be, 0x58bc, 0x58c5, 0x58ca, 0x58ec,
	/* 0x16321..0x1637E */
	0x58e7, 0x58da, 0x58fd, 0x58f4, 0x5907, 0x5912, 0x5911, 0x5919,
	0x592c, 0x592b, 0x5940, 0x5960, 0x5957, 0x595f, 0x595a, 0x5955,
	0x5953, 0x597a, 0x597f, 0x598a, 0x599d, 0x59a7, 0x7f4b, 0x59aa,
	0x59ae, 0x59b3, 0x59b9, 0x59ba, 0x59c9, 0x59d5, 0x59e7, 0x59ec,
	0x59e1, 0x59e3, 0x5a08, 0x5a0d, 0x5a18, 0x5a19, 0x5a20, 0x5a1f,
	0x5980, 0x5a31, 0x5a3b, 0x5a3e, 0x5a37, 0x5a43, 0x5a57, 0x5a49,
	0x5a61, 0x5a62, 0x5a69, 0x7f9d, 0x5a70, 0x5a79, 0x5a7d, 0x5a88,
	0x5a97, 0x5a95, 0x5a98, 0x5a96, 0x5aa9, 0x5ac8, 0x5ab0, 0x5ab6,
	0x5ac5, 0x5ac4, 0x5abf, 0x7083, 0x5ac7, 0x5aca, 0x5acd, 0x5acf,
	0x5ad5, 0x5ad3, 0x5ad9, 0x5ada, 0x5add, 0x5ae1, 0x5ae2, 0x5ae6,
	0x5aed, 0x5af0, 0x5b02, 0x5b0f, 0x5b0a, 0x5b06, 0x5b33, 0x5b18,
	0x5b19, 0x5b1e, 0x5b35, 0x5b28, 0x5b36, 0x5b50,
	/* 0x16421..0x1647E */
	0x5b7a, 0x5b04, 0x5b4d, 0x5b0b, 0x5b4c, 0x5b45, 0x5b75, 0x5b65,
	0x5b74, 0x5b67, 0x5b70, 0x5b71, 0x5b6c, 0x5b6e, 0x5b9d, 0x5b98,
	0x5b9f, 0x5b8d, 0x5b9c, 0x5b9a, 0x5b8b, 0x5b92, 0x5b8f, 0x5b5d,
	0x5b99, 0x5bcb, 0x5bc1, 0x5bcc, 0x5bcf, 0x5bb4, 0x5bc6, 0x5bdd,
	0x5be9, 0x5c11, 0x5c14, 0x5be6, 0x5be5, 0x5c60, 0x5c00, 0x5c07,
	0x5c13, 0x5bf3, 0x5bf7, 0x5c17, 0x5c0d, 0x5bf6, 0x5c23, 0x5c27,
	0x5c2a, 0x5c1f, 0x5c37, 0x5c2b, 0x5c3d, 0x5c4c, 0x5c43, 0x5c54,
	0x5c4f, 0x5c40, 0x5c50, 0x5c58, 0x5c5f, 0x5c64, 0x5c56, 0x5c65,
	0x5c6c, 0x5c75, 0x5c83, 0x5c90, 0x5ca4, 0x5cad, 0x5ca2, 0x5cab,
	0x5ca1, 0x5ca8, 0x5cb3, 0x5cb2, 0x5cb1, 0x5cae, 0x5cb9, 0x5cbd,
	0x5cc0, 0x5cc5, 0x5cc2, 0x5cd8, 0x5cd2, 0x5cdc, 0x5ce2, 0x7b3b,
	0x5cef, 0x5cf2, 0x5cf4, 0x5cf6, 0x5cfa, 0x5d06,
	/* 0x16521..0x1657E */
	0x5d02, 0x5d1c, 0x5d15, 0x5d0a, 0x5d45, 0x5d4b, 0x5d2e, 0x5d32,
	0x5d3f, 0x5d35, 0x5d46, 0x5d73, 0x5d56, 0x5d4e, 0x5d72, 0x5d68,
	0x5d6e, 0x5d4f, 0x5d63, 0x5d93, 0x5d89, 0x5d5b, 0x5d8f, 0x5d7d,
	0x5d9b, 0x5dba, 0x5dae, 0x5da3, 0x5db5, 0x5dc7, 0x5dbd, 0x5dab,
	0x5e3d, 0x5da2, 0x5daf, 0x5ddc, 0x5db8, 0x5d9f, 0x5db0, 0x5dd8,
	0x5ddd, 0x5de4, 0x5dde, 0x5dfb, 0x5df2, 0x5de1, 0x5e05, 0x5e0a,
	0x5e23, 0x5e21, 0x5e12, 0x5e31, 0x5e1f, 0x5e09, 0x5e0b, 0x5e22,
	0x5e46, 0x5e66, 0x5e3b, 0x5e35, 0x5e39, 0x5e43, 0x5e37, 0x5e32,
	0x5e3a, 0x5e67, 0x5e5d, 0x5e56, 0x5e5e, 0x5e59, 0x5e5a, 0x5e79,
	0x5e6a, 0x5e69, 0x5e7c, 0x5e7b, 0x5e83, 0x5dd5, 0x5e7d, 0x6fae,
	0x5e7f, 0x5e88, 0x5e89, 0x5e8c, 0x5e92, 0x5e90, 0x5e93, 0x5e94,
	0x5e96, 0x5e8e, 0x5e9b, 0x5e9c, 0x5f38, 0x5f3a,
	/* 0x16621..0x1667E */
	0x5f45, 0x5f4c, 0x5f4d, 0x5f4e, 0x5f50, 0x5f51, 0x5f55, 0x5f54,
	0x5f58, 0x5f5f, 0x5f60, 0x5f68, 0x5f69, 0x5f67, 0x5f78, 0x5f82,
	0x5f86, 0x5f83, 0x5f88, 0x5f87, 0x5f8c, 0x5f94, 0x5f9e, 0x5f9d,
	0x5f9a, 0x5fa3, 0x5faf, 0x5fb2, 0x5fb9, 0x5fae, 0x5fb6, 0x5fb8,
	0x6b71, 0x5fc5, 0x5fc6, 0x5fca, 0x5fd5, 0x5fd4, 0x5fe1, 0x5fe6,
	0x5fe9, 0x5ff3, 0x5ff9, 0x78dc, 0x6006, 0x6004, 0x600b, 0x6012,
	0x6018, 0x6019, 0x601c, 0x6021, 0x6028, 0x603f, 0x603b, 0x604a,
	0x6046, 0x6052, 0x6058, 0x605a, 0x605f, 0x6062, 0x6068, 0x6073,
	0x6072, 0x6070, 0x6076, 0x6079, 0x607d, 0x607f, 0x6084, 0x6086,
	0x6085, 0x609b, 0x6093, 0x609a, 0x60ad, 0x3190, 0x60ac, 0x60db,
	0x60e5, 0x60d9, 0x60dd, 0x60c4, 0x60da, 0x60d6, 0x6109, 0x60ef,
	0x60f1, 0x611b, 0x6129, 0x6123, 0x612f, 0x614b,
	/* 0x16721..0x1677E */
	0x768b, 0x6146, 0x613e, 0x6153, 0x6151, 0x60fc, 0x6171, 0x616e,
	0x6165, 0x6166, 0x6174, 0x6183, 0x6188, 0x618a, 0x6180, 0x6182,
	0x61a0, 0x6195, 0x61a4, 0x61a3, 0x615f, 0x6193, 0x61a9, 0x61b0,
	0x61b5, 0x61be, 0x61b8, 0x61bd, 0x61c0, 0x61c2, 0x61ba, 0x61c9,
	0x61cd, 0x61d1, 0x61d9, 0x61d8, 0x61c8, 0x61da, 0x61df, 0x61e0,
	0x61e7, 0x61fa, 0x61fb, 0x61fe, 0x6201, 0x6202, 0x6205, 0x6207,
	0x620a, 0x620d, 0x6210, 0x6216, 0x6229, 0x622b, 0x6238, 0x6233,
	0x6240, 0x6259, 0x6258, 0x625d, 0x625a, 0x625f, 0x6264, 0x6262,
	0x6268, 0x626a, 0x626b, 0x622e, 0x6271, 0x6277, 0x6278, 0x627e,
	0x628d, 0x6292, 0x62ab, 0x629f, 0x62bb, 0x62ac, 0x62e1, 0x62e3,
	0x62df, 0x62d2, 0x62f4, 0x62f3, 0x62fa, 0x6393, 0x6303, 0x62fb,
	0x62f9, 0x62de, 0x6306, 0x62dc, 0x6309, 0x62d9,
	/* 0x16821..0x1687E */
	0x6335, 0x6334, 0x6316, 0x6332, 0x6331, 0x6340, 0x6339, 0x6350,
	0x6345, 0x632f, 0x632b, 0x6317, 0x6318, 0x6385, 0x639a, 0x63aa,
	0x639f, 0x63a2, 0x6396, 0x6323, 0x638e, 0x6387, 0x638a, 0x637c,
	0x63b5, 0x6373, 0x6375, 0x63a0, 0x6389, 0x63a8, 0x63f4, 0x6413,
	0x63eb, 0x63ce, 0x63fd, 0x6403, 0x63d8, 0x640b, 0x63c1, 0x63f7,
	0x6407, 0x63e0, 0x63f2, 0x640d, 0x6422, 0x6420, 0x63bd, 0x6438,
	0x6506, 0x63fb, 0x646d, 0x642a, 0x643c, 0x655a, 0x6484, 0x6477,
	0x646b, 0x64ad, 0x646e, 0x6482, 0x6469, 0x6446, 0x642c, 0x646f,
	0x6479, 0x6435, 0x64ca, 0x6462, 0x64b9, 0x64bf, 0x649f, 0x64d9,
	0x64cd, 0x64bb, 0x64da, 0x64d0, 0x64c1, 0x64c6, 0x64d6, 0x64a1,
	0x6521, 0x64ff, 0x64f4, 0x6517, 0x6518, 0x652c, 0x651f, 0x6515,
	0x6514, 0x64fc, 0x6540, 0x6563, 0x6558, 0x6548,
	/* 0x16921..0x1697E */
	0x6541, 0x6602, 0x654b, 0x6555, 0x6580, 0x65a4, 0x6588, 0x6591,
	0x658a, 0x65a8, 0x656d, 0x6594, 0x659b, 0x65ea, 0x6587, 0x659c,
	0x6577, 0x657e, 0x6590, 0x65c9, 0x65ba, 0x65cf, 0x65b9, 0x65d0,
	0x65d5, 0x65dd, 0x65e5, 0x65dc, 0x65f9, 0x660a, 0x6613, 0x660b,
	0x65fe, 0x65fa, 0x6606, 0x6622, 0x661a, 0x6630, 0x663f, 0x664d,
	0x2e55, 0x6654, 0x665f, 0x6667, 0x6671, 0x6693, 0x66a3, 0x66a9,
	0x66aa, 0x668b, 0x668c, 0x66b6, 0x66af, 0x66c4, 0x66c6, 0x66b0,
	0x66c9, 0x6823, 0x66ab, 0x66d4, 0x66de, 0x66e9, 0x66ec, 0x66df,
	0x66db, 0x66ef, 0x6712, 0x6706, 0x6708, 0x6700, 0x6703, 0x66fb,
	0x6711, 0x6709, 0x670d, 0x66f9, 0x670a, 0x6734, 0x673f, 0x6737,
	0x673b, 0x6725, 0x6729, 0x671a, 0x6760, 0x675f, 0x6778, 0x674c,
	0x674e, 0x6774, 0x6757, 0x6768, 0x676e, 0x6759,
	/* 0x16A21..0x16A7E */
	0x6753, 0x6763, 0x676a, 0x6805, 0x67a2, 0x679f, 0x6782, 0x67af,
	0x67cb, 0x67bd, 0x67c0, 0x67d0, 0x76d6, 0x67ab, 0x67c4, 0x67b3,
	0x67c7, 0x67c6, 0x67bb, 0x67ef, 0x67f2, 0x67e0, 0x680f, 0x680d,
	0x67fe, 0x67f6, 0x67f7, 0x680e, 0x67d2, 0x6811, 0x6816, 0x6815,
	0x6822, 0x6821, 0x6831, 0x6836, 0x6839, 0x6827, 0x683b, 0x6844,
	0x6842, 0x6852, 0x6859, 0x685e, 0x6862, 0x686b, 0x6881, 0x687e,
	0x689e, 0x6875, 0x687d, 0x68b5, 0x6872, 0x6882, 0x6897, 0x6892,
	0x68ae, 0x6899, 0x68a2, 0x688d, 0x68a4, 0x68b0, 0x68bf, 0x68b1,
	0x68c3, 0x68c4, 0x68d4, 0x68d8, 0x68d9, 0x68dd, 0x68f9, 0x6902,
	0x68fc, 0x68f4, 0x68e8, 0x68f2, 0x6904, 0x690c, 0x690a, 0x6913,
	0x6943, 0x691e, 0x6925, 0x692a, 0x692b, 0x6941, 0x6944, 0x693b,
	0x6936, 0x6938, 0x694c, 0x691d, 0x6960, 0x695e,
	/* 0x16B21..0x16B7E */
	0x6966, 0x6964, 0x696d, 0x696a, 0x696f, 0x6974, 0x6977, 0x697e,
	0x6983, 0x6988, 0x698a, 0x6993, 0x6998, 0x69a1, 0x69a9, 0x69a6,
	0x69ac, 0x69af, 0x69b2, 0x69ba, 0x69bd, 0x69bf, 0x69c0, 0x69da,
	0x69dc, 0x69dd, 0x69e7, 0x69f4, 0x69f8, 0x6a03, 0x6a16, 0x6a10,
	0x6a0c, 0x6a1b, 0x6a1d, 0x6a25, 0x6a36, 0x6a41, 0x6a5b, 0x6a52,
	0x6a46, 0x6a48, 0x6a7c, 0x6a6d, 0x6a6c, 0x6a62, 0x6a85, 0x6a82,
	0x6a84, 0x6aa8, 0x6aa1, 0x6a91, 0x6aa5, 0x6aa6, 0x6a9a, 0x6aa3,
	0x6ac4, 0x6acd, 0x6ac2, 0x6ada, 0x6aeb, 0x6af3, 0x6ae7, 0x6ae4,
	0x6af1, 0x6b14, 0x6ae0, 0x6ae2, 0x6af7, 0x6ade, 0x6adb, 0x6b0c,
	0x6b07, 0x6b1a, 0x6ae1, 0x6b16, 0x6b10, 0x6b17, 0x6b20, 0x6b33,
	0x77ab, 0x6b26, 0x6b2b, 0x6b3e, 0x6b28, 0x6b41, 0x6b4c, 0x6b4f,
	0x6b4e, 0x6b49, 0x6b56, 0x6b5b, 0x6b5a, 0x6b6b,
	/* 0x16C21..0x16C7E */
	0x6b5f, 0x6b6c, 0x6b6f, 0x6b74, 0x6b7d, 0x6b80, 0x6b8c, 0x6b8e,
	0x6b92, 0x6b93, 0x6b96, 0x6b99, 0x6b9a, 0x6c3a, 0x6c41, 0x6c3f,
	0x6c48, 0x6c4c, 0x6c4e, 0x6c50, 0x6c55, 0x6c62, 0x6c6c, 0x6c78,
	0x6c7a, 0x6c82, 0x6c89, 0x6c85, 0x6c8a, 0x6c8d, 0x6c8e, 0x6c94,
	0x6c7c, 0x6c98, 0x421d, 0x6cad, 0x6caa, 0x6cbd, 0x6cb2, 0x6cb3,
	0x6cae, 0x6cb6, 0x6cc8, 0x6cc1, 0x6ce4, 0x6ce3, 0x6cda, 0x6cfd,
	0x6cfa, 0x6cfb, 0x6d04, 0x6d05, 0x6d0a, 0x6d07, 0x6d0f, 0x6d0d,
	0x6d10, 0x7f4e, 0x6d13, 0x6ccd, 0x6d14, 0x6d16, 0x6d67, 0x6d6d,
	0x6d71, 0x6d73, 0x6d81, 0x6d99, 0x6dc2, 0x6dbe, 0x6dba, 0x6dcf,
	0x6dda, 0x6dd6, 0x6dcc, 0x6ddb, 0x6dcb, 0x6dea, 0x6deb, 0x6ddf,
	0x6de3, 0x6dfc, 0x6e08, 0x6e09, 0x6dff, 0x6e1d, 0x6e1e, 0x6e10,
	0x6e1f, 0x6e42, 0x6e35, 0x6e30, 0x6e34, 0x6e4a,
	/* 0x16D21..0x16D7E */
	0x6e47, 0x6e49, 0x6e4c, 0x6e50, 0x6e48, 0x6e59, 0x6e64, 0x6e60,
	0x6e2a, 0x6e63, 0x6e55, 0x6e76, 0x6e72, 0x6e7c, 0x6e81, 0x6e87,
	0x6e85, 0x6e84, 0x6e8b, 0x6e8a, 0x6e93, 0x6e91, 0x6e94, 0x6e99,
	0x6eaa, 0x6ea1, 0x6eac, 0x6eb0, 0x6ec6, 0x6eb1, 0x6ebe, 0x6ec5,
	0x6ec8, 0x6ecb, 0x6edb, 0x6ee3, 0x6efc, 0x6efb, 0x6eeb, 0x6efe,
	0x6f0a, 0x6f05, 0x6f15, 0x6f12, 0x6f19, 0x6f13, 0x6f1c, 0x6f1f,
	0x6f1b, 0x6f0c, 0x6f26, 0x6f33, 0x6f3b, 0x6f39, 0x6f45, 0x6f42,
	0x6f3e, 0x6f4c, 0x6f49, 0x6f46, 0x6f4e, 0x6f57, 0x6f5c, 0x6f62,
	0x6f63, 0x6f64, 0x6f9c, 0x6f9f, 0x6fa3, 0x6fad, 0x6faf, 0x6fb7,
	0x6fda, 0x6fe5, 0x6fe2, 0x6fea, 0x6fef, 0x7087, 0x6ff4, 0x7005,
	0x6ff9, 0x6ffa, 0x7011, 0x7015, 0x7021, 0x700d, 0x701e, 0x7016,
	0x700b, 0x7027, 0x7036, 0x7035, 0x7039, 0x6ff8,
	/* 0x16E21..0x16E7E */
	0x704f, 0x7050, 0x7051, 0x7052, 0x700e, 0x7049, 0x703e, 0x7056,
	0x7058, 0x705e, 0x7068, 0x706f, 0x7076, 0x76a8, 0x7072, 0x7082,
	0x707d, 0x7081, 0x7080, 0x708a, 0x7089, 0x708f, 0x70a8, 0x70af,
	0x70b1, 0x70b5, 0x70e2, 0x70e4, 0x4248, 0x70db, 0x7102, 0x7112,
	0x7119, 0x7132, 0x7130, 0x714a, 0x7156, 0x7158, 0x7163, 0x7165,
	0x7169, 0x7173, 0x7172, 0x718b, 0x7189, 0x7182, 0x71a2, 0x71ab,
	0x71af, 0x71aa, 0x71b5, 0x71b4, 0x71ba, 0x71c0, 0x71c1, 0x71c9,
	0x71cb, 0x71d0, 0x71d6, 0x71df, 0x71e1, 0x71db, 0x71fc, 0x71f5,
	0x71f6, 0x721e, 0x71ff, 0x7214, 0x722c, 0x7215, 0x7211, 0x725e,
	0x7257, 0x7245, 0x7249, 0x7264, 0x7248, 0x7295, 0x723f, 0x724b,
	0x7250, 0x729c, 0x7296, 0x7293, 0x729b, 0x725a, 0x72cf, 0x72b9,
	0x72b7, 0x72e9, 0x730f, 0x72fa, 0x7344, 0x732e,
	/* 0x16F21..0x16F7E */
	0x7319, 0x7322, 0x731a, 0x7323, 0x733a, 0x7335, 0x733b, 0x735c,
	0x7360, 0x737c, 0x736e, 0x7356, 0x73b0, 0x73ac, 0x73ad, 0x7394,
	0x73b9, 0x73d6, 0x73d7, 0x73e8, 0x73e5, 0x73d8, 0x73c3, 0x73dd,
	0x73d0, 0x73c8, 0x73e4, 0x741a, 0x7414, 0x7413, 0x7403, 0x7407,
	0x7410, 0x7436, 0x742b, 0x7435, 0x7421, 0x743a, 0x7441, 0x7452,
	0x7444, 0x745b, 0x7460, 0x7462, 0x745e, 0x746a, 0x7229, 0x7470,
	0x7475, 0x7477, 0x747d, 0x745a, 0x747c, 0x747e, 0x7481, 0x747f,
	0x7582, 0x7587, 0x758a, 0x7594, 0x7596, 0x7598, 0x7599, 0x75a0,
	0x75a8, 0x75a7, 0x75ad, 0x75bc, 0x75bb, 0x75b9, 0x75be, 0x75ca,
	0x4ff6, 0x75c3, 0x75cd, 0x75cc, 0x75d5, 0x75d4, 0x75d6, 0x75dc,
	0x75e1, 0x75e5, 0x75e2, 0x7621, 0x7628, 0x762e, 0x762f, 0x7642,
	0x764c, 0x764f, 0x764b, 0x7677, 0x765c, 0x765e,
	/* 0x17021..0x1707E */
	0x765d, 0x765f, 0x7666, 0x7672, 0x766c, 0x768d, 0x7698, 0x7695,
	0x7697, 0x76aa, 0x76a7, 0x76b1, 0x76b2, 0x76b0, 0x76b4, 0x76b6,
	0x76b8, 0x76b9, 0x76ce, 0x76cb, 0x76c9, 0x76cd, 0x694d, 0x76dc,
	0x770d, 0x76d5, 0x76f9, 0x7704, 0x7706, 0x7708, 0x7713, 0x770e,
	0x7711, 0x770f, 0x7716, 0x7719, 0x7724, 0x772a, 0x7730, 0x7739,
	0x773d, 0x773e, 0x7744, 0x7746, 0x7748, 0x7742, 0x7749, 0x775c,
	0x7760, 0x7764, 0x7766, 0x7768, 0x32d2, 0x776b, 0x7771, 0x7779,
	0x7785, 0x777c, 0x7781, 0x777a, 0x7786, 0x778b, 0x778f, 0x7790,
	0x779c, 0x77a8, 0x77a6, 0x77a3, 0x77b3, 0x77b4, 0x77c3, 0x77c6,
	0x77c8, 0x77cb, 0x77dc, 0x77ed, 0x7f4f, 0x77f2, 0x5adf, 0x77f6,
	0x77f5, 0x780f, 0x780c, 0x7838, 0x7824, 0x7821, 0x7837, 0x783d,
	0x7846, 0x784f, 0x784b, 0x786b, 0x786f, 0x7870,
	/* 0x17121..0x1717E */
	0x7871, 0x7874, 0x7873, 0x78aa, 0x78af, 0x78b1, 0x78b6, 0x78c4,
	0x78c3, 0x78c6, 0x78e9, 0x78eb, 0x7903, 0x7909, 0x7912, 0x7914,
	0x7918, 0x7921, 0x791d, 0x791e, 0x7924, 0x7920, 0x792c, 0x792e,
	0x793d, 0x793e, 0x7942, 0x7949, 0x7945, 0x7950, 0x794b, 0x7951,
	0x7952, 0x794c, 0x7955, 0x7997, 0x7998, 0x79a5, 0x79ad, 0x79ae,
	0x79bc, 0x79df, 0x79db, 0x79dd, 0x79d8, 0x79d1, 0x79ed, 0x79ee,
	0x79f1, 0x79f2, 0x79fb, 0x79f8, 0x7a01, 0x7a0f, 0x7a05, 0x79e2,
	0x7a19, 0x7a2b, 0x7a37, 0x7a45, 0x7a42, 0x7a40, 0x7a43, 0x7a3e,
	0x7a55, 0x7a4d, 0x7a5b, 0x7a57, 0x7a5f, 0x7a62, 0x7a65, 0x7a64,
	0x7a69, 0x7a6b, 0x7a6a, 0x7aad, 0x7ab0, 0x7abc, 0x7ac0, 0x7acf,
	0x7ad1, 0x7ad3, 0x7ad4, 0x7ade, 0x7adf, 0x7ae2, 0x7ae3, 0x7ae6,
	0x7aef, 0x7aeb, 0x7aee, 0x7af4, 0x7af1, 0x7af7,
	/* 0x17221..0x1727E */
	0x7afb, 0x7b06, 0x7b18, 0x7b1a, 0x7b1f, 0x7b22, 0x7b23, 0x7b25,
	0x7b27, 0x7b28, 0x7b29, 0x7b2a, 0x7b2e, 0x7b2f, 0x7b32, 0x7b44,
	0x7b43, 0x7b4f, 0x7b4d, 0x7b4e, 0x7b51, 0x7b58, 0x7b74, 0x7b93,
	0x7b83, 0x7b91, 0x7b96, 0x7b97, 0x7b9f, 0x7ba0, 0x7ba8, 0x7bb4,
	0x7bc0, 0x7bca, 0x7bb9, 0x7bc6, 0x7bcf, 0x7bd1, 0x7bd2, 0x7be3,
	0x7be2, 0x7be4, 0x7bd4, 0x7be1, 0x7c3a, 0x7bf2, 0x7bf1, 0x7bf0,
	0x7c15, 0x7c14, 0x7c09, 0x7c13, 0x7c0c, 0x7c06, 0x7c08, 0x7c12,
	0x7c0a, 0x7c04, 0x7c2e, 0x7c1b, 0x7c25, 0x7c24, 0x7c21, 0x7c30,
	0x7c47, 0x7c32, 0x7c46, 0x7c3e, 0x7c5a, 0x7c60, 0x7c67, 0x7c76,
	0x7c78, 0x7ce7, 0x7cec, 0x7cf0, 0x7d09, 0x7d08, 0x7ceb, 0x7d03,
	0x7d06, 0x7d2a, 0x7d26, 0x7daf, 0x7d23, 0x7d1f, 0x7d44, 0x7d15,
	0x7d12, 0x7d41, 0x7d3f, 0x7d3e, 0x7d46, 0x7d48,
	/* 0x17321..0x1737E */
	0x7d5d, 0x7d5e, 0x7d64, 0x7d51, 0x7d50, 0x7d59, 0x7d72, 0x7d89,
	0x7d87, 0x7dab, 0x7d6f, 0x7d7a, 0x7d9a, 0x7da4, 0x7da9, 0x7db2,
	0x7dc4, 0x7dc1, 0x7dbb, 0x7db8, 0x7dba, 0x7dc6, 0x7dcf, 0x7dc2,
	0x7dd9, 0x7dd3, 0x7df8, 0x7de6, 0x7ded, 0x7def, 0x7dfd, 0x7e1a,
	0x7e1b, 0x7e1e, 0x7e75, 0x7e79, 0x7e7d, 0x7e81, 0x7e88, 0x7e8b,
	0x7e8c, 0x7e92, 0x7e95, 0x7e91, 0x7e9d, 0x7ea5, 0x7ea9, 0x7eb8,
	0x7eaa, 0x7ead, 0x7761, 0x7ecc, 0x7ece, 0x7ecf, 0x7ed0, 0x7ed4,
	0x7edc, 0x7ede, 0x7edd, 0x7ee0, 0x7ee5, 0x7ee8, 0x7eef, 0x7ef4,
	0x7ef6, 0x7ef7, 0x7ef9, 0x7efb, 0x7efc, 0x7efd, 0x7f07, 0x7f08,
	0x56b7, 0x7f15, 0x7f21, 0x7f2c, 0x7f3e, 0x7f4a, 0x7f52, 0x7f54,
	0x7f63, 0x7f5f, 0x7f60, 0x7f61, 0x7f66, 0x7f67, 0x7f6c, 0x7f6a,
	0x7f77, 0x7f72, 0x7f76, 0x7f95, 0x7f9c, 0x7fa0,
	/* 0x17421..0x1747E */
	0x382f, 0x49c7, 0x7059, 0x5464, 0x31dc, 0x5199, 0x3653, 0x3de2,
	0x3e14, 0x3e18, 0x3e58, 0x3e5e, 0x3ebe, 0x8028, 0x3ecb, 0x3ef9,
	0x3f00, 0x3f02, 0x3f07, 0x3f1d, 0x3f23, 0x3f34, 0x3f36, 0x3f3d,
	0x3f40, 0x3f45, 0x3f54, 0x3f58, 0x3f64, 0x3f67, 0x3f7d, 0x3f89,
	0x3f9c, 0x3fa7, 0x3faf, 0x3fb5, 0x3fb7, 0x3fc9, 0x3fde, 0x3fe1,
	0x3fe9, 0x400d, 0x4014, 0x4018, 0x4033, 0x4035, 0x4047, 0x813d,
	0x409d, 0x409e, 0x40cb, 0x40d4, 0x40d5, 0x40dd, 0x40f8, 0x411c,
	0x412b, 0x4130, 0x4137, 0x813e, 0x418d, 0x813f, 0x41bc, 0x41b9,
	0x8140, 0x4222, 0x423e, 0x4243, 0x4256, 0x425a, 0x426f, 0x4285,
	0x42c4, 0x42d6, 0x42fc, 0x430a, 0x4318, 0x4339, 0x4343, 0x4365,
	0x437c, 0x43e5, 0x43ed, 0x43f5, 0x4410, 0x4414, 0x4422, 0x4479,
	0x4451, 0x4460, 0x446d, 0x44ce, 0x44be, 0x44bf,
	/* 0x17521..0x1757E */
	0x44c4, 0x44ca, 0x44d0, 0x44f7, 0x44fb, 0x4522, 0x4529, 0x8141,
	0x4567, 0x459d, 0x8142, 0x4600, 0x4609, 0x4615, 0x461e, 0x463a,
	0x4622, 0x4624, 0x462b, 0x4630, 0x4631, 0x4633, 0x46fb, 0x4648,
	0x464c, 0xa8c4, 0x4659, 0x465a, 0x4661, 0x4665, 0x4673, 0x4677,
	0x4678, 0x468d, 0x8143, 0x46a0, 0x46b2, 0x46bb, 0x46c6, 0x46c8,
	0x1b22, 0x46db, 0x46e8, 0x46fa, 0x4713, 0x8029, 0x4733, 0x4766,
	0x4747, 0x4748, 0x477b, 0x4781, 0x4793, 0x4798, 0x479b, 0x47bb,
	0x47f9, 0x47c0, 0x47d7, 0x47fc, 0x4801, 0x4852, 0x481d, 0x482c,
	0x4831, 0x485b, 0x4872, 0x4875, 0x8144, 0x48a3, 0x48a5, 0x48b2,
	0x48c8, 0x48d0, 0x48e8, 0x48ed, 0x48f0, 0x48f1, 0x48fc, 0x490a,
	0x4949, 0xabc4, 0x4935, 0x4942, 0x4957, 0x4963, 0x4964, 0x4968,
	0x4980, 0x8114, 0x49a5, 0x49ad, 0x49cf, 0x1bb6,
	/* 0x17621..0x1767E */
	0x1bc3, 0x49e2, 0x49e9, 0x49ea, 0x49f5, 0x49f6, 0x4a0f, 0x4a15,
	0xad3f, 0x4a3b, 0x4a3e, 0x4a45, 0x4a50, 0x4a56, 0x4a5b, 0x4a6b,
	0x4a73, 0xad63, 0x4a89, 0x4a94, 0x4a9d, 0x4a9e, 0x4aa5, 0x4ae4,
	0x4ae7, 0x1c0f, 0x801d, 0x4b1b, 0x4b1e, 0x4b2c, 0x4b35, 0x4b46,
	0x4b56, 0x4b60, 0x4b65, 0x4b67, 0x4b77, 0x4b82, 0x4ba9, 0x4bad,
	0x8070, 0x4bcf, 0x4bd6, 0x4bd7, 0x4bff, 0x4c05, 0x4c10, 0x4c33,
	0x4c59, 0x4c5c, 0x4caa, 0x4c74, 0x4c76, 0x4c85, 0x4c86, 0x4c98,
	0x4c9c, 0x4cfb, 0x4cc6, 0x4cd4, 0x4ce0, 0x4ceb, 0x4cee, 0xb0fe,
	0x4d04, 0x4d0e, 0x4d2e, 0x4d31, 0x4d39, 0x4d3f, 0x4d58, 0x4d65,
	0x8145, 0x4d82, 0x4d87, 0x4d89, 0x4d94, 0x4daa, 0x4dac, 0x4dbf,
	0x4dc4, 0x4dd6, 0x4dda, 0x4ddb, 0x4ddd, 0x4dfc, 0x8146, 0x4e34,
	0x4e44, 0x4e5c, 0x4e5e, 0x4eab, 0x4eb1, 0x4ec1,
	/* 0x17721..0x1777E */
	0x4ec7, 0x4ece, 0x4f10, 0x4f1a, 0x8147, 0x4f2a, 0x4f2f, 0x4f33,
	0x4f51, 0x4f59, 0x4f5e, 0x4f61, 0x4f62, 0x4f7e, 0x4f88, 0x4f8c,
	0x4f8d, 0x4f94, 0x4fa0, 0x4fa7, 0x4fb6, 0x4fbc, 0x4fc7, 0x4fca,
	0x4ff9, 0x4ff0, 0x4ff5, 0x5005, 0x5006, 0x5028, 0x504a, 0x505d,
	0x505e, 0x504e, 0x5064, 0x5075, 0x5085, 0x50a4, 0x50ab, 0x50b7,
	0x50d4, 0x50d8, 0x50e4, 0x510f, 0x512b, 0x511e, 0x5120, 0x512e,
	0x5130, 0x5146, 0x5147, 0x5151, 0x8148, 0x5152, 0x515c, 0x5160,
	0x5168, 0x8115, 0x5185, 0x5187, 0x5192, 0x51c1, 0x51ba, 0x51c4,
	0x51fe, 0x5200, 0x5215, 0x5255, 0x5256, 0x1e3f, 0x528d, 0x529b,
	0x52be, 0x52c0, 0x52fb, 0xb7f1, 0x5327, 0x5328, 0x8116, 0x5350,
	0x5366, 0x537c, 0x5395, 0x539f, 0x53a0, 0x53a2, 0x53a6, 0x53ab,
	0x53c9, 0x53cf, 0x53d6, 0x53d9, 0x53e3, 0x53e9,
	/* 0x17821..0x1787E */
	0x5407, 0x540a, 0x541a, 0x541b, 0x814a, 0x5426, 0x5428, 0x542a,
	0x542b, 0x542c, 0x542e, 0x542f, 0x5430, 0x5444, 0x5446, 0x5447,
	0x544b, 0x5457, 0x5462, 0x546b, 0x546d, 0x5486, 0x5487, 0x5489,
	0x5498, 0x549c, 0x549f, 0x54a3, 0x5490, 0x54a6, 0x54a8, 0x54a9,
	0x54b5, 0x54bf, 0x54c8, 0x54c9, 0x54da, 0x54ff, 0x5501, 0x5517,
	0x552f, 0x556f, 0x5579, 0x5592, 0x1f72, 0x55ce, 0x55e4, 0x5600,
	0x5602, 0x5608, 0x5615, 0x5616, 0x5619, 0x561e, 0x562d, 0x5635,
	0x5643, 0x564b, 0x5664, 0x5665, 0x566d, 0x566f, 0x5671, 0x5681,
	0x569b, 0x569d, 0x569e, 0x56a6, 0x56aa, 0x56b6, 0x56c5, 0x56cc,
	0x56ce, 0x56d4, 0x56e6, 0x56f1, 0x56fc, 0x570a, 0x5719, 0x5734,
	0x5736, 0x5746, 0x574d, 0x574e, 0x575c, 0x575f, 0x5762, 0x577a,
	0x5780, 0x5794, 0x57aa, 0x57e0, 0x582d, 0xc18e,
	/* 0x17921..0x1797E */
	0x5843, 0x584e, 0x584f, 0x5851, 0x5868, 0x586e, 0x814b, 0x58b0,
	0xc20e, 0x58ad, 0x58e4, 0x58f2, 0x5900, 0x58f7, 0x591c, 0x592e,
	0x5931, 0x5934, 0x814c, 0x814d, 0x5945, 0x5946, 0x814e, 0x814f,
	0x8150, 0x595c, 0x8151, 0x8119, 0x811a, 0x5979, 0x8152, 0x8153,
	0x811b, 0x5998, 0x59b1, 0x59b8, 0x59c8, 0x59ca, 0xc371, 0x59d4,
	0x59de, 0x59eb, 0x59ed, 0x5a03, 0x8154, 0x5a39, 0x5a5d, 0x5a6d,
	0x8155, 0x5a85, 0x5aa0, 0xc4c4, 0x5ab3, 0x5abb, 0x5ace, 0x5aeb,
	0x5afd, 0x5b12, 0x5b2d, 0x5b3b, 0x5b47, 0x5b4e, 0x5b60, 0x5b6d,
	0x5b6f, 0x5b72, 0x5b9e, 0x8156, 0x5bd7, 0x5bd9, 0x5c01, 0x5c31,
	0x5c1e, 0x5c20, 0x5c33, 0x5c36, 0x2264, 0xc7a1, 0x5c59, 0x5c6d,
	0x5c79, 0x5c8f, 0x5c94, 0x5ca0, 0x5cbc, 0x5cd5, 0x5cd9, 0x5cdd,
	0x5d07, 0x5d08, 0x5d13, 0x5d1d, 0x5d23, 0x5d31,
	/* 0x17A21..0x17A7E */
	0x5d41, 0x5d48, 0x5d53, 0x5d5c, 0x5d7a, 0x5d83, 0x5d8b, 0x5da0,
	0x5da6, 0x5dc2, 0x5dcc, 0x5dd6, 0x5de3, 0x8157, 0x5e28, 0x5e08,
	0x5e11, 0x5e15, 0x8159, 0x5e47, 0x5e52, 0x5e61, 0x5e8a, 0x5e8d,
	0x5f47, 0x815a, 0x5f91, 0x5f97, 0x5fbf, 0x5fce, 0x5fdb, 0x5fdf,
	0x5fec, 0x5fee, 0x5ffa, 0x815b, 0x6014, 0x6026, 0x6035, 0x6037,
	0x603c, 0x60ca, 0x60d7, 0x60e0, 0x60f3, 0x6118, 0x614a, 0x6160,
	0x6167, 0x6168, 0x616d, 0x61bb, 0x61ca, 0x61cf, 0x61d7, 0x815c,
	0x2453, 0x245b, 0x6260, 0x6274, 0xd2ff, 0x628e, 0x62a1, 0x62a3,
	0x62a4, 0x62a9, 0x62ae, 0x62b7, 0x62be, 0x62bf, 0x62c6, 0x62d5,
	0x62fd, 0x62fe, 0x6300, 0x6301, 0x6362, 0x6322, 0x632d, 0x633a,
	0x6343, 0x6347, 0x6351, 0x6355, 0x637d, 0x6386, 0x6392, 0x6398,
	0x63a7, 0x63a9, 0x63bf, 0x63c0, 0x63c7, 0x63cf,
	/* 0x17B21..0x17B7E */
	0x63d1, 0x63e1, 0x63ea, 0x6401, 0x6406, 0x640a, 0x815f, 0x6448,
	0x645f, 0x6470, 0x6473, 0x6485, 0x649e, 0x64af, 0x64b4, 0x64ba,
	0x64c0, 0x64c2, 0xd440, 0x6532, 0x651e, 0x6523, 0x652f, 0x6559,
	0x6564, 0x811f, 0x65ad, 0x657a, 0x658c, 0x658f, 0x65a2, 0x65b0,
	0x65cb, 0x65ce, 0x65ed, 0x6612, 0x65ff, 0x6604, 0x6605, 0x6610,
	0xd674, 0x6618, 0x6629, 0x6638, 0x6657, 0x665b, 0x8036, 0x6662,
	0x259d, 0x666c, 0x6675, 0x6698, 0x66b8, 0x66fa, 0x66fc, 0x66fd,
	0x670b, 0x6771, 0x6787, 0x6788, 0x67ac, 0x67ad, 0x67b5, 0x25ea,
	0x67d6, 0x67ec, 0x6806, 0x680a, 0x6810, 0x6814, 0x681f, 0x6898,
	0x68aa, 0x68ca, 0x68ce, 0xd884, 0x68f5, 0x691c, 0x8160, 0x6918,
	0x6919, 0x691a, 0x6927, 0x6930, 0x6932, 0x6939, 0x6940, 0x6994,
	0x8161, 0x69d4, 0x69e5, 0x69f6, 0x6a12, 0x6a15,
	/* 0x17C21..0x17C7E */
	0x6a22, 0x6a37, 0x6a47, 0x6a4e, 0x6a5d, 0x6a61, 0x6a75, 0x6a79,
	0x6aa7, 0x6ad0, 0x6adf, 0x6af4, 0x6af6, 0x8122, 0x8162, 0x8163,
	0x6b46, 0x6b54, 0x6b59, 0x6b69, 0x6b9d, 0x6c49, 0x6c68, 0x8164,
	0x6ce1, 0x6cf4, 0x6cf8, 0x6cfe, 0x8165, 0x6d12, 0x6d1b, 0x6daf,
	0x6dce, 0x6dd1, 0x6dd7, 0x6e20, 0x6e23, 0x6e3d, 0x6e70, 0x6e7b,
	0xe177, 0x6ec0, 0x2844, 0x6efa, 0x6f1e, 0x6f2d, 0x6f36, 0x6f54,
	0xe24d, 0x6fa6, 0x6fb5, 0x6fe4, 0x6fe8, 0x6fee, 0x7008, 0x702d,
	0x8167, 0x7088, 0x7095, 0x7097, 0x7099, 0x709b, 0x70a2, 0x70b3,
	0x70be, 0x70c4, 0x70c5, 0x70c7, 0x70d7, 0x70dd, 0x70de, 0x70ef,
	0x70f4, 0x8126, 0x7114, 0x7115, 0x7116, 0x7122, 0x7123, 0x7127,
	0x712f, 0x7131, 0x7134, 0x713d, 0x7148, 0x715b, 0x7183, 0x719e,
	0x71ac, 0x71b1, 0x71bc, 0x71d7, 0x71fb, 0x71e4,
	/* 0x17D21..0x17D7E */
	0x71e5, 0x71ed, 0x71f1, 0x7207, 0x7210, 0x7238, 0x7239, 0x723a,
	0x723c, 0x7240, 0x7243, 0x724f, 0x7278, 0x7288, 0x72c2, 0x72cb,
	0x72cc, 0x72d3, 0x72e0, 0x72ff, 0x7304, 0x731f, 0x7321, 0x7325,
	0x7348, 0x7349, 0x734a, 0x7364, 0x7365, 0x736a, 0x7370, 0x739b,
	0x73a3, 0x73ba, 0x73c6, 0x73de, 0x73df, 0x7404, 0x73fd, 0x7433,
	0x744a, 0x7463, 0x746b, 0x7471, 0x7472, 0x758e, 0x759f, 0x75a6,
	0x75a9, 0x75ac, 0x75b6, 0x75bd, 0x75cb, 0x75d0, 0x75d3, 0x29b0,
	0x75da, 0x75de, 0x7658, 0x7684, 0x80dc, 0x769d, 0x76a4, 0x76a5,
	0x76d2, 0x76de, 0x8168, 0x76e9, 0x76ef, 0x7733, 0x773b, 0x774d,
	0x774e, 0x774f, 0x775a, 0x776e, 0x7773, 0x7795, 0x77ae, 0x77ba,
	0x77c1, 0x77c9, 0x77de, 0x77db, 0x77f4, 0x8169, 0x780a, 0x781e,
	0x782b, 0x7830, 0x816a, 0x7852, 0x7853, 0x7856,
	/* 0x17E21..0x17E7E */
	0x7857, 0x7859, 0x785a, 0x80d0, 0x7865, 0x786c, 0x78ba, 0x78c8,
	0x78e7, 0x7958, 0x799e, 0x7a02, 0x7a03, 0x7a24, 0x7a2d, 0x7a2e,
	0x7a38, 0x7a4a, 0x7a4e, 0x7a52, 0x7ab6, 0x7ac1, 0x7ac3, 0x7ace,
	0x7ad6, 0x7af9, 0x7b02, 0x7b08, 0x7b20, 0x2c17, 0x7b2d, 0x7b5e,
	0x7b79, 0x7b66, 0x7b72, 0x7b75, 0x7b84, 0x7b8a, 0x7b8f, 0x7b9e,
	0x7ba7, 0x7bc1, 0x7bce, 0x7be5, 0x7bf8, 0x7bfd, 0x7c00, 0x7c23,
	0x7c41, 0x7c4f, 0x7c50, 0x7c53, 0x7c63, 0x7c65, 0x7c77, 0x7d1d,
	0x7d1e, 0x7d43, 0x7d47, 0x7d52, 0x7d63, 0x7d70, 0x7d7c, 0x7d8a,
	0x7d96, 0x7dc0, 0x7dac, 0x7dbc, 0x7dd7, 0xf690, 0x7de7, 0x7e07,
	0x7e15, 0x7e7c, 0x7e9e, 0x7ea4, 0x7eac, 0x7eaf, 0x7eb4, 0x7eb5,
	0x7ec3, 0x7ed1, 0x7f10, 0x7f39, 0x7f57, 0x7f90, 0x7f94, 0x7f97,
	0x7fa2, 0x39f8, 0x3c5b, 0x3e77, 0x5626, 0x5e6b
};

// This table is a copy of the table of the same name in
// libiconv's jisx0213.h
static const uint32 jisx0213_to_ucs_pagestart[] = {
	0x0000,  0x0100,  0x0200,  0x0300,  0x0400,  0x1e00,  0x1f00,  0x2000,
	0x2100,  0x2200,  0x2300,  0x2400,  0x2500,  0x2600,  0x2700,  0x2900,
	0x3000,  0x3100,  0x3200,  0x3300,  0x3400,  0x3500,  0x3600,  0x3700,
	0x3800,  0x3900,  0x3a00,  0x3b00,  0x3c00,  0x3d00,  0x3e00,  0x3f00,
	0x4000,  0x4100,  0x4200,  0x4300,  0x4400,  0x4500,  0x4600,  0x4700,
	0x4800,  0x4900,  0x4a00,  0x4b00,  0x4c00,  0x4d00,  0x4e00,  0x4f00,
	0x5000,  0x5100,  0x5200,  0x5300,  0x5400,  0x5500,  0x5600,  0x5700,
	0x5800,  0x5900,  0x5a00,  0x5b00,  0x5c00,  0x5d00,  0x5e00,  0x5f00,
	0x6000,  0x6100,  0x6200,  0x6300,  0x6400,  0x6500,  0x6600,  0x6700,
	0x6800,  0x6900,  0x6a00,  0x6b00,  0x6c00,  0x6d00,  0x6e00,  0x6f00,
	0x7000,  0x7100,  0x7200,  0x7300,  0x7400,  0x7500,  0x7600,  0x7700,
	0x7800,  0x7900,  0x7a00,  0x7b00,  0x7c00,  0x7d00,  0x7e00,  0x7f00,
	0x8000,  0x8100,  0x8200,  0x8300,  0x8400,  0x8500,  0x8600,  0x8700,
	0x8800,  0x8900,  0x8a00,  0x8b00,  0x8c00,  0x8d00,  0x8e00,  0x8f00,
	0x9000,  0x9100,  0x9200,  0x9300,  0x9400,  0x9500,  0x9600,  0x9700,
	0x9800,  0x9900,  0x9a00,  0x9b00,  0x9c00,  0x9d00,  0x9e00,  0x9f00,
	0xf900,  0xfa00,  0xfe00,  0xff00, 0x20000, 0x20180, 0x20300, 0x20400,
	0x20500, 0x20600, 0x20700, 0x20800, 0x20900, 0x20a00, 0x20b00, 0x20d00,
	0x20e00, 0x20f00, 0x21200, 0x21300, 0x21400, 0x21500, 0x21600, 0x21700,
	0x21800, 0x21900, 0x21c00, 0x21d00, 0x21e00, 0x21f00, 0x22100, 0x22200,
	0x22300, 0x22600, 0x22800, 0x22900, 0x22a00, 0x22b00, 0x22c00, 0x22d00,
	0x23100, 0x23300, 0x23400, 0x23500, 0x23600, 0x23700, 0x23800, 0x23a00,
	0x23c00, 0x23d00, 0x23f00, 0x24000, 0x24100, 0x24300, 0x24600, 0x24700,
	0x24800, 0x24a00, 0x24b00, 0x24c00, 0x24d00, 0x24e00, 0x25000, 0x25100,
	0x25200, 0x25400, 0x25500, 0x25700, 0x25900, 0x25a00, 0x25b80, 0x25d00,
	0x25e00, 0x25f00, 0x26000, 0x26200, 0x26300, 0x26400, 0x26600, 0x26700,
	0x26800, 0x26900, 0x26a00, 0x26c00, 0x26e00, 0x26f00, 0x27080, 0x27380,
	0x27600, 0x27700, 0x27900, 0x27a00, 0x27b00, 0x27c00, 0x27d80, 0x27f00,
	0x28000, 0x28200, 0x28380, 0x28500, 0x28600, 0x28900, 0x28a00, 0x28b00,
	0x28d00, 0x28e00, 0x28f00, 0x29200, 0x29400, 0x29500, 0x29600, 0x29700,
	0x29800, 0x29a00, 0x29d00, 0x29e00, 0x29f00, 0x2a000, 0x2a100, 0x2a380,
	0x2a500, 0x2a600,
};




// Convert Shift_JIS to a JISX0208 (or maybe JISX0213?) row/column pair.
// This function assumes the low ASCII characters have already been handled.
// NB: This is not a full Shift_JIS decoder. It only decodes the
// first 79 JIS rows.
static inline bool shiftjis_to_JISX(uint16 sjis, uint8 &jr, uint8 &jc) {
	// Step 1: extract two bytes

	uint8 s1 = sjis & 0xFF;
	uint8 s2 = sjis >> 8;

	// Step 2: ignore everything past the level 1 kanji from JIS X 0208

	if (s1 > 0x98) return false;

	// Step 3: decode Shift_JIS to JIS X 0208 codepoints
	// jr is the JIS row, jc the JIS column
	// NB: This is not a full Shift_JIS decoder. It only decodes the
	// first 79 JIS rows.

	jr = 2 * (s1 - 112) - 1;
	if (s2 > 157) {
		jc = s2 - 126;
		jr++;
	} else {
		jc = s2 - 31 - (s2 >> 7);
	}
	return true;
}

uint16 shiftjis_to_ultima8(uint16 sjis) {
	if ((sjis & 0xFF) < 0x80) return (sjis & 0xFF);

	uint8 jr, jc;
	if (!shiftjis_to_JISX(sjis, jr, jc)) return 0;

	// Map JISX rows into U8's font encoding

	if (jr == 33) {
		return (257 - 34 + jc); // symbols
	} else if (jr == 35) {
		return (365 - 48 + jc); // latin
	} else if (jr == 36) {
		return (444 - 33 + jc); // hiragana
	} else if (jr == 37) {
		return (538 - 33 + jc); // katakana
	} else if (jr >= 48 && jr <= 79) {
		return (632 - 33 + (jr - 48) * 94 + jc); // kanji
	} else {
		return 0;
	}
}

uint32 shiftjis_to_unicode(uint16 sjis) {
	if ((sjis & 0xFF) < 0x80) return (sjis & 0xFF);

	uint8 jr, jc;
	if (!shiftjis_to_JISX(sjis, jr, jc)) return 0;

	// Map JISX rows to unicode

	uint32 val = jisx0213_to_ucs_main[(jr - 33) * 94 + (jc - 33)];
	val = jisx0213_to_ucs_pagestart[val >> 8] + (val & 0xff);

	if (val == 0xfffd)
		val = 0x0000;
	return val;
}

} // End of namespace Ultima8
} // End of namespace Ultima
