// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) INRIA
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.


function cmap = hotcolormap(varargin)
    //graycmap   yellow to red color map.

    // Check number of input argument
    if size(varargin)<>1 then
        error(msprintf(gettext("%s: Wrong number of input argument(s): %d expected.\n"), "hotcolormap", 1));
    end
    n=varargin(1);

    // Check type of input argument
    // Check if input argument is real
    if typeof(n)<>"constant" | ~isreal(n) then
        error(msprintf(gettext("%s: Wrong type for input argument #%d: a real scalar expected.\n"), "hotcolormap", 1));
    end

    // Check size of input argument
    if size(n,"*")<>1 then
        error(msprintf(gettext("%s: Wrong size for input argument #%d: a real scalar expected.\n"), "hotcolormap", 1));
    end

    n1=fix(3/8*n);
    n2=n1
    n3=n-(n1+n2)
    //
    cmap=[(1:n1)'/n1  zeros(n1,1)  zeros(n1,1);
    ones(n2,1)  (1:n2)'/n2   zeros(n2,1);
    ones(n3,1)  ones(n3,1)   (1:n3)'/(n3)]

endfunction
