#!/bin/bash
# bbou@ac-toulouse.fr
# 2005-07-10 09:44:34  
# _cat-conf.sh

### I N C L U D E

. ./_include.sh

### OTHER

services=${PAMSERVICES}

### S T A R T 

echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "configuration files"
echo "-------------------------------------------------------------------------------"

function logTail()
{
	from=`grep -n "sadms start" /var/log/messages | tail -n 1 | cut -d ':' -f 1`
	to=`grep -n "sadms finish" /var/log/messages | tail -n 1 | cut -d ':' -f 1`
	if [ "${from}" == "" ]; then
		return
	fi
	echo "log extract (${from}-${to})"
	if [ "${to}" == "" ]; then
		to=-1
	fi
	echo 'vvvvv'
	awk 'BEGIN{i=0} \
		{ \
			if(i>=p-1 && (q==-1 || i<=q-1)) \
			{ \
				printf("%d-%s\n",i,$0) \
			} \
			i++; \
		}' "p=${from}" "q=${to}" /var/log/messages
	echo '^^^^^'
}

conffiles="${ETCDIR}/nsswitch.conf ${ETCDIR}/krb5.conf ${SAMBADIR}/smb.conf ${SAMBADIR}/user.map"
for f in ${conffiles}; do
	echo "--------------------------------------------------------------------------------"
	echo "#[${f}]"
	echo ""
	if [ -f ${f} ]; then
		cat ${f} | grep -v "^[[:space:]]*#" | grep -v "^[[:space:]]*;" | grep -v "^[[:space:]]*$" | sed 's/[[:space:]][[:space:]]*/ /g'
	else
		echo "<non existent>"
	fi
done

echo "--------------------------------------------------------------------------------"
logTail
