<a href="https://www.qlcplus.org/">
    <img src="resources/icons/png/qlcplus.png" alt="QLC Logo" title="qlcplus.png" align="right" height="60" />
</a>

# Q Light Controller Plus
[![GitHub release](https://img.shields.io/github/v/release/mcallegari/qlcplus)
![GitHub Release Date - Published_At](https://img.shields.io/github/release-date/mcallegari/qlcplus)](https://github.com/mcallegari/qlcplus/releases/latest)

https://www.qlcplus.org/download

## Introduction
QLC+ is powerful and user-friendly software designed to control lighting. Whether you're an experienced lighting professional or just getting started, QLC+ empowers you to take control of your lighting fixtures with ease. The primary goal of this project is to bring QLC+ to the level of available commercial software. 
QLC+ runs on Linux, Windows (7+), macOS (10.7+) and the Raspberry Pi.

Copyright © Heikki Junnila, Massimo Callegari
### Supported Protocols
[![MIDI](https://img.shields.io/badge/MIDI-%23323330.svg?style=for-the-badge&logo=midi&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/midi)
[![OSC](https://img.shields.io/badge/OSC-%23323330.svg?style=for-the-badge&logo=aiohttp&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/osc)
[![HID](https://img.shields.io/badge/HID-%23323330.svg?style=for-the-badge&logo=applearcade&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/hid)
[![DMX](https://img.shields.io/badge/DMX-%23323330.svg?style=for-the-badge&logo=amazonec2&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/dmx-usb)
[![ArtNet](https://img.shields.io/badge/ArtNet-%23323330.svg?style=for-the-badge&logo=aiohttp&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/art-net)
[![E1.31/S.ACN](https://img.shields.io/badge/E1.31%20S.ACN-%23323330.svg?style=for-the-badge&logo=aiohttp&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/e1-31-sacn)
[![OS2L](https://img.shields.io/badge/OS2L-%23323330.svg?style=for-the-badge&logo=aiohttp&logoColor=%23F7DF1E)](https://docs.qlcplus.org/v4/plugins/os2l)

### Key Resources
<table>
<thead>
</thead>
<tbody>
<tr>
<td style="text-align:right">Home Page</td>
<td style="text-align:left"><a href="https://qlcplus.org"><img src="https://img.shields.io/badge/qlcplus.org-blue?logo=grav" alt="Static Badge"></a></td>
</tr>
<tr>
<td style="text-align:right">Documentation</td>
<td style="text-align:left"><a href="https://docs.qlcplus.org"><img src="https://img.shields.io/badge/docs.qlcplus.org-blue?logo=grav" alt="Static Badge"></a></td>
</tr>
<tr>
<td style="text-align:right">Official Forum</td>
<td style="text-align:left"><a href="https://qlcplus.org/forum/"><img src="https://img.shields.io/badge/qlcplus.org/forum-grey?logo=php" alt="Static Badge"></a></td>
</tr>
<tr>
<td style="text-align:right">GitHub Sponsorship</td>
<td style="text-align:left"><img src="https://img.shields.io/github/sponsors/mcallegari" alt="GitHub Sponsors"> <a href="https://github.com/sponsors/mcallegari"><img src="https://img.shields.io/badge/sponsor-30363D?logo=GitHub-Sponsors&logoColor=#white" /></a></td>
</tr>
<tr>
<td style="text-align:right">Official Merch</td>
<td style="text-align:left"><a href="https://merch.qlcplus.org"><img src="https://img.shields.io/badge/merch.qlcplus.org-Official_Merchandice-green?logo=shopify" alt="Static Badge"></a></td>
</tr>
</tbody>
</table>

### QLC+ Social Media

[![Instagram](https://img.shields.io/badge/Instagram-%23E4405F.svg?style=for-the-badge&logo=Instagram&logoColor=white)](https://www.instagram.com/qlcplus/) [![YouTube](https://img.shields.io/badge/YouTube-%23FF0000.svg?style=for-the-badge&logo=YouTube&logoColor=white)](https://www.youtube.com/watch?v=I9bccwcYQpM&list=PLHT-wIriuitDiW4A9oKSDr__Z_jcmMVdi) [![Facebook](https://img.shields.io/badge/Facebook-%231877F2.svg?style=for-the-badge&logo=Facebook&logoColor=white)](https://www.facebook.com/qlcplus)

## Contributing
We welcome contributions from the community to help make QLC+ even better. Before diving into coding, we encourage you to start a discussion in our [Software Development](https://www.qlcplus.org/forum/viewforum.php?f=12) forum if you're considering adding a new feature or making significant changes. This provides an opportunity for feedback, collaboration, and ensuring alignment with the project's goals.

Further guidelines are available in the [CONTRIBUTING.md](CONTRIBUTING.md) document.

### Help wanted
Click the badge below to see the currently confirmed issues with QLC+. Perhaps you can find a solution?

[![GitHub issues by-label](https://img.shields.io/github/issues/mcallegari/qlcplus/issue%20confirmed?logo=github&color=red)](https://github.com/mcallegari/qlcplus/issues?q=is%3Aopen+is%3Aissue+label%3A%22issue+confirmed%22)

### 🚧 Developers at work 🚧

If you're regularly updating QLC+ sources with git pull, you may encounter compiler warnings, errors, or unresolved symbols. This is because the source package is still in development. We strive to keep the GIT master branch free of critical errors; However, dependencies between objects can sometimes cause issues, requiring a full package recompilation rather than just updating recent changes.

[![QLC+ Github Actions CI Build](https://github.com/mcallegari/qlcplus/actions/workflows/build.yml/badge.svg)](https://github.com/mcallegari/qlcplus/actions) [![Coverage Status](https://coveralls.io/repos/github/mcallegari/qlcplus/badge.svg?branch=master)](https://coveralls.io/github/mcallegari/qlcplus?branch=master)
[![GitHub commits since latest release (by SemVer including pre-releases)](https://img.shields.io/github/commits-since/mcallegari/qlcplus/latest/master)](https://github.com/mcallegari/qlcplus/commits/master/) ![GitHub commit activity (branch)](https://img.shields.io/github/commit-activity/w/mcallegari/qlcplus) 

## Compiling and installation

Please refer to the online wiki pages: https://github.com/mcallegari/qlcplus/wiki
## Requirements
### Linux

*   Qt >= 5.0 development libraries & tools
*   libudev-dev, libmad0-dev, libsndfile1-dev, libfftw3-dev
*   DMX USB plugin: libftdi-dev, pkg-config
*   MIDI plugin: libasound, libasound-dev, pkg-config
*   OLA plugin: libola, ola-dev, pkg-config (see libs/olaout/README)
*   uDMX plugin: libusb, libusb-dev, pkg-config
*   Peperoni plugin: libusb, libusb-dev, pkg-config
*   Velleman plugin: **Not available**

### Windows

*   MSYS2 environment (https://msys2.github.io/)
*   DMX USB plugin: D2XX driver & development package (http://www.ftdichip.com/Drivers/D2XX.htm)
*   ENTTEC Wing plugin: D2XX driver & development package (http://www.ftdichip.com/Drivers/D2XX.htm)
*   OLA plugin: **Not available**
*   Velleman plugin: K8062 SDK from www.velleman.eu

### Mac OS X

*   XCode (http://developer.apple.com/technologies/tools/xcode.html)
*   Qt >= 5.0.x (http://download.qt.io/official_releases/qt/)
*   macports (https://www.macports.org/)
*   DMX USB plugin: macports, libftdi-dev, pkg-config
*   OLA plugin: libola, ola-dev, pkg-config (see libs/olaout/README)
*   uDMX plugin: macports, libusb-compat, pkg-config
*   Peperoni plugin: macports, libusb-compat, pkg-config
*   Velleman plugin: **Not available**

## Support & Bug Reports

For discussions, feedbacks, ideas and new fixtures, go to:
https://www.qlcplus.org/forum/index.php

For developers wiki and code patches, go to:
https://github.com/mcallegari/qlcplus

## Contributors

QLC+ owes its success to the dedication and expertise of numerous individuals who have generously contributed their time and skills. The following list recognizes those whose remarkable contributions have played a pivotal role in shaping QLC+ into what it is today.

![GitHub contributors](https://img.shields.io/github/contributors/mcallegari/qlcplus)
### QLC+ 5

*   Eric Arnebäck (3D preview features)
*   Santiago Benejam Torres (Catalan translation)
*   Luis García Tornel (Spanish translation)
*   Nils Van Zuijlen, Jérôme Lebleu (French translation)
*   Felix Edelmann, Florian Edelmann (fixture definitions, German translation)
*   Jannis Achstetter (German translation)
*   Dai Suetake (Japanese translation)
*   Hannes Bossuyt (Dutch translation)
*   Aleksandr Gusarov (Russian translation)
*   Vadim Syniuhin (Ukrainian translation)
*   Mateusz Kędzierski (Polish translation)

### QLC+ 4

*   Jano Svitok (bugfix, new features and improvements)
*   David Garyga (bugfix, new features and improvements)
*   Lukas Jähn (bugfix, new features)
*   Robert Box (fixtures review)
*   Thomas Achtner (ENTTEC wing improvements)
*   Joep Admiraal (MIDI SysEx init messages, Dutch translation)
*   Florian Euchner (FX5 USB DMX support)
*   Stefan Riemens (new features)
*   Bartosz Grabias (new features)
*   Simon Newton, Peter Newman (OLA plugin)
*   Janosch Frank (webaccess improvements)
*   Karri Kaksonen (DMX USB Eurolite USB DMX512 Pro support)
*   Stefan Krupop (HID DMXControl Projects e.V. Nodle U1 support)
*   Nathan Durnan (RGB scripts, new features)
*   Giorgio Rebecchi (new features)
*   Florian Edelmann (code cleanup, German translation)
*   Heiko Fanieng, Jannis Achstetter (German translation)
*   NiKoyes, Jérôme Lebleu, Olivier Humbert, Nils Van Zuijlen (French translation)
*   Raymond Van Laake (Dutch translation)
*   Luis García Tornel (Spanish translation)
*   Jan Lachman (Czech translation)
*   Nuno Almeida, Carlos Eduardo Porto de Oliveira (Portuguese translation)
*   Santiago Benejam Torres (Catalan translation)
*   Koichiro Saito, Dai Suetake (Japanese translation)

### Q Light Controller

*   Stefan Krumm (Bugfixes, new features)
*   Christian Suehs (Bugfixes, new features)
*   Christopher Staite (Bugfixes)
*   Klaus Weidenbach (Bugfixes, German translation)
*   Lutz Hillebrand (uDMX plugin)
*   Matthew Jaggard (Velleman plugin)
*   Ptit Vachon (French translation)

<a href="https://github.com/mcallegari/qlcplus/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=mcallegari/qlcplus" />
</a>

## Apache 2.0
![GitHub License](https://img.shields.io/github/license/mcallegari/qlcplus)

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.

----
![C++](https://img.shields.io/badge/c++-%2300599C.svg?style=for-the-badge&logo=c%2B%2B&logoColor=white) ![Qt](https://img.shields.io/badge/Qt-%23217346.svg?style=for-the-badge&logo=Qt&logoColor=white) ![CMake](https://img.shields.io/badge/CMake-%23008FBA.svg?style=for-the-badge&logo=cmake&logoColor=white) ![JavaScript](https://img.shields.io/badge/javascript-%23323330.svg?style=for-the-badge&logo=javascript&logoColor=%23F7DF1E)
