<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/openldap/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/openldap/metadata.yaml"
sidebar_label: "OpenLDAP"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Authentication and Authorization"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# OpenLDAP


<img src="https://netdata.cloud/img/openldap.svg" width="150"/>


Plugin: go.d.plugin
Module: openldap

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors OpenLDAP metrics about connections, operations, referrals and more.


It gathers the metrics using the [go-ldap](https://github.com/go-ldap/ldap) module and the [Monitor backend](https://www.openldap.org/doc/admin24/monitoringslapd.html) of OpenLDAP.


This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

The collector cannot auto-detect OpenLDAP instances, because credential configuration is required.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per OpenLDAP instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| openldap.current_connections | active | connections |
| openldap.connections | connections | connections/s |
| openldap.traffic | sent | bytes/s |
| openldap.entries | sent | entries/s |
| openldap.referrals | sent | referrals/s |
| openldap.operations | completed, initiated | operations/s |
| openldap.operations_by_type | bind, search, unbind, add, delete, modify, compare | operations/s |
| openldap.waiters | write, read | waiters/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable the openLDAP Monitor Backend.

Follow instructions from https://www.openldap.org/doc/admin24/monitoringslapd.html to activate monitoring interface.



### Configuration

#### File

The configuration file name for this integration is `go.d/openldap.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/openldap.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| timeout | Timeout for establishing a connection and communication (reading and writing) in seconds. | 2 | no |
| url | LDAP server URL. | ldap://127.0.0.1:389 | yes |
| username | The distinguished name (DN) of the user authorized to view the monitor database. |  | yes |
| password | The password associated with the user identified by the DN. |  | yes |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
jobs:
  - name: local
    url: ldap://localhost:389
    username: cn=netdata,dc=example,dc=com 
    password: secret

```
##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


```yaml
jobs:
  - name: local
    url: ldap://localhost:389
    username: cn=netdata,dc=example,dc=com 
    password: secret

  - name: remote
    url: ldap://192.0.2.1:389
    username: cn=netdata,dc=example,dc=com 
    password: secret

```


## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `openldap` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m openldap
  ```

### Getting Logs

If you're encountering problems with the `openldap` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep openldap
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep openldap /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep openldap
```


