<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/litespeed/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/litespeed/metadata.yaml"
sidebar_label: "Litespeed"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Web Servers and Web Proxies"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Litespeed


<img src="https://netdata.cloud/img/litespeed.svg" width="150"/>


Plugin: go.d.plugin
Module: litespeed

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Examine Litespeed metrics for insights into web server operations. Analyze request rates, response times, and error rates for efficient web service delivery.

The collector uses the statistics under /tmp/lshttpd to gather the metrics.

This collector is only supported on the following platforms:

- Linux
- BSD

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

If no configuration is present, the collector will attempt to read files under /tmp/lshttpd/.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Litespeed instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| litespeed.requests | requests | requests/s |
| litespeed.requests_processing | processing | requests |
| litespeed.net_throughput | in, out | kilobits/s |
| litespeed.net_ssl_throughput | in, out | kilobits/s |
| litespeed.connections | free, used | conns |
| litespeed.ssl_connections | free, used | conns |
| litespeed.public_cache | hits | hits/s |
| litespeed.private_cache | hits | hits/s |
| litespeed.static | hits | hits/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/litespeed.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/litespeed.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| reports_dir | Directory containing Litespeed's real-time statistics files. | /tmp/lshttpd/ | no |

</details>

#### Examples

##### Set the path to statistics

Change the path for the litespeed stats files

```yaml
local:
 name: 'local'
 path: '/tmp/lshttpd'

```


## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `litespeed` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m litespeed
  ```

### Getting Logs

If you're encountering problems with the `litespeed` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep litespeed
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep litespeed /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep litespeed
```


