<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/httpcheck/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/httpcheck/metadata.yaml"
sidebar_label: "HTTP Endpoints"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# HTTP Endpoints


<img src="https://netdata.cloud/img/globe.svg" width="150"/>


Plugin: go.d.plugin
Module: httpcheck

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors HTTP servers availability status and response time.

Possible statuses:

| Status        | Description                                                                                                                                                                                  |
|---------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| success       | HTTP request completed successfully with a status code matching the configured `status_accepted` range (default: 200), and the response body and headers (if configured) match expectations. |
| timeout       | HTTP request timed out before receiving a response (default: 1 second).                                                                                                                      |
| no_connection | Failed to establish a connection to the target.                                                                                                                                              |
| redirect      | Received a redirect response (3xx status code) while `not_follow_redirects` is configured.                                                                                                   |
| bad_status    | HTTP request completed with a status code outside the configured `status_accepted` range (default: non-200).                                                                                 |
| bad_content   | HTTP request completed successfully but the response body does not match the expected content (when using `response_match`).                                                                 |
| bad_header    | HTTP request completed successfully but response headers do not match the expected values (when using `headers_match`).                                                                      |




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per target

The metrics refer to the monitored target.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| url | url value that is set in the configuration file. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| httpcheck.response_time | time | ms |
| httpcheck.response_length | length | characters |
| httpcheck.status | success, timeout, redirect, no_connection, bad_content, bad_header, bad_status | boolean |
| httpcheck.in_state | time | boolean |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/httpcheck.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/httpcheck.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. |  | yes |
| status_accepted | HTTP accepted response statuses. Anything else will result in 'bad status' in the status chart. | [200] | no |
| response_match | If the status code is accepted, the content of the response will be matched against this regular expression. |  | no |
| headers_match | This option defines a set of rules that check for specific key-value pairs in the HTTP headers of the response. | [] | no |
| headers_match.exclude | This option determines whether the rule should check for the presence of the specified key-value pair or the absence of it. | no | no |
| headers_match.key | The exact name of the HTTP header to check for. |  | yes |
| headers_match.value | The [pattern](https://github.com/netdata/netdata/tree/master/src/go/pkg/matcher#supported-format) to match against the value of the specified header. |  | no |
| cookie_file | Path to cookie file. See [cookie file format](https://everything.curl.dev/http/cookies/fileformat). |  | no |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080

```
</details>

##### With HTTP request headers

Configuration with HTTP request headers that will be sent by the client.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080
    headers:
      Host: localhost:8080
      User-Agent: netdata/go.d.plugin
      Accept: */*

```
</details>

##### With `status_accepted`

A basic example configuration with non-default status_accepted.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080
    status_accepted:
      - 200
      - 204

```
</details>

##### With `header_match`

Example configurations with `header_match`. See the value [pattern](https://github.com/netdata/netdata/tree/master/src/go/pkg/matcher#supported-format) syntax.

<details open><summary>Config</summary>

```yaml
jobs:
    # The "X-Robots-Tag" header must be present in the HTTP response header,
    # but the value of the header does not matter.
    # This config checks for the presence of the header regardless of its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag

    # The "X-Robots-Tag" header must be present in the HTTP response header
    # only if its value is equal to "noindex, nofollow".
    # This config checks both the presence of the header and its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag
        value: '= noindex,nofollow'

    # The "X-Robots-Tag" header must not be present in the HTTP response header
    # but the value of the header does not matter.
    # This config checks for the presence of the header regardless of its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag
        exclude: yes

    # The "X-Robots-Tag" header must not be present in the HTTP response header
    # only if its value is equal to "noindex, nofollow".
    # This config checks both the presence of the header and its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag
        exclude: yes
        value: '= noindex,nofollow'

```
</details>

##### HTTP authentication

Basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080
    username: username
    password: password

```
</details>

##### HTTPS with self-signed certificate

Do not validate server certificate chain and hostname.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:8080
    tls_skip_verify: yes

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080

  - name: remote
    url: http://192.0.2.1:8080

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `httpcheck` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m httpcheck
  ```

### Getting Logs

If you're encountering problems with the `httpcheck` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep httpcheck
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep httpcheck /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep httpcheck
```


