<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/integrations/cloud-authentication/integrations/oidc.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/integrations/cloud-authentication/metadata.yaml"
sidebar_label: "OIDC"
learn_status: "Published"
learn_rel_path: "Netdata Cloud/Authentication & Authorization/Cloud Authentication & Authorization Integrations"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE AUTHENTICATION'S metadata.yaml FILE"
endmeta-->

# OIDC


<img src="https://netdata.cloud/img/openid.svg" width="150"/>


Integrate your organization's Authorization Servers with Netdata to better manage your team's access controls to Netdata Cloud.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites
- Authorization Server with OIDC protocol supported
- A Netdata Cloud account
- Access to the Space as an **Admin**
- Space needs to be on a paid plan

### Setting up Authorization Server
Your server should follow the [full specification for OIDC](https://openid.net/specs/openid-connect-core-1_0.html).
In order to integrate your Authorization Server with Netdata the creation of a client is required. Clients are applications and services that can request authentication of a user.
The access settings for your client are the following:

| field                    | value                                                 |
| :--                      | :--                                                   |
| Root URL                 | `https://app.netdata.cloud/``                           |
| Home/Initiate login URL  | `https://app.netdata.cloud/api/v2/auth/account/auth-server?iss={your-server-issuer-url}&redirect_uri=https://app.netdata.cloud/sign-in&register_uri=https://app.netdata.cloud/sign-up/verify`  |
| Redirect URL             | `https://app.netdata.cloud/api/v2/auth/account/auth-server/callback`  |

### Netdata Configuration Steps
1. Click on the Space settings cog (located above your profile icon)
2. Click on the **User Management** section and access **Authentication and Authorization** tab.
3. On the OIDC card, click on **Configure**
4. Fill in the required credentials:
    - **Issuer URL** the Authorization Server Issuer URL, e.g. `https://my-auth-server.com/`
    - **Client ID** the Client ID from the created client
    - **Client Secret** the Client Secret from the created client
    - **Authorization URL** the Authorization Server authorization URL, e.g. `https://my-auth-server.com/openid-connect/auth`
    - **Token URL** the Authorization Server token URL, e.g. `https://my-auth-server.com/openid-connect/token`
    - **User URL** the Authorization Server user info URL, e.g. `https://my-auth-server.com/openid-connect/userinfo`

### Supported features
* SP-initiated SSO (Single Sign-On)
* IdP-initiated SSO

### SP-initiated SSO

If you start your authentication flow from Netdata sign-in page please check [these steps](https://github.com/netdata/netdata/blob/master/docs/netdata-cloud/authentication-and-authorization/enterprise-sso-authentication.md#from-netdata-sign-up-page).


### Reference
https://openid.net/developers/how-connect-works/


