<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/ceph/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/ceph/metadata.yaml"
sidebar_label: "Ceph"
learn_status: "Published"
learn_rel_path: "Data Collection/Storage, Mount Points and Filesystems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Ceph


<img src="https://netdata.cloud/img/ceph.svg" width="150"/>


Plugin: python.d.plugin
Module: ceph

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Ceph metrics about Cluster statistics, OSD usage, latency and Pool statistics.

Uses the `rados` python module to connect to a Ceph cluster.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Ceph instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ceph.general_usage | avail, used | KiB |
| ceph.general_objects | cluster | objects |
| ceph.general_bytes | read, write | KiB/s |
| ceph.general_operations | read, write | operations |
| ceph.general_latency | apply, commit | milliseconds |
| ceph.pool_usage | a dimension per Ceph Pool | KiB |
| ceph.pool_objects | a dimension per Ceph Pool | objects |
| ceph.pool_read_bytes | a dimension per Ceph Pool | KiB/s |
| ceph.pool_write_bytes | a dimension per Ceph Pool | KiB/s |
| ceph.pool_read_operations | a dimension per Ceph Pool | operations |
| ceph.pool_write_operations | a dimension per Ceph Pool | operations |
| ceph.osd_usage | a dimension per Ceph OSD | KiB |
| ceph.osd_size | a dimension per Ceph OSD | KiB |
| ceph.apply_latency | a dimension per Ceph OSD | milliseconds |
| ceph.commit_latency | a dimension per Ceph OSD | milliseconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ ceph_cluster_space_usage ](https://github.com/netdata/netdata/blob/master/health/health.d/ceph.conf) | ceph.general_usage | cluster disk space utilization |


## Setup

### Prerequisites

#### `rados` python module

Make sure the `rados` python module is installed

#### Granting read permissions to ceph group from keyring file

Execute: `chmod 640 /etc/ceph/ceph.client.admin.keyring`

#### Create a specific rados_id

You can optionally create a rados_id to use instead of admin


### Configuration

#### File

The configuration file name for this integration is `python.d/ceph.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/ceph.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| config_file | Ceph config file |  | yes |
| keyring_file | Ceph keyring file. netdata user must be added into ceph group and keyring file must be read group permission. |  | yes |
| rados_id | A rados user id to use for connecting to the Ceph cluster. | admin | no |

</details>

#### Examples

##### Basic local Ceph cluster

A basic configuration to connect to a local Ceph cluster.

```yaml
local:
 config_file: '/etc/ceph/ceph.conf'
 keyring_file: '/etc/ceph/ceph.client.admin.keyring'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `ceph` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin ceph debug trace
  ```


