/**
 * @file:   MemberConstraint.cpp
 * @brief:  Implementation of the MemberConstraint class
 * @author: Generated by autocreate code
 *
 * <!--------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2009-2013 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *
 * Copyright (C) 2006-2008 by the California Institute of Technology,
 *     Pasadena, CA, USA 
 *
 * Copyright (C) 2002-2005 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. Japan Science and Technology Agency, Japan
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * ------------------------------------------------------------------------ -->
 */


#include <sbml/packages/groups/sbml/MemberConstraint.h>
#include <sbml/packages/groups/validator/GroupsSBMLError.h>


using namespace std;


LIBSBML_CPP_NAMESPACE_BEGIN


/*
 * Creates a new MemberConstraint with the given level, version, and package version.
 */
MemberConstraint::MemberConstraint (unsigned int level, unsigned int version, unsigned int pkgVersion)
  : SBase(level, version)
   ,mId ("")
   ,mName ("")
   ,mDistinctAttribute ("")
   ,mIdenticalAttribute ("")
{
  // set an SBMLNamespaces derived object of this package
  setSBMLNamespacesAndOwn(new GroupsPkgNamespaces(level, version, pkgVersion));
}


/*
 * Creates a new MemberConstraint with the given GroupsPkgNamespaces object.
 */
MemberConstraint::MemberConstraint (GroupsPkgNamespaces* groupsns)
  : SBase(groupsns)
   ,mId ("")
   ,mName ("")
   ,mDistinctAttribute ("")
   ,mIdenticalAttribute ("")
{
  // set the element namespace of this object
  setElementNamespace(groupsns->getURI());

  // load package extensions bound with this object (if any) 
  loadPlugins(groupsns);
}


/*
 * Copy constructor for MemberConstraint.
 */
MemberConstraint::MemberConstraint (const MemberConstraint& orig)
  : SBase(orig)
  , mId  ( orig.mId)
  , mName  ( orig.mName)
  , mDistinctAttribute  ( orig.mDistinctAttribute)
  , mIdenticalAttribute  ( orig.mIdenticalAttribute)
{
}


/*
 * Assignment for MemberConstraint.
 */
MemberConstraint&
MemberConstraint::operator=(const MemberConstraint& rhs)
{
  if (&rhs != this)
  {
    SBase::operator=(rhs);
    mId  = rhs.mId;
    mName  = rhs.mName;
    mDistinctAttribute  = rhs.mDistinctAttribute;
    mIdenticalAttribute  = rhs.mIdenticalAttribute;
  }
  return *this;
}


/*
 * Clone for MemberConstraint.
 */
MemberConstraint*
MemberConstraint::clone () const
{
  return new MemberConstraint(*this);
}


/*
 * Destructor for MemberConstraint.
 */
MemberConstraint::~MemberConstraint ()
{
}


/*
 * Returns the value of the "id" attribute of this MemberConstraint.
 */
const std::string&
MemberConstraint::getId() const
{
  return mId;
}


/*
 * Returns the value of the "name" attribute of this MemberConstraint.
 */
const std::string&
MemberConstraint::getName() const
{
  return mName;
}


/*
 * Returns the value of the "distinctAttribute" attribute of this MemberConstraint.
 */
const std::string&
MemberConstraint::getDistinctAttribute() const
{
  return mDistinctAttribute;
}


/*
 * Returns the value of the "identicalAttribute" attribute of this MemberConstraint.
 */
const std::string&
MemberConstraint::getIdenticalAttribute() const
{
  return mIdenticalAttribute;
}


/*
 * Returns true/false if id is set.
 */
bool
MemberConstraint::isSetId() const
{
  return (mId.empty() == false);
}


/*
 * Returns true/false if name is set.
 */
bool
MemberConstraint::isSetName() const
{
  return (mName.empty() == false);
}


/*
 * Returns true/false if distinctAttribute is set.
 */
bool
MemberConstraint::isSetDistinctAttribute() const
{
  return (mDistinctAttribute.empty() == false);
}


/*
 * Returns true/false if identicalAttribute is set.
 */
bool
MemberConstraint::isSetIdenticalAttribute() const
{
  return (mIdenticalAttribute.empty() == false);
}


/*
 * Sets id and returns value indicating success.
 */
int
MemberConstraint::setId(const std::string& id)
{
  return SyntaxChecker::checkAndSetSId(id, mId);
}


/*
 * Sets name and returns value indicating success.
 */
int
MemberConstraint::setName(const std::string& name)
{
  mName = name;
  return LIBSBML_OPERATION_SUCCESS;
}


/*
 * Sets distinctAttribute and returns value indicating success.
 */
int
MemberConstraint::setDistinctAttribute(const std::string& distinctAttribute)
{
  mDistinctAttribute = distinctAttribute;
  return LIBSBML_OPERATION_SUCCESS;
}


/*
 * Sets identicalAttribute and returns value indicating success.
 */
int
MemberConstraint::setIdenticalAttribute(const std::string& identicalAttribute)
{
  mIdenticalAttribute = identicalAttribute;
  return LIBSBML_OPERATION_SUCCESS;
}


/*
 * Unsets id and returns value indicating success.
 */
int
MemberConstraint::unsetId()
{
  mId.erase();

  if (mId.empty() == true)
  {
    return LIBSBML_OPERATION_SUCCESS;
  }
  else
  {
    return LIBSBML_OPERATION_FAILED;
  }
}


/*
 * Unsets name and returns value indicating success.
 */
int
MemberConstraint::unsetName()
{
  mName.erase();

  if (mName.empty() == true)
  {
    return LIBSBML_OPERATION_SUCCESS;
  }
  else
  {
    return LIBSBML_OPERATION_FAILED;
  }
}


/*
 * Unsets distinctAttribute and returns value indicating success.
 */
int
MemberConstraint::unsetDistinctAttribute()
{
  mDistinctAttribute.erase();

  if (mDistinctAttribute.empty() == true)
  {
    return LIBSBML_OPERATION_SUCCESS;
  }
  else
  {
    return LIBSBML_OPERATION_FAILED;
  }
}


/*
 * Unsets identicalAttribute and returns value indicating success.
 */
int
MemberConstraint::unsetIdenticalAttribute()
{
  mIdenticalAttribute.erase();

  if (mIdenticalAttribute.empty() == true)
  {
    return LIBSBML_OPERATION_SUCCESS;
  }
  else
  {
    return LIBSBML_OPERATION_FAILED;
  }
}


/*
 * Returns the XML element name of this object
 */
const std::string&
MemberConstraint::getElementName () const
{
  static const string name = "memberConstraint";
  return name;
}


/*
 * Returns the libSBML type code for this SBML object.
 */
int
MemberConstraint::getTypeCode () const
{
  return SBML_GROUPS_MEMBER_CONSTRAINT;
}


/*
 * check if all the required attributes are set
 */
bool
MemberConstraint::hasRequiredAttributes () const
{
  bool allPresent = true;

  return allPresent;
}


  /** @cond doxygenLibsbmlInternal */

/*
 * write contained elements
 */
void
MemberConstraint::writeElements (XMLOutputStream& stream) const
{
  SBase::writeElements(stream);

  SBase::writeExtensionElements(stream);
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Accepts the given SBMLVisitor.
 */
bool
MemberConstraint::accept (SBMLVisitor& v) const
{
  return v.visit(*this);
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Sets the parent SBMLDocument.
 */
void
MemberConstraint::setSBMLDocument (SBMLDocument* d)
{
  SBase::setSBMLDocument(d);
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Enables/Disables the given package with this element.
 */
void
MemberConstraint::enablePackageInternal(const std::string& pkgURI,
             const std::string& pkgPrefix, bool flag)
{
  SBase::enablePackageInternal(pkgURI, pkgPrefix, flag);
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Get the list of expected attributes for this element.
 */
void
MemberConstraint::addExpectedAttributes(ExpectedAttributes& attributes)
{
  SBase::addExpectedAttributes(attributes);

  attributes.add("id");
  attributes.add("name");
  attributes.add("distinctAttribute");
  attributes.add("identicalAttribute");
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Read values from the given XMLAttributes set into their specific fields.
 */
void
MemberConstraint::readAttributes (const XMLAttributes& attributes,
                             const ExpectedAttributes& expectedAttributes)
{
  const unsigned int sbmlLevel   = getLevel  ();
  const unsigned int sbmlVersion = getVersion();

  unsigned int numErrs;

  /* look to see whether an unknown attribute error was logged
   * during the read of the listOfMemberConstraints - which will have
   * happened immediately prior to this read
  */

  if (getErrorLog() != NULL &&
      static_cast<ListOfMemberConstraints*>(getParentSBMLObject())->size() < 2)
  {
    numErrs = getErrorLog()->getNumErrors();
    for (int n = numErrs-1; n >= 0; n--)
    {
      if (getErrorLog()->getError(n)->getErrorId() == UnknownPackageAttribute)
      {
        const std::string details =
              getErrorLog()->getError(n)->getMessage();
        getErrorLog()->remove(UnknownPackageAttribute);
        getErrorLog()->logPackageError("groups", GroupsUnknownError,
                  getPackageVersion(), sbmlLevel, sbmlVersion, details);
      }
      else if (getErrorLog()->getError(n)->getErrorId() == UnknownCoreAttribute)
      {
        const std::string details =
                   getErrorLog()->getError(n)->getMessage();
        getErrorLog()->remove(UnknownCoreAttribute);
        getErrorLog()->logPackageError("groups", UnknownError,
                  getPackageVersion(), sbmlLevel, sbmlVersion, details);
      }
    }
  }

  SBase::readAttributes(attributes, expectedAttributes);

  // look to see whether an unknown attribute error was logged
  if (getErrorLog() != NULL)
  {
    numErrs = getErrorLog()->getNumErrors();
    for (int n = numErrs-1; n >= 0; n--)
    {
      if (getErrorLog()->getError(n)->getErrorId() == UnknownPackageAttribute)
      {
        const std::string details =
                          getErrorLog()->getError(n)->getMessage();
        getErrorLog()->remove(UnknownPackageAttribute);
        getErrorLog()->logPackageError("groups", UnknownError,
                       getPackageVersion(), sbmlLevel, sbmlVersion, details);
      }
      else if (getErrorLog()->getError(n)->getErrorId() == UnknownCoreAttribute)
      {
        const std::string details =
                          getErrorLog()->getError(n)->getMessage();
        getErrorLog()->remove(UnknownCoreAttribute);
        getErrorLog()->logPackageError("groups", UnknownError,
                       getPackageVersion(), sbmlLevel, sbmlVersion, details);
      }
    }
  }

  bool assigned = false;

  //
  // id SId  ( use = "optional" )
  //
  assigned = attributes.readInto("id", mId);

   if (assigned == true)
  {
    // check string is not empty and correct syntax

    if (mId.empty() == true)
    {
      logEmptyString(mId, getLevel(), getVersion(), "<MemberConstraint>");
    }
    else if (SyntaxChecker::isValidSBMLSId(mId) == false)
    {
      logError(InvalidIdSyntax);
    }
  }

  //
  // name string   ( use = "optional" )
  //
  assigned = attributes.readInto("name", mName);

  if (assigned == true)
  {
    // check string is not empty

    if (mName.empty() == true)
    {
      logEmptyString(mName, getLevel(), getVersion(), "<MemberConstraint>");
    }
  }

  //
  // distinctAttribute string   ( use = "optional" )
  //
  assigned = attributes.readInto("distinctAttribute", mDistinctAttribute);

  if (assigned == true)
  {
    // check string is not empty

    if (mDistinctAttribute.empty() == true)
    {
      logEmptyString(mDistinctAttribute, getLevel(), getVersion(), "<MemberConstraint>");
    }
  }

  //
  // identicalAttribute string   ( use = "optional" )
  //
  assigned = attributes.readInto("identicalAttribute", mIdenticalAttribute);

  if (assigned == true)
  {
    // check string is not empty

    if (mIdenticalAttribute.empty() == true)
    {
      logEmptyString(mIdenticalAttribute, getLevel(), getVersion(), "<MemberConstraint>");
    }
  }

}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Write values of XMLAttributes to the output stream.
 */
  void
MemberConstraint::writeAttributes (XMLOutputStream& stream) const
{
  SBase::writeAttributes(stream);

  if (isSetId() == true)
    stream.writeAttribute("id", getPrefix(), mId);

  if (isSetName() == true)
    stream.writeAttribute("name", getPrefix(), mName);

  if (isSetDistinctAttribute() == true)
    stream.writeAttribute("distinctAttribute", getPrefix(), mDistinctAttribute);

  if (isSetIdenticalAttribute() == true)
    stream.writeAttribute("identicalAttribute", getPrefix(), mIdenticalAttribute);

  SBase::writeExtensionAttributes(stream);

}


  /** @endcond doxygenLibsbmlInternal */


/*
 * Constructor 
 */
ListOfMemberConstraints::ListOfMemberConstraints(unsigned int level, 
                          unsigned int version, 
                          unsigned int pkgVersion)
 : ListOf(level, version)
   ,mId ("")
   ,mName ("")
   ,mMembersShareType (false)
   ,mIsSetMembersShareType (false)
{
  setSBMLNamespacesAndOwn(new GroupsPkgNamespaces(level, version, pkgVersion)); 
}


/*
 * Constructor 
 */
ListOfMemberConstraints::ListOfMemberConstraints(GroupsPkgNamespaces* groupsns)
  : ListOf(groupsns)
   ,mId ("")
   ,mName ("")
   ,mMembersShareType (false)
   ,mIsSetMembersShareType (false)
{
  setElementNamespace(groupsns->getURI());
}


/*
 * Returns a deep copy of this ListOfMemberConstraints 
 */
ListOfMemberConstraints* 
ListOfMemberConstraints::clone () const
 {
  return new ListOfMemberConstraints(*this);
}


/*
 * Get a MemberConstraint from the ListOfMemberConstraints by index.
*/
MemberConstraint*
ListOfMemberConstraints::get(unsigned int n)
{
  return static_cast<MemberConstraint*>(ListOf::get(n));
}


/*
 * Get a MemberConstraint from the ListOfMemberConstraints by index.
 */
const MemberConstraint*
ListOfMemberConstraints::get(unsigned int n) const
{
  return static_cast<const MemberConstraint*>(ListOf::get(n));
}


/*
 * Get a MemberConstraint from the ListOfMemberConstraints by id.
 */
MemberConstraint*
ListOfMemberConstraints::get(const std::string& sid)
{
  return const_cast<MemberConstraint*>(
    static_cast<const ListOfMemberConstraints&>(*this).get(sid));
}


/*
 * Get a MemberConstraint from the ListOfMemberConstraints by id.
 */
const MemberConstraint*
ListOfMemberConstraints::get(const std::string& sid) const
{
  vector<SBase*>::const_iterator result;

  result = find_if( mItems.begin(), mItems.end(), IdEq<MemberConstraint>(sid) );
  return (result == mItems.end()) ? 0 : static_cast <MemberConstraint*> (*result);
}


/*
 * Removes the nth MemberConstraint from this ListOfMemberConstraints
 */
MemberConstraint*
ListOfMemberConstraints::remove(unsigned int n)
{
  return static_cast<MemberConstraint*>(ListOf::remove(n));
}


/*
 * Removes the MemberConstraint from this ListOfMemberConstraints with the given identifier
 */
MemberConstraint*
ListOfMemberConstraints::remove(const std::string& sid)
{
  SBase* item = NULL;
  vector<SBase*>::iterator result;

  result = find_if( mItems.begin(), mItems.end(), IdEq<MemberConstraint>(sid) );

  if (result != mItems.end())
  {
    item = *result;
    mItems.erase(result);
  }

  return static_cast <MemberConstraint*> (item);
}


/*
 * Returns the value of the "id" attribute of this MemberConstraint.
 */
const std::string&
ListOfMemberConstraints::getId() const
{
  return mId;
}


/*
 * Returns the value of the "name" attribute of this MemberConstraint.
 */
const std::string&
ListOfMemberConstraints::getName() const
{
  return mName;
}


/*
 * Returns the value of the "membersShareType" attribute of this MemberConstraint.
 */
bool
ListOfMemberConstraints::getMembersShareType() const
{
  return mMembersShareType;
}


/*
 * Returns true/false if id is set.
 */
bool
ListOfMemberConstraints::isSetId() const
{
  return (mId.empty() == false);
}


/*
 * Returns true/false if name is set.
 */
bool
ListOfMemberConstraints::isSetName() const
{
  return (mName.empty() == false);
}


/*
 * Returns true/false if membersShareType is set.
 */
bool
ListOfMemberConstraints::isSetMembersShareType() const
{
  return mIsSetMembersShareType;
}


/*
 * Sets id and returns value indicating success.
 */
int
ListOfMemberConstraints::setId(const std::string& id)
{
  return SyntaxChecker::checkAndSetSId(id, mId);
}


/*
 * Sets name and returns value indicating success.
 */
int
ListOfMemberConstraints::setName(const std::string& name)
{
  mName = name;
  return LIBSBML_OPERATION_SUCCESS;
}


/*
 * Sets membersShareType and returns value indicating success.
 */
int
ListOfMemberConstraints::setMembersShareType(bool membersShareType)
{
  mMembersShareType = membersShareType;
  mIsSetMembersShareType = true;
  return LIBSBML_OPERATION_SUCCESS;
}


/*
 * Unsets id and returns value indicating success.
 */
int
ListOfMemberConstraints::unsetId()
{
  mId.erase();

  if (mId.empty() == true)
  {
    return LIBSBML_OPERATION_SUCCESS;
  }
  else
  {
    return LIBSBML_OPERATION_FAILED;
  }
}


/*
 * Unsets name and returns value indicating success.
 */
int
ListOfMemberConstraints::unsetName()
{
  mName.erase();

  if (mName.empty() == true)
  {
    return LIBSBML_OPERATION_SUCCESS;
  }
  else
  {
    return LIBSBML_OPERATION_FAILED;
  }
}


/*
 * Unsets membersShareType and returns value indicating success.
 */
int
ListOfMemberConstraints::unsetMembersShareType()
{
  mMembersShareType = false;
  mIsSetMembersShareType = false;
  return LIBSBML_OPERATION_FAILED;
}


/*
 * Returns the XML element name of this object
 */
const std::string&
ListOfMemberConstraints::getElementName () const
{
  static const string name = "listOfMemberConstraints";
  return name;
}


/*
 * Returns the libSBML type code for this SBML object.
 */
int
ListOfMemberConstraints::getTypeCode () const
{
  return SBML_LIST_OF;
}


/*
 * Returns the libSBML type code for the objects in this LIST_OF.
 */
int
ListOfMemberConstraints::getItemTypeCode () const
{
  return SBML_GROUPS_MEMBER_CONSTRAINT;
}


  /** @cond doxygenLibsbmlInternal */

/*
 * Creates a new MemberConstraint in this ListOfMemberConstraints
 */
SBase*
ListOfMemberConstraints::createObject(XMLInputStream& stream)
{
  const std::string& name   = stream.peek().getName();
  SBase* object = NULL;

  if (name == "memberConstraint")
  {
    GROUPS_CREATE_NS(groupsns, getSBMLNamespaces());
    object = new MemberConstraint(groupsns);
    appendAndOwn(object);
    delete groupsns;
  }

  return object;
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Get the list of expected attributes for this element.
 */
void
ListOfMemberConstraints::addExpectedAttributes(ExpectedAttributes& attributes)
{
  SBase::addExpectedAttributes(attributes);

  attributes.add("id");
  attributes.add("name");
  attributes.add("membersShareType");
}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Read values from the given XMLAttributes set into their specific fields.
 */
void
ListOfMemberConstraints::readAttributes (const XMLAttributes& attributes,
                             const ExpectedAttributes& expectedAttributes)
{
  const unsigned int sbmlLevel   = getLevel  ();
  const unsigned int sbmlVersion = getVersion();

  unsigned int numErrs;

  SBase::readAttributes(attributes, expectedAttributes);

  // look to see whether an unknown attribute error was logged
  if (getErrorLog() != NULL)
  {
    numErrs = getErrorLog()->getNumErrors();
    for (int n = numErrs-1; n >= 0; n--)
    {
      if (getErrorLog()->getError(n)->getErrorId() == UnknownPackageAttribute)
      {
        const std::string details =
                          getErrorLog()->getError(n)->getMessage();
        getErrorLog()->remove(UnknownPackageAttribute);
        getErrorLog()->logPackageError("groups", UnknownError,
                       getPackageVersion(), sbmlLevel, sbmlVersion, details);
      }
      else if (getErrorLog()->getError(n)->getErrorId() == UnknownCoreAttribute)
      {
        const std::string details =
                          getErrorLog()->getError(n)->getMessage();
        getErrorLog()->remove(UnknownCoreAttribute);
        getErrorLog()->logPackageError("groups", UnknownError,
                       getPackageVersion(), sbmlLevel, sbmlVersion, details);
      }
    }
  }

  bool assigned = false;

  //
  // id SId  ( use = "optional" )
  //
  assigned = attributes.readInto("id", mId);

  if (assigned == true)
  {
    // check string is not empty and correct syntax

    if (mId.empty() == true)
    {
      logEmptyString(mId, getLevel(), getVersion(), "<ListOfMemberConstraints>");
    }
    else if (SyntaxChecker::isValidSBMLSId(mId) == false)
    {
      logError(InvalidIdSyntax);
    }
  }

  //
  // name string   ( use = "optional" )
  //
  assigned = attributes.readInto("name", mName);

  if (assigned == true)
  {
    // check string is not empty

    if (mName.empty() == true)
    {
      logEmptyString(mName, getLevel(), getVersion(), "<ListOfMemberConstraints>");
    }
  }

  //
  // constant bool   ( use = "required" )
  //
  numErrs = getErrorLog()->getNumErrors();
  mIsSetMembersShareType = attributes.readInto("membersShareType", mMembersShareType);

  if (mIsSetMembersShareType == false)
  {
    if (getErrorLog() != NULL)
    {
      if (getErrorLog()->getNumErrors() == numErrs + 1 &&
              getErrorLog()->contains(XMLAttributeTypeMismatch))
      {
        getErrorLog()->remove(XMLAttributeTypeMismatch);
        getErrorLog()->logPackageError("groups", GroupsUnknownError,
                     getPackageVersion(), sbmlLevel, sbmlVersion);
      }
      else
      {
      std::string message = "Groups attribute 'membersShareType' is missing.";
      getErrorLog()->logPackageError("groups", GroupsUnknownError,
                     getPackageVersion(), sbmlLevel, sbmlVersion, message);
      }
    }
  }

}


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

/*
 * Write values of XMLAttributes to the output stream.
 */
void
ListOfMemberConstraints::writeAttributes (XMLOutputStream& stream) const
{
  SBase::writeAttributes(stream);

  if (isSetId() == true)
    stream.writeAttribute("id", getPrefix(), mId);

  if (isSetName() == true)
    stream.writeAttribute("name", getPrefix(), mName);

  if (isSetMembersShareType() == true)
    stream.writeAttribute("membersShareType", getPrefix(), mMembersShareType);

  SBase::writeExtensionAttributes(stream);

}


  /** @endcond doxygenLibsbmlInternal */



  /** @cond doxygenLibsbmlInternal */

/*
 * Write the namespace for the Groups package.
 */
void
ListOfMemberConstraints::writeXMLNS(XMLOutputStream& stream) const
{
  XMLNamespaces xmlns;

  std::string prefix = getPrefix();

  if (prefix.empty())
  {
    XMLNamespaces* thisxmlns = getNamespaces();
    if (thisxmlns && thisxmlns->hasURI(GroupsExtension::getXmlnsL3V1V1()))
    {
      xmlns.add(GroupsExtension::getXmlnsL3V1V1(),prefix);
    }
  }

  stream << xmlns;
}


  /** @endcond doxygenLibsbmlInternal */


/**
 * write comments
 */
LIBSBML_EXTERN
MemberConstraint_t *
MemberConstraint_create(unsigned int level, unsigned int version,
                        unsigned int pkgVersion)
{
  return new MemberConstraint(level, version, pkgVersion);
}


/**
 * write comments
 */
LIBSBML_EXTERN
void
MemberConstraint_free(MemberConstraint_t * mc)
{
  if (mc != NULL)
    delete mc;
}


/**
 * write comments
 */
LIBSBML_EXTERN
MemberConstraint_t *
MemberConstraint_clone(MemberConstraint_t * mc)
{
  if (mc != NULL)
  {
    return static_cast<MemberConstraint_t*>(mc->clone());
  }
  else
  {
    return NULL;
  }
}


/**
 * write comments
 */
LIBSBML_EXTERN
char *
MemberConstraint_getId(MemberConstraint_t * mc)
{
  if (mc == NULL)
    return NULL;

  return mc->getId().empty() ? NULL : safe_strdup(mc->getId().c_str());
}


/**
 * write comments
 */
LIBSBML_EXTERN
char *
MemberConstraint_getName(MemberConstraint_t * mc)
{
  if (mc == NULL)
    return NULL;

  return mc->getName().empty() ? NULL : safe_strdup(mc->getName().c_str());
}


/**
 * write comments
 */
LIBSBML_EXTERN
char *
MemberConstraint_getDistinctAttribute(MemberConstraint_t * mc)
{
  if (mc == NULL)
    return NULL;

  return mc->getDistinctAttribute().empty() ? NULL : safe_strdup(mc->getDistinctAttribute().c_str());
}


/**
 * write comments
 */
LIBSBML_EXTERN
char *
MemberConstraint_getIdenticalAttribute(MemberConstraint_t * mc)
{
  if (mc == NULL)
    return NULL;

  return mc->getIdenticalAttribute().empty() ? NULL : safe_strdup(mc->getIdenticalAttribute().c_str());
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_isSetId(MemberConstraint_t * mc)
{
  return (mc != NULL) ? static_cast<int>(mc->isSetId()) : 0;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_isSetName(MemberConstraint_t * mc)
{
  return (mc != NULL) ? static_cast<int>(mc->isSetName()) : 0;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_isSetDistinctAttribute(MemberConstraint_t * mc)
{
  return (mc != NULL) ? static_cast<int>(mc->isSetDistinctAttribute()) : 0;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_isSetIdenticalAttribute(MemberConstraint_t * mc)
{
  return (mc != NULL) ? static_cast<int>(mc->isSetIdenticalAttribute()) : 0;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_setId(MemberConstraint_t * mc, const char * id)
{
  return (mc != NULL) ? mc->setId(id) : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_setName(MemberConstraint_t * mc, const char * name)
{
  return (mc != NULL) ? mc->setName(name) : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_setDistinctAttribute(MemberConstraint_t * mc, const char * distinctAttribute)
{
  return (mc != NULL) ? mc->setDistinctAttribute(distinctAttribute) : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_setIdenticalAttribute(MemberConstraint_t * mc, const char * identicalAttribute)
{
  return (mc != NULL) ? mc->setIdenticalAttribute(identicalAttribute) : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_unsetId(MemberConstraint_t * mc)
{
  return (mc != NULL) ? mc->unsetId() : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_unsetName(MemberConstraint_t * mc)
{
  return (mc != NULL) ? mc->unsetName() : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_unsetDistinctAttribute(MemberConstraint_t * mc)
{
  return (mc != NULL) ? mc->unsetDistinctAttribute() : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_unsetIdenticalAttribute(MemberConstraint_t * mc)
{
  return (mc != NULL) ? mc->unsetIdenticalAttribute() : LIBSBML_INVALID_OBJECT;
}


/**
 * write comments
 */
LIBSBML_EXTERN
int
MemberConstraint_hasRequiredAttributes(MemberConstraint_t * mc)
{
  return (mc != NULL) ? static_cast<int>(mc->hasRequiredAttributes()) : 0;
}


/**
 * write comments
 */
LIBSBML_EXTERN
MemberConstraint_t *
ListOfMemberConstraints_getById(ListOf_t * lo, const char * sid)
{
  if (lo == NULL)
    return NULL;

  return (sid != NULL) ? static_cast <ListOfMemberConstraints *>(lo)->get(sid) : NULL;
}


/**
 * write comments
 */
LIBSBML_EXTERN
MemberConstraint_t *
ListOfMemberConstraints_removeById(ListOf_t * lo, const char * sid)
{
  if (lo == NULL)
    return NULL;

  return (sid != NULL) ? static_cast <ListOfMemberConstraints *>(lo)->remove(sid) : NULL;
}




LIBSBML_CPP_NAMESPACE_END


