------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2006-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;              use Ada.Text_IO;
with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;

with GNAT.Strings;             use GNAT.Strings;

with GNATCOLL.Email.Parser;    use GNATCOLL.Email, GNATCOLL.Email.Parser;
with GNATCOLL.Email.Mailboxes; use GNATCOLL.Email.Mailboxes;
with GNATCOLL.Email.Utils;     use GNATCOLL.Email.Utils;
with GNATCOLL.VFS;             use GNATCOLL.VFS;

procedure Test_Email is
   Str  : GNAT.Strings.String_Access;
   M    : Message;
   MS   : Unbounded_String;

begin
   Full_Parse_From_File
     (Filename      => Create (+"../email_data/O909-052"),
      Msg           => M,
      Parse_Payload => True);

   To_String (M, Result => MS, Decode => True);
   Put_Line (To_String (MS));
end Test_Email;
