/* Add a BIT field */
#include "test.h"

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

int main(void)
{
  const char* filedir = __TEST__ "dirfile";
  const char* format = __TEST__ "dirfile/format";
  int error, n, r = 0;
  DIRFILE* D = gd_open(filedir, GD_RDWR | GD_CREAT);

  gd_add_bit(D, "new", "input", 1, 99, 0);
  error = gd_error(D);

  /* check */
  n = gd_nfields(D);

  gd_close(D);

  unlink(format);
  rmdir(filedir);

  CHECKI(n, 1);
  CHECKI(error, GD_E_BAD_ENTRY);

  return r;
}
