/***************************************************************************
                           czlib.h  -  description
                             -------------------
    begin                : Thu Oct 12 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CZLIB_H
#define CZLIB_H

/**
  *@author Mathias Küster
  *
  * This is a wrapper for zlib.
  */

#include <dclib/dcos.h>

class CByteArray;

struct z_stream_s;

class CZLib {

public:
	/** */
	CZLib();
	/** */
	~CZLib();

	/**
	 * inflate block
	 * -1 error
	 *  0 finished (stream end)
	 *  1 more data to process
	 */
	int InflateZBlock( const char * in, int * inlen, char * out, int * outlen );
	/** */
	unsigned long GetTotalOut() const;
	/** Returns size of decompressed output , or zero on error */
	static unsigned long OneShotInflate( const char * in, const unsigned long inlen, CByteArray * out );

private:
	/** */
	bool m_bInit;
	/** */
	struct z_stream_s * m_pZStream;
};

class CDeflater {

public:
	/** Constructor */
	CDeflater();
	/** Destructor */
	~CDeflater();
	
	/**
	 * deflate block
	 * -1 error
	 *  0 finished (stream end)
	 *  1 more data to process
	 */
	int DeflateBlock( const char * in, int * inlen, char * out, int * outlen, bool more );
	/** */
	unsigned long GetTotalOut() const;
	/** Returns size of compressed output, or zero on error */
	static unsigned long OneShotDeflate( const char * in, const unsigned long inlen, CByteArray * out );

private:
	/** */
	bool m_bInit;
	/** */
	struct z_stream_s * m_pZStream;
};

#endif
