## API Report File for "@lumino/algorithm"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export namespace ArrayExt {
    export function fill<T>(array: MutableArrayLike<T>, value: T, start?: number, stop?: number): void;
    export function findFirstIndex<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): number;
    export function findFirstValue<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): T | undefined;
    export function findLastIndex<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): number;
    export function findLastValue<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): T | undefined;
    export function firstIndexOf<T>(array: ArrayLike<T>, value: T, start?: number, stop?: number): number;
    export function insert<T>(array: Array<T>, index: number, value: T): void;
    export function lastIndexOf<T>(array: ArrayLike<T>, value: T, start?: number, stop?: number): number;
    export function lowerBound<T, U>(array: ArrayLike<T>, value: U, fn: (element: T, value: U) => number, start?: number, stop?: number): number;
    export function move<T>(array: MutableArrayLike<T>, fromIndex: number, toIndex: number): void;
    export type MutableArrayLike<T> = {
        readonly length: number;
        [index: number]: T;
    };
    export function removeAllOf<T>(array: Array<T>, value: T, start?: number, stop?: number): number;
    export function removeAllWhere<T>(array: Array<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): number;
    export function removeAt<T>(array: Array<T>, index: number): T | undefined;
    export function removeFirstOf<T>(array: Array<T>, value: T, start?: number, stop?: number): number;
    export function removeFirstWhere<T>(array: Array<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): {
        index: number;
        value: T | undefined;
    };
    export function removeLastOf<T>(array: Array<T>, value: T, start?: number, stop?: number): number;
    export function removeLastWhere<T>(array: Array<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): {
        index: number;
        value: T | undefined;
    };
    export function reverse<T>(array: MutableArrayLike<T>, start?: number, stop?: number): void;
    export function rotate<T>(array: MutableArrayLike<T>, delta: number, start?: number, stop?: number): void;
    export function shallowEqual<T>(a: ArrayLike<T>, b: ArrayLike<T>, fn?: (a: T, b: T) => boolean): boolean;
    export function slice<T>(array: ArrayLike<T>, options?: slice.IOptions): T[];
    export namespace slice {
        export interface IOptions {
            start?: number;
            step?: number;
            stop?: number;
        }
    }
    export function upperBound<T, U>(array: ArrayLike<T>, value: U, fn: (element: T, value: U) => number, start?: number, stop?: number): number;
}

// @public
export class ArrayIterator<T> implements IIterator<T> {
    constructor(source: ArrayLike<T>);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function chain<T>(...objects: IterableOrArrayLike<T>[]): IIterator<T>;

// @public
export class ChainIterator<T> implements IIterator<T> {
    constructor(source: IIterator<IIterator<T>>);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function each<T>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => boolean | void): void;

// @public
export function empty<T>(): IIterator<T>;

// @public
export class EmptyIterator<T> implements IIterator<T> {
    constructor();
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
}

// @public
export function enumerate<T>(object: IterableOrArrayLike<T>, start?: number): IIterator<[number, T]>;

// @public
export class EnumerateIterator<T> implements IIterator<[number, T]> {
    constructor(source: IIterator<T>, start: number);
    clone(): IIterator<[number, T]>;
    iter(): IIterator<[number, T]>;
    next(): [number, T] | undefined;
    }

// @public
export function every<T>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => boolean): boolean;

// @public
export function filter<T>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => boolean): IIterator<T>;

// @public
export class FilterIterator<T> implements IIterator<T> {
    constructor(source: IIterator<T>, fn: (value: T, index: number) => boolean);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function find<T>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => boolean): T | undefined;

// @public
export function findIndex<T>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => boolean): number;

// @public
export class FnIterator<T> implements IIterator<T> {
    constructor(fn: () => T | undefined);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
}

// @public
export interface IIterable<T> {
    iter(): IIterator<T>;
}

// @public
export interface IIterator<T> extends IIterable<T> {
    clone(): IIterator<T>;
    next(): T | undefined;
}

// @public
export interface IRetroable<T> {
    retro(): IIterator<T>;
}

// @public
export class ItemIterator<T> implements IIterator<[string, T]> {
    constructor(source: {
        readonly [key: string]: T;
    }, keys?: string[]);
    clone(): IIterator<[string, T]>;
    iter(): IIterator<[string, T]>;
    next(): [string, T] | undefined;
    }

// @public
export function iter<T>(object: IterableOrArrayLike<T>): IIterator<T>;

// @public
export type IterableOrArrayLike<T> = IIterable<T> | ArrayLike<T>;

// @public
export function iterFn<T>(fn: () => T | undefined): IIterator<T>;

// @public
export function iterItems<T>(object: {
    readonly [key: string]: T;
}): IIterator<[string, T]>;

// @public
export function iterKeys<T>(object: {
    readonly [key: string]: T;
}): IIterator<string>;

// @public
export function iterValues<T>(object: {
    readonly [key: string]: T;
}): IIterator<T>;

// @public
export class KeyIterator implements IIterator<string> {
    constructor(source: {
        readonly [key: string]: any;
    }, keys?: string[]);
    clone(): IIterator<string>;
    iter(): IIterator<string>;
    next(): string | undefined;
    }

// @public
export function map<T, U>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => U): IIterator<U>;

// @public
export class MapIterator<T, U> implements IIterator<U> {
    constructor(source: IIterator<T>, fn: (value: T, index: number) => U);
    clone(): IIterator<U>;
    iter(): IIterator<U>;
    next(): U | undefined;
    }

// @public
export function max<T>(object: IterableOrArrayLike<T>, fn: (first: T, second: T) => number): T | undefined;

// @public
export function min<T>(object: IterableOrArrayLike<T>, fn: (first: T, second: T) => number): T | undefined;

// @public
export function minmax<T>(object: IterableOrArrayLike<T>, fn: (first: T, second: T) => number): [T, T] | undefined;

// @public
export function once<T>(value: T): IIterator<T>;

// @public
export function range(start: number, stop?: number, step?: number): IIterator<number>;

// @public
export class RangeIterator implements IIterator<number> {
    constructor(start: number, stop: number, step: number);
    clone(): IIterator<number>;
    iter(): IIterator<number>;
    next(): number | undefined;
    }

// @public
export function reduce<T>(object: IterableOrArrayLike<T>, fn: (accumulator: T, value: T, index: number) => T): T;

// @public (undocumented)
export function reduce<T, U>(object: IterableOrArrayLike<T>, fn: (accumulator: U, value: T, index: number) => U, initial: U): U;

// @public
export function repeat<T>(value: T, count: number): IIterator<T>;

// @public
export class RepeatIterator<T> implements IIterator<T> {
    constructor(value: T, count: number);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function retro<T>(object: RetroableOrArrayLike<T>): IIterator<T>;

// @public
export type RetroableOrArrayLike<T> = IRetroable<T> | ArrayLike<T>;

// @public
export class RetroArrayIterator<T> implements IIterator<T> {
    constructor(source: ArrayLike<T>);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function some<T>(object: IterableOrArrayLike<T>, fn: (value: T, index: number) => boolean): boolean;

// @public
export function stride<T>(object: IterableOrArrayLike<T>, step: number): IIterator<T>;

// @public
export class StrideIterator<T> implements IIterator<T> {
    constructor(source: IIterator<T>, step: number);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export namespace StringExt {
    export function cmp(a: string, b: string): number;
    export function findIndices(source: string, query: string, start?: number): number[] | null;
    export function highlight<T>(source: string, indices: ReadonlyArray<number>, fn: (chunk: string) => T): Array<string | T>;
    export interface IMatchResult {
        indices: number[];
        score: number;
    }
    export function matchSumOfDeltas(source: string, query: string, start?: number): IMatchResult | null;
    export function matchSumOfSquares(source: string, query: string, start?: number): IMatchResult | null;
}

// @public
export function take<T>(object: IterableOrArrayLike<T>, count: number): IIterator<T>;

// @public
export class TakeIterator<T> implements IIterator<T> {
    constructor(source: IIterator<T>, count: number);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function toArray<T>(object: IterableOrArrayLike<T>): T[];

// @public
export function toObject<T>(object: IterableOrArrayLike<[string, T]>): {
    [key: string]: T;
};

// @public
export function topologicSort<T>(edges: IterableOrArrayLike<[T, T]>): T[];

// @public
export class ValueIterator<T> implements IIterator<T> {
    constructor(source: {
        readonly [key: string]: T;
    }, keys?: string[]);
    clone(): IIterator<T>;
    iter(): IIterator<T>;
    next(): T | undefined;
    }

// @public
export function zip<T>(...objects: IterableOrArrayLike<T>[]): IIterator<T[]>;

// @public
export class ZipIterator<T> implements IIterator<T[]> {
    constructor(source: IIterator<T>[]);
    clone(): IIterator<T[]>;
    iter(): IIterator<T[]>;
    next(): T[] | undefined;
    }


// (No @packageDocumentation comment for this package)

```
