#!/bin/bash

# Simple wrapper to valgrind/memcheck the test cases

# $@ 	binaries to check

error=0

if command -v valgrind >/dev/null; then
	for tool in $@; do
		details=$(
			valgrind -q --leak-check=full --suppressions=<(cat <<-EOT
			  {
			     selinuxfs_exists
			     Memcheck:Leak
			     match-leak-kinds: definite
			     fun:malloc
			     fun:initialise_tags
			     fun:_Z25semmle_read_configurationv
			     fun:semmle_init
			     fun:fopen
			     fun:selinuxfs_exists
			     obj:/lib/x86_64-linux-gnu/libselinux.so.1
			     fun:call_init
			     fun:_dl_init
			     obj:/lib/x86_64-linux-gnu/ld-2.27.so
			  }
			  {
   			     lzma_Debian_#1342_cond
		 	     Memcheck:Cond
			     obj:/usr/lib/x86_64-linux-gnu/liblzma.so.*
			  }
                          {
 	                     lzma_Debia_#1342_free
			     Memcheck:Free
			     obj:/usr/lib/x86_64-linux-gnu/liblzma.so.*
			  }
                          {
 	                     lzma_Debia_#1342_value
			     Memcheck:Value8
			     obj:/usr/lib/x86_64-linux-gnu/liblzma.so.*
			  }
EOT
			) --error-markers=begin,end "./$tool" 2>&1
		)
		output=$(
			echo "$details" |\
			grep -A1 "== begin" |\
			egrep -v "== begin|possibly lost|^--$"
		)
		if [ "$output" != "" ]; then
			error=1
			echo "ERROR: memcheck reports problems for '$tool'!"
			echo "Relevant error lines are:"
			echo
			echo "$output"
			echo
			echo "Full valgrind details:"
			echo
			[ "$GITHUB_ACTION" != "" ] && echo "::group:: $tool details"
			echo "$details"
			[ "$GITHUB_ACTION" != "" ] && echo "::endgroup::"
			echo
		else
			echo "memcheck '$tool' OK"
		fi
	done
else
	echo "Skipping test as valgrind is not installed."
fi

exit $error
