{- This module was generated from data in the Kate syntax
   highlighting file pike.xml, version 1.07, by Paul Pogonyshev -}

module Text.Highlighting.Kate.Syntax.Pike
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Pike"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.pike"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Pike","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Pike","Normal") -> return ()
      ("Pike","String") -> (popContext) >> pEndLine
      ("Pike","Line Comment") -> (popContext) >> pEndLine
      ("Pike","Block Comment") -> return ()
      ("Pike","Preprocessor") -> (popContext) >> pEndLine
      ("Pike","Outscoped") -> return ()
      ("Pike","Outscoped intern") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "break case class continue default do else for foreach if return switch while"
list_types = Set.fromList $ words $ "array float function int mapping mixed multiset> object program static string void"
list_builtins = Set.fromList $ words $ "catch gauge sscanf typeof"

regex_'60'28'5b'5c'2b'5c'2d'5c'2a'2f'25'7e'26'5c'7c'5e'5d'7c'5b'21'3d'3c'3e'5d'3d'7c'3c'3c'3f'7c'3e'3e'3f'7c'28'5c'5b'5c'5d'7c'2d'3e'29'3d'3f'29 = compileRegex True "`([\\+\\-\\*/%~&\\|^]|[!=<>]=|<<?|>>?|(\\[\\]|->)=?)"
regex_0'5bbB'5d'5b01'5d'2b = compileRegex True "0[bB][01]+"
regex_'23'5cs'2aif'5cs'2b0 = compileRegex True "#\\s*if\\s+0"
regex_'5c'5cd'5b0'2d9'5d'2b = compileRegex True "\\\\d[0-9]+"
regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f = compileRegex True "(FIXME|TODO|NOT(IC)?E):?"
regex_'23'5cs'2aif = compileRegex True "#\\s*if"
regex_'23'5cs'2a'28endif'7celif'7celse'29 = compileRegex True "#\\s*(endif|elif|else)"
regex_'23'5cs'2aendif = compileRegex True "#\\s*endif"

parseRules ("Pike","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_builtins >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'60'28'5b'5c'2b'5c'2d'5c'2a'2f'25'7e'26'5c'7c'5e'5d'7c'5b'21'3d'3c'3e'5d'3d'7c'3c'3c'3f'7c'3e'3e'3f'7c'28'5c'5b'5c'5d'7c'2d'3e'29'3d'3f'29 >>= withAttribute FunctionTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_0'5bbB'5d'5b01'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Pike","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Line Comment"))
   <|>
   ((pDetect2Chars False '#' '!' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Line Comment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Block Comment"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0 >>= withAttribute OtherTok) >>~ pushContext ("Pike","Outscoped"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute OtherTok) >>~ pushContext ("Pike","Preprocessor"))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Pike","String") =
  (((pRegExpr regex_'5c'5cd'5b0'2d9'5d'2b >>= withAttribute CharTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pLineContinue >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Pike","Line Comment") =
  (((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","Line Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Pike","Block Comment") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","Block Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Pike","Preprocessor") =
  (((pRangeDetect '"' '"' >>= withAttribute StringTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Line Comment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Block Comment"))
   <|>
   ((pLineContinue >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","Preprocessor")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Pike","Outscoped") =
  (((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute AlertTok))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Block Comment"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("Pike","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28endif'7celif'7celse'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","Outscoped")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Pike","Outscoped intern") =
  (((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Pike","Block Comment"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("Pike","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pike","Outscoped intern")) >> pDefault >>= withAttribute CommentTok))


parseRules x = parseRules ("Pike","Normal") <|> fail ("Unknown context" ++ show x)
