
# [<img src="http://haxe.org/img/haxe-logo-horizontal.svg" alt="Haxe logo" width="140">](https://haxe.org) - [The Cross-Platform Toolkit](https://haxe.org)
[![TravisCI Build Status](https://travis-ci.org/HaxeFoundation/haxe.svg?branch=development)](https://travis-ci.org/HaxeFoundation/haxe)
[![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/github/HaxeFoundation/haxe?branch=development&svg=true)](https://ci.appveyor.com/project/HaxeFoundation/haxe)
[![SauceLabs Test Status](https://saucelabs.com/buildstatus/haxe)](https://saucelabs.com/u/haxe)
[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/HaxeFoundation/haxe?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

Haxe is an open source toolkit that allows you to easily build cross-platform tools and applications that target many mainstream platforms. The Haxe toolkit includes:

 * **The Haxe programming language**, a modern, high-level, strictly-typed programming language
 * **The Haxe cross-compiler**, a state-of-the-art, lightning-speed compiler for many targets
 * **The Haxe standard library**, a complete, cross-platform library of common functionality

Haxe allows you to compile for the following targets:

 * ActionScript 3
 * C++
 * C#
 * Flash
 * Java
 * JavaScript
 * NekoVM
 * PHP
 * Python
 * Lua
 * [HashLink](http://hashlink.haxe.org/)

You can try Haxe directly from your browser at [try.haxe.org](http://try.haxe.org)!

For more information about Haxe, head to the [offical Haxe website](https://haxe.org).

## License

The Haxe project has several licenses, covering different parts of the projects.

 * The Haxe compiler is released under the GNU General Public License version 2 or any later version.
 * The Haxe standard library is released under the MIT license.
 * The Neko virtual machine is released under the MIT license. Its bundled runtime libraries (ndll) and tools are released under open source licenses as described in https://github.com/HaxeFoundation/neko/blob/master/LICENSE

For the complete Haxe licenses, please see https://haxe.org/foundation/open-source.html or [extra/LICENSE.txt](extra/LICENSE.txt).

## Installing Haxe

The latest stable release is available at [https://haxe.org/download/](https://haxe.org/download/). Pre-built binaries are available for your platform:

 * **[Windows installer](https://haxe.org/download/file/latest/haxe-latest-win.exe/)**
 * **[Windows binaries](https://haxe.org/download/file/latest/haxe-latest-win.zip/)**
 * **[OSX installer](https://haxe.org/download/file/latest/haxe-latest-osx-installer.pkg/)**
 * **[OSX binaries](https://haxe.org/download/file/latest/haxe-latest-osx.tar.gz/)**
 * **[Linux Software Packages](https://haxe.org/download/linux/)**
 * **[Linux 32-bit binaries](https://haxe.org/download/file/latest/haxe-latest-linux32.tar.gz/)**
 * **[Linux 64-bit binaries](https://haxe.org/download/file/latest/haxe-latest-linux64.tar.gz/)**

Automated development builds are available from [build.haxe.org](http://build.haxe.org).

## Building from source

 1. Clone the repository using git. Be sure to initialize and fetch the submodules.

        git clone --recursive git://github.com/HaxeFoundation/haxe.git
        cd haxe

 2. Follow the [documentation on building Haxe for your platform](https://haxe.org/documentation/introduction/building-haxe.html).

## Using Haxe

For information on on using Haxe, consult the [Haxe documentation](https://haxe.org/documentation/):

 * [Haxe Introduction](https://haxe.org/documentation/introduction/), an introduction to the Haxe toolkit
 * [The Haxe Manual](https://haxe.org/manual/), the reference manual for the Haxe language
 * [Haxe Code Cookbook](http://code.haxe.org), code snippets / learning resource
 * [Haxe API](http://api.haxe.org), documentation for the Haxe standard and native APIs
 * [Haxelib](https://lib.haxe.org), a repository of Haxe libraries for a variety of needs

## Community

You can get help and talk with fellow Haxers from around the world via:

 * [Haxe on Stack Overflow](http://stackoverflow.com/questions/tagged/haxe)
 * the [official Haxe Google Group](https://groups.google.com/forum/#!forum/haxelang)
 * [#Haxe on Twitter](https://twitter.com/hashtag/haxe?src=hash)
 * the [Haxe IRC chatroom](http://unic0rn.github.io/tiramisu/haxe), #haxe on chat.freenode.net

:+1: Get notified of the latest Haxe news, follow us on [Twitter](https://twitter.com/haxelang), [Facebook](https://www.facebook.com/haxe.org) or [Google+](https://plus.google.com/+HaxeOrg)

## Version compatibility

Haxe   | neko
----   | -----
2.*    | 1.*
3.0.0  | 2.0.0
3.1.3  | 2.0.0
3.2.0  | 2.0.0
3.3.0  | 2.1.0
3.4.0  | 2.1.0


## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for more. Thank you!
