#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Our Life: Beginnings & Always
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250514.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='our-life-beginning-and-always'
GAME_NAME='Our Life: Beginnings & Always'

ARCHIVE_BASE_0_NAME='our_life_beginnings_always_1_6_2_59318.sh'
ARCHIVE_BASE_0_MD5='543ec491817a024342902bd379d56fe6'
ARCHIVE_BASE_0_SIZE='853527'
ARCHIVE_BASE_0_VERSION='1.6.2-gog59318'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/our_life_beginnings_always'

CONTENT_PATH_DEFAULT='data/noarch/game/game'
CONTENT_GAME_MAIN_FILES='
icon.icns
icon.ico
archive.rpa
script_version.txt'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='icon.ico'

## Ensure easy upgrades from pre-20250514.1 packages.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
our-life-beginning-and-always-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
